/*
 * Decompiled with CFR 0.152.
 */
package GameExample;

import Entity.CBoard;
import Entity.CListMap;
import Framework.CDefine;
import Framework.CGameScreen;
import Framework.CRect;
import Framework.CScreenManager;
import Framework.CVector2D;
import GameExample.CPauseScreen;
import GameExample.CWinScreen;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CMainGameScreen
implements CGameScreen {
    public static CBoard mainBoard;
    public CRect btnPause;
    public static boolean isPauseGame;
    public static boolean isWin;
    CScreenManager cScreenManager;

    public CMainGameScreen(int _idMap, CScreenManager c) {
        CListMap listmap = new CListMap();
        this.cScreenManager = c;
        mainBoard = new CBoard((int[][])CListMap.listMaps.elementAt(_idMap), _idMap, this.cScreenManager);
        this.LoadContent();
    }

    public void LoadContent() {
        if (CDefine.isTouch) {
            this.btnPause = new CRect(CDefine.Touch_MainGame_Button_Pause_Pos_x, CDefine.Touch_MainGame_Button_Pause_Pos_y, CDefine.Touch_MainGame_Button_Pause_Width, CDefine.Touch_MainGame_Button_Pause_Height);
        }
        mainBoard.LoadContent();
        if (CDefine.isType) {
            CDefine.MainGame_Old_KeyPad = CDefine.Keypad_Num_5;
        }
    }

    public void keyHnd(int keys) {
        if (CDefine.isType && CDefine.isKedPadEnabled) {
            mainBoard.handle(keys);
            if (keys == CDefine.Keypad_None) {
                CDefine.MainGame_Old_KeyPad = CDefine.Keypad_None;
            } else if (keys == CDefine.Keypad_Num_Thang && keys != CDefine.MainGame_Old_KeyPad) {
                CDefine.MainGame_Old_KeyPad = keys;
                if (CDefine.sound) {
                    this.cScreenManager.soundManager.startPlay();
                }
                isPauseGame = true;
                this.cScreenManager.addScreen(new CPauseScreen(this.cScreenManager));
            }
        }
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        if (CDefine.isTouch) {
            if (this.btnPause.Containt(x, y)) {
                if (CDefine.sound) {
                    this.cScreenManager.soundManager.startPlay();
                }
                CDefine.MainGame_Old_KeyPad = CDefine.Keypad_Num_Thang;
                isPauseGame = true;
                this.cScreenManager.addScreen(new CPauseScreen(this.cScreenManager));
            } else {
                mainBoard.UpdateInput(new CVector2D(x, y));
            }
        }
    }

    public void update(long elapsedTime) {
        if (isWin) {
            isPauseGame = true;
            this.cScreenManager.addScreen(new CWinScreen(this.cScreenManager));
        }
        if (!isPauseGame) {
            mainBoard.update(elapsedTime);
        }
    }

    public void draw(Graphics g) {
        mainBoard.draw(g);
        Font smallFont = Font.getFont((int)64, (int)0, (int)16);
        g.setFont(smallFont);
        g.setColor(CDefine.MainGame_Color_r, CDefine.MainGame_Color_g, CDefine.MainGame_Color_b);
        g.drawString(String.valueOf(CBoard.idMap + 1), CDefine.MainGame_String_Level_Pos_x, CDefine.MainGame_String_Level_Pos_y, 20);
        g.drawString(String.valueOf(CMainGameScreen.mainBoard.countMove), CDefine.MainGame_String_Move_Pos_x, CDefine.MainGame_String_Move_Pos_y, 20);
    }

    public void unloadResources() {
    }

    static {
        isPauseGame = false;
        isWin = false;
    }
}

