/*
 * Decompiled with CFR 0.152.
 */
public class PVector {
    public float x;
    public float y;
    public float z;
    protected float[] array;

    public PVector() {
    }

    public PVector(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PVector(float x, float y) {
        this.x = x;
        this.y = y;
        this.z = 0.0f;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(PVector v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void set(float[] source) {
        if (source.length >= 2) {
            this.x = source[0];
            this.y = source[1];
        }
        if (source.length >= 3) {
            this.z = source[2];
        }
    }

    public PVector get() {
        return new PVector(this.x, this.y, this.z);
    }

    public float[] get(float[] target) {
        if (target == null) {
            return new float[]{this.x, this.y, this.z};
        }
        if (target.length >= 2) {
            target[0] = this.x;
            target[1] = this.y;
        }
        if (target.length >= 3) {
            target[2] = this.z;
        }
        return target;
    }

    public float mag() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void add(PVector v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public static PVector add(PVector v1, PVector v2) {
        return PVector.add(v1, v2, null);
    }

    public static PVector add(PVector v1, PVector v2, PVector target) {
        if (target == null) {
            target = new PVector(v1.x + v2.x, v1.y + v2.y, v1.z + v2.z);
        } else {
            target.set(v1.x + v2.x, v1.y + v2.y, v1.z + v2.z);
        }
        return target;
    }

    public void sub(PVector v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public void sub(float x, float y, float z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
    }

    public static PVector sub(PVector v1, PVector v2) {
        return PVector.sub(v1, v2, null);
    }

    public static PVector sub(PVector v1, PVector v2, PVector target) {
        if (target == null) {
            target = new PVector(v1.x - v2.x, v1.y - v2.y, v1.z - v2.z);
        } else {
            target.set(v1.x - v2.x, v1.y - v2.y, v1.z - v2.z);
        }
        return target;
    }

    public void mult(float n) {
        this.x *= n;
        this.y *= n;
        this.z *= n;
    }

    public static PVector mult(PVector v, float n) {
        return PVector.mult(v, n, null);
    }

    public static PVector mult(PVector v, float n, PVector target) {
        if (target == null) {
            target = new PVector(v.x * n, v.y * n, v.z * n);
        } else {
            target.set(v.x * n, v.y * n, v.z * n);
        }
        return target;
    }

    public void mult(PVector v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
    }

    public static PVector mult(PVector v1, PVector v2) {
        return PVector.mult(v1, v2, null);
    }

    public static PVector mult(PVector v1, PVector v2, PVector target) {
        if (target == null) {
            target = new PVector(v1.x * v2.x, v1.y * v2.y, v1.z * v2.z);
        } else {
            target.set(v1.x * v2.x, v1.y * v2.y, v1.z * v2.z);
        }
        return target;
    }

    public void div(float n) {
        this.x /= n;
        this.y /= n;
        this.z /= n;
    }

    public static PVector div(PVector v, float n) {
        return PVector.div(v, n, null);
    }

    public static PVector div(PVector v, float n, PVector target) {
        if (target == null) {
            target = new PVector(v.x / n, v.y / n, v.z / n);
        } else {
            target.set(v.x / n, v.y / n, v.z / n);
        }
        return target;
    }

    public void div(PVector v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
    }

    public static PVector div(PVector v1, PVector v2) {
        return PVector.div(v1, v2, null);
    }

    public static PVector div(PVector v1, PVector v2, PVector target) {
        if (target == null) {
            target = new PVector(v1.x / v2.x, v1.y / v2.y, v1.z / v2.z);
        } else {
            target.set(v1.x / v2.x, v1.y / v2.y, v1.z / v2.z);
        }
        return target;
    }

    public float dist(PVector v) {
        float dx = this.x - v.x;
        float dy = this.y - v.y;
        float dz = this.z - v.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static float dist(PVector v1, PVector v2) {
        float dx = v1.x - v2.x;
        float dy = v1.y - v2.y;
        float dz = v1.z - v2.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public float dot(PVector v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public float dot(float x, float y, float z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public static float dot(PVector v1, PVector v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
    }

    public PVector cross(PVector v) {
        return this.cross(v, null);
    }

    public PVector cross(PVector v, PVector target) {
        float crossX = this.y * v.z - v.y * this.z;
        float crossY = this.z * v.x - v.z * this.x;
        float crossZ = this.x * v.y - v.x * this.y;
        if (target == null) {
            target = new PVector(crossX, crossY, crossZ);
        } else {
            target.set(crossX, crossY, crossZ);
        }
        return target;
    }

    public static PVector cross(PVector v1, PVector v2, PVector target) {
        float crossX = v1.y * v2.z - v2.y * v1.z;
        float crossY = v1.z * v2.x - v2.z * v1.x;
        float crossZ = v1.x * v2.y - v2.x * v1.y;
        if (target == null) {
            target = new PVector(crossX, crossY, crossZ);
        } else {
            target.set(crossX, crossY, crossZ);
        }
        return target;
    }

    public void normalize() {
        float m = this.mag();
        if (m != 0.0f && m != 1.0f) {
            this.div(m);
        }
    }

    public PVector normalize(PVector target) {
        float m;
        if (target == null) {
            target = new PVector();
        }
        if ((m = this.mag()) > 0.0f) {
            target.set(this.x / m, this.y / m, this.z / m);
        } else {
            target.set(this.x, this.y, this.z);
        }
        return target;
    }

    public void limit(float max) {
        if (this.mag() > max) {
            this.normalize();
            this.mult(max);
        }
    }

    public String toString() {
        return "[ " + this.x + ", " + this.y + ", " + this.z + " ]";
    }

    public float[] array() {
        if (this.array == null) {
            this.array = new float[3];
        }
        this.array[0] = this.x;
        this.array[1] = this.y;
        this.array[2] = this.z;
        return this.array;
    }
}

