/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.raw.Body;
import net.phys2d.raw.collide.Collider;
import net.phys2d.raw.collide.ColliderUnavailableException;
import net.phys2d.raw.collide.PolygonPolygonCollider;
import net.phys2d.raw.shapes.Polygon;
import net.phys2d.raw.shapes.Shape;

public class ColliderFactory {
    public Collider createCollider(Body bodyA, Body bodyB) throws ColliderUnavailableException {
        Shape shapeA = bodyA.getShape();
        Shape shapeB = bodyB.getShape();
        if (shapeA instanceof Polygon) {
            return this.createColliderFor((Polygon)shapeA, shapeB);
        }
        throw new ColliderUnavailableException(shapeA, shapeB);
    }

    public Collider createColliderFor(Polygon shapeA, Shape shapeB) throws ColliderUnavailableException {
        if (shapeB instanceof Polygon) {
            return new PolygonPolygonCollider();
        }
        throw new ColliderUnavailableException(shapeA, shapeB);
    }
}

