/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import com.shephertz.app42.paas.sdk.jme.ServiceAPI;
import com.shephertz.app42.paas.sdk.jme.game.Game;
import com.shephertz.app42.paas.sdk.jme.game.ScoreBoardService;
import component.CSoundPlayer;
import component.CSpriteAnimation;
import component.CUtility;
import component.customFont;
import component.gameData;
import constants.CGameTexts;
import game.CCanvas;
import game.CMainGameManager;
import ingame.CIngameManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CGameOverScreen {
    private int iScore;
    private int iCoinCollected;
    private int iDistance;
    private int iStartY;
    private boolean isPopupState = false;
    private CSpriteAnimation animCoin;
    private Image imgAamirFace;
    private Image imgBtnRetry;
    private Image imgBtnNext;
    private Image imgBtnSubmit;
    private Image imgBtnHome;
    private Image imgBtnFb;
    private Image imgBg;
    private Image imgHeader;
    private customFont objHilightFontBig;
    private customFont objHilightFontSmall;
    private String[] strSplit;
    private CSoundPlayer objSoundPlayer;
    private boolean isPlayingSound;
    private final int SubState_FirstScreen;
    private final int SubState_Fb_UserName;
    private final int SubState_LeaderBoard_Submit;
    private final int SubState_AskforFb;
    private final int SubState_Fb_Status_Update;
    private final int SubState_Successfully_Update;
    private final int SubState_Error;
    private int Current_SubState = 1;
    private int iFontHeight;
    private int iX;
    private int iY;
    private int iPopupX;
    private int iPopupY;
    private int ipopupWidth;
    private int iPopupHeight;
    private String[][] strSplitDialog = new String[CGameTexts.strArrConnectionMsg.length][];
    private int iDotIndex = 0;
    private boolean isPrintOnce = false;
    public static boolean isNewHighScore = false;

    public CGameOverScreen(int score, int coin, int dist) {
        this.SubState_FirstScreen = 1;
        this.SubState_Fb_UserName = 2;
        this.SubState_LeaderBoard_Submit = 3;
        this.SubState_AskforFb = 4;
        this.SubState_Fb_Status_Update = 5;
        this.SubState_Successfully_Update = 6;
        this.SubState_Error = 7;
        this.iScore = score;
        this.iCoinCollected = coin;
        this.iDistance = dist;
        this.iStartY = CCanvas.iScreenH >> 3;
        this.animCoin = new CSpriteAnimation("/coin.png", 4, 2, false, false);
        try {
            this.imgBg = Image.createImage((String)"/menu_bg.png");
            this.imgAamirFace = Image.createImage((String)"/popup_aamir.png");
            this.imgBtnRetry = Image.createImage((String)"/retry.png");
            this.imgBtnNext = Image.createImage((String)"/next.png");
            this.imgBtnSubmit = Image.createImage((String)"/submit.png");
            this.imgBtnHome = Image.createImage((String)"/home.png");
            this.imgBtnFb = Image.createImage((String)"/facebook_button.png");
            this.imgHeader = Image.createImage((String)"/game_logo.png");
            this.objHilightFontBig = new customFont(3);
            this.objHilightFontSmall = new customFont(4);
            this.objSoundPlayer = new CSoundPlayer();
            this.objSoundPlayer.loadSound(new String[]{"/sound/menu.mid"});
        }
        catch (Exception ex) {
            // empty catch block
        }
        int iTmp = CUtility.getRandomNumberInRange(0, 100) % CGameTexts.strGameOver.length;
        this.strSplit = CUtility.getTextRows(CGameTexts.strGameOver[iTmp], CIngameManager.getInstance().objSmallFont, CCanvas.iScreenW - (CCanvas.iScreenW >> 3) - this.imgAamirFace.getWidth());
        this.isPlayingSound = false;
        this.iFontHeight = CIngameManager.getInstance().objSmallFont.getHeight();
        this.iX = CCanvas.iScreenW >> 1;
        this.iPopupX = CCanvas.iScreenW >> 5;
        this.iPopupY = CCanvas.iScreenH - CCanvas.iScreenH / 3;
        this.ipopupWidth = CCanvas.iScreenW - (CCanvas.iScreenW >> 4);
        this.iPopupHeight = CCanvas.iScreenH >> 2;
        this.iY = this.iPopupY + (this.iPopupHeight >> 1);
        for (int i2 = 0; i2 < this.strSplitDialog.length; ++i2) {
            this.strSplitDialog[i2] = CUtility.getTextRows(CGameTexts.strArrConnectionMsg[i2], CIngameManager.getInstance().objSmallFont, CCanvas.iScreenW - ((CCanvas.iScreenW >> 4) + this.iFontHeight));
        }
    }

    public void unload() {
        if (this.objSoundPlayer != null) {
            if (gameData.getData(4) == 0) {
                this.objSoundPlayer.stopSound(0);
            }
            this.objSoundPlayer.unloadSound();
            this.objSoundPlayer = null;
        }
        this.animCoin = null;
        this.imgAamirFace = null;
        this.imgBg = null;
        this.imgBtnRetry = null;
        this.imgBtnNext = null;
        this.imgBtnSubmit = null;
        this.imgBtnHome = null;
        this.imgBtnFb = null;
        this.imgHeader = null;
        this.objHilightFontBig = null;
        this.objHilightFontSmall = null;
        this.isPlayingSound = false;
    }

    public void update() {
        this.animCoin.update();
        switch (this.Current_SubState) {
            case 1: {
                if (this.isPlayingSound) break;
                if (gameData.getData(4) == 0) {
                    this.objSoundPlayer.playSound(0, false);
                }
                this.isPlayingSound = true;
                break;
            }
            case 2: {
                if (!this.isPrintOnce) break;
                this.isPrintOnce = false;
                if (CUtility.fbConnect()) {
                    this.Current_SubState = 3;
                    break;
                }
                this.Current_SubState = 7;
                break;
            }
            case 3: {
                if (!this.isPrintOnce) break;
                this.isPrintOnce = false;
                if (this.leaderBoardSubmit()) {
                    this.Current_SubState = 4;
                    break;
                }
                this.Current_SubState = 7;
                break;
            }
            case 5: {
                if (!this.isPrintOnce) break;
                this.isPrintOnce = false;
                this.Current_SubState = CUtility.fbStatusUpdate(gameData.getString(11), this.iScore) ? 6 : 7;
            }
        }
    }

    public void handleInput(int key, boolean isPressed) {
        if (!isPressed) {
            if (!this.isPopupState) {
                if (key == 211) {
                    if (gameData.getData(5) >= 1) {
                        CIngameManager.getInstance().switchToStates(2);
                    } else {
                        CIngameManager.getInstance().setCurrentBike(0);
                        CIngameManager.getInstance().switchToStates(0);
                    }
                } else if (key == 212 && isNewHighScore) {
                    this.isPopupState = true;
                } else {
                    CMainGameManager.getInstance().switchToStates(1);
                }
            } else if (key == 211) {
                switch (this.Current_SubState) {
                    case 1: {
                        System.out.println("in side ");
                        if (gameData.getString(11).equalsIgnoreCase("")) {
                            this.objSoundPlayer.stopSound(0);
                            this.Current_SubState = 2;
                            break;
                        }
                        System.out.println("submiting");
                        this.Current_SubState = 3;
                        break;
                    }
                    case 4: {
                        this.Current_SubState = 5;
                    }
                }
            } else if (key == 212) {
                CMainGameManager.getInstance().switchToStates(1);
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        if (iTouchState == 2) {
            if (!this.isPopupState) {
                if (CUtility.isLSKPressed(pointerX, pointerY)) {
                    if (gameData.getData(5) >= 1) {
                        CIngameManager.getInstance().switchToStates(2);
                    } else {
                        CIngameManager.getInstance().setCurrentBike(0);
                        CIngameManager.getInstance().switchToStates(0);
                    }
                } else if (CUtility.isRSKPressed(pointerX, pointerY) && isNewHighScore) {
                    this.isPopupState = true;
                } else {
                    CMainGameManager.getInstance().switchToStates(1);
                }
            } else {
                System.out.println("current substate " + this.Current_SubState);
                if (CUtility.isLSKPressed(pointerX, pointerY)) {
                    switch (this.Current_SubState) {
                        case 1: {
                            System.out.println("in side ");
                            if (gameData.getString(11).equalsIgnoreCase("")) {
                                this.objSoundPlayer.stopSound(0);
                                this.Current_SubState = 2;
                                break;
                            }
                            System.out.println("submiting");
                            this.Current_SubState = 3;
                            break;
                        }
                        case 4: {
                            this.Current_SubState = 5;
                        }
                    }
                }
                if (CUtility.isRSKPressed(pointerX, pointerY)) {
                    CMainGameManager.getInstance().switchToStates(1);
                }
            }
        }
    }

    public void paint(Graphics g2) {
        int iTextHeightSmall = CIngameManager.getInstance().objSmallFont.getHeight();
        int iTextHeightBig = CIngameManager.getInstance().objBigFont.getHeight();
        int iTotalHeight = iTextHeightBig * 3 + iTextHeightSmall * 3 + (iTextHeightSmall >> 2) * 5;
        this.iStartY = (CCanvas.iScreenH >> 1) - (iTotalHeight >> 1) - iTextHeightBig;
        g2.drawImage(this.imgBg, CCanvas.iScreenW >> 1, CCanvas.iScreenH, 33);
        g2.drawImage(this.imgHeader, CCanvas.iScreenW >> 1, 0, 17);
        CUtility.drawBorder(g2, (CCanvas.iScreenW >> 4) + (CCanvas.iScreenW >> 5), CCanvas.iScreenH >> 2, CCanvas.iScreenW - (CCanvas.iScreenW >> 3) - (CCanvas.iScreenW >> 4), CCanvas.iScreenH >> 1);
        g2.setColor(0x2A2A2A);
        g2.fillRect(0, CCanvas.iScreenH - (CCanvas.iScreenH >> 2) - (CCanvas.iScreenH >> 4), CCanvas.iScreenW, CCanvas.iScreenH >> 3);
        g2.setColor(0xFFFFFF);
        g2.drawRect(-1, CCanvas.iScreenH - (CCanvas.iScreenH >> 2) - (CCanvas.iScreenH >> 4), CCanvas.iScreenW + 2, CCanvas.iScreenH >> 3);
        g2.drawImage(this.imgAamirFace, CCanvas.iScreenW >> 4, CCanvas.iScreenH - (CCanvas.iScreenH >> 2), 6);
        int iFontH = CIngameManager.getInstance().objSmallFont.getHeight();
        int iTmpY = CCanvas.iScreenH - (CCanvas.iScreenH >> 2) - (this.strSplit.length * iFontH >> 1);
        for (int i2 = 0; i2 < this.strSplit.length; ++i2) {
            CIngameManager.getInstance().objSmallFont.drawString(this.strSplit[i2], CCanvas.iScreenW + this.imgAamirFace.getWidth() >> 1, iTmpY + i2 * iFontH, g2, 17);
        }
        this.objHilightFontBig.drawString("Score", CCanvas.iScreenW >> 1, this.iStartY, g2, 17);
        this.iStartY = this.iStartY + iTextHeightBig + (iTextHeightSmall >> 2);
        this.objHilightFontSmall.drawString("" + this.iScore, CCanvas.iScreenW >> 1, this.iStartY, g2, 17);
        this.iStartY = this.iStartY + iTextHeightSmall + (iTextHeightSmall >> 1);
        CIngameManager.getInstance().objBigFont.drawString("Coins Collected", CCanvas.iScreenW >> 1, this.iStartY, g2, 17);
        this.iStartY = this.iStartY + iTextHeightBig + (iTextHeightSmall >> 2);
        this.animCoin.paint(g2, (CCanvas.iScreenW >> 1) - (CIngameManager.getInstance().objSmallFont.stringWidth("" + this.iCoinCollected) >> 1) - this.animCoin.getCurFrameWidth(), this.iStartY, 24);
        CIngameManager.getInstance().objSmallFont.drawString("" + this.iCoinCollected, CCanvas.iScreenW >> 1, this.iStartY, g2, 17);
        this.iStartY = this.iStartY + iTextHeightSmall + (iTextHeightSmall >> 1);
        CIngameManager.getInstance().objBigFont.drawString("Distance Covered", CCanvas.iScreenW >> 1, this.iStartY, g2, 17);
        this.iStartY = this.iStartY + iTextHeightBig + (iTextHeightSmall >> 2);
        CIngameManager.getInstance().objSmallFont.drawString("" + this.iDistance + " m", CCanvas.iScreenW >> 1, this.iStartY, g2, 17);
        if (this.isPopupState) {
            switch (this.Current_SubState) {
                case 1: {
                    this.drawPopup(g2);
                    CIngameManager.getInstance().objSmallFont.drawString("Your score is " + this.iScore, CCanvas.iScreenW >> 1, CCanvas.iScreenH - CCanvas.iScreenH / 3 + (CCanvas.iScreenH >> 3) - CIngameManager.getInstance().objSmallFont.getHeight(), g2, 3);
                    CIngameManager.getInstance().objSmallFont.drawString("Do you want to submit your Score?", CCanvas.iScreenW >> 1, CCanvas.iScreenH - CCanvas.iScreenH / 3 + (CCanvas.iScreenH >> 3) + CIngameManager.getInstance().objSmallFont.getHeight(), g2, 3);
                    CUtility.paintSoftKeys(g2, this.imgBtnSubmit, this.imgBtnHome);
                    break;
                }
                case 2: {
                    this.drawPopup(g2);
                    this.drawMsg(this.Current_SubState - 2, g2, true);
                    CUtility.paintSoftKeys(g2, null, this.imgBtnHome);
                    this.isPrintOnce = true;
                    break;
                }
                case 3: {
                    this.drawPopup(g2);
                    this.drawMsg(this.Current_SubState - 2, g2, true);
                    CUtility.paintSoftKeys(g2, null, this.imgBtnHome);
                    this.isPrintOnce = true;
                    break;
                }
                case 4: {
                    this.drawPopup(g2);
                    this.drawMsg(this.Current_SubState - 2, g2, false);
                    CUtility.paintSoftKeys(g2, this.imgBtnFb, this.imgBtnHome);
                    break;
                }
                case 5: {
                    this.drawPopup(g2);
                    this.drawMsg(this.Current_SubState - 2, g2, true);
                    CUtility.paintSoftKeys(g2, null, this.imgBtnHome);
                    this.isPrintOnce = true;
                    break;
                }
                case 6: {
                    this.drawPopup(g2);
                    this.drawMsg(this.Current_SubState - 2, g2, false);
                    CUtility.paintSoftKeys(g2, null, this.imgBtnHome);
                    break;
                }
                case 7: {
                    this.drawPopup(g2);
                    this.drawMsg(this.Current_SubState - 2, g2, false);
                    CUtility.paintSoftKeys(g2, null, this.imgBtnHome);
                }
            }
        } else if (isNewHighScore) {
            CUtility.paintSoftKeys(g2, this.imgBtnRetry, this.imgBtnNext);
        } else {
            CUtility.paintSoftKeys(g2, this.imgBtnRetry, this.imgBtnHome);
        }
    }

    private void drawMsg(int iIndex, Graphics g2, boolean isDot) {
        int iTotalMsgRow = this.strSplitDialog[iIndex].length;
        int iStrY = 0;
        iStrY = iTotalMsgRow % 2 == 0 ? this.iY - ((iTotalMsgRow - 1) * this.iFontHeight >> 1) : this.iY - (iTotalMsgRow - 1 >> 1) * this.iFontHeight;
        for (int i2 = 0; i2 < iTotalMsgRow; ++i2) {
            CIngameManager.getInstance().objSmallFont.drawString(this.strSplitDialog[iIndex][i2], this.iX, iStrY + this.iFontHeight * i2, g2, 3);
            if (!isDot) continue;
            CIngameManager.getInstance().objSmallFont.drawString("...", this.iX + (CIngameManager.getInstance().objSmallFont.stringWidth(this.strSplitDialog[iIndex][i2]) >> 1), iStrY + this.iFontHeight * i2, g2, 6);
        }
    }

    private void drawPopup(Graphics g2) {
        g2.setColor(0x2A2A2A);
        g2.fillRoundRect(this.iPopupX, this.iPopupY, this.ipopupWidth, this.iPopupHeight, 25, 25);
        g2.setColor(0xDDDDDD);
        g2.drawRoundRect(this.iPopupX, this.iPopupY, this.ipopupWidth, this.iPopupHeight, 25, 25);
    }

    private boolean leaderBoardSubmit() {
        try {
            ServiceAPI sp = new ServiceAPI("5c644cc503e672487d17480cc119ec70538e805e7ad3677f8db0fd11063511ca", "a092f4bcb960437f8dfa9cf412108ab32512c7a68b6bc8367a059a101ed890ec");
            ScoreBoardService sbs = sp.buildScoreBoardService();
            Game gameScore = sbs.saveUserScore("Dhoom:3 The Game", gameData.getString(11), this.iScore);
            System.out.println("try leaderboard " + gameScore);
            return gameScore.isResponseSuccess();
        }
        catch (Exception e2) {
            System.out.println("leaderboard connect .. " + e2);
            return false;
        }
    }
}

