/*
 * Decompiled with CFR 0.152.
 */
package mainmenu;

import component.CSoundPlayer;
import component.CUtility;
import component.customFont;
import component.gameData;
import constants.CPortingValues;
import game.CCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mainmenu.CMainMenuManager;

public class CMainMenu {
    static int menuIdx;
    private boolean isGameExit;
    private Image imageMenuBG;
    private Image imageMenuLogo;
    private Image imageMenuButton;
    private Image imageExit;
    private Image imageYes;
    private Image imageNo;
    private Image imageSelect;
    private Image imageAamir;
    static final String[] strMenu;
    static final String[] strSound;
    private int iMenuLogoX;
    private int iMenuLogoY;
    private int iMenuBGX;
    private int iMenuBGY;
    private int iMenuButtonStartX;
    private int iMenuButtonStartY;
    private int[] iMenuButtonY;
    private int iMenuButtonGap;
    private int iSoundState;
    private customFont objMenuFont;
    private customFont objMenuRollFont;
    private CSoundPlayer objMenuSound;

    public CMainMenu() {
        menuIdx = 0;
        this.isGameExit = false;
        this.objMenuFont = new customFont(2);
        this.objMenuRollFont = new customFont(3);
        this.objMenuSound = new CSoundPlayer();
        this.iSoundState = gameData.getData(4);
        this.loadImages();
        this.prepareMenuAnimation();
        if (this.iSoundState == 0 && this.objMenuSound != null) {
            this.objMenuSound.playSound(0, true);
        }
    }

    public void prepareMenuAnimation() {
        this.iMenuLogoX = (CCanvas.iScreenW - this.imageMenuLogo.getWidth()) / 2;
        this.iMenuLogoY = 0;
        this.iMenuBGX = (CCanvas.iScreenW - this.imageMenuBG.getWidth()) / 2;
        this.iMenuBGY = CCanvas.iScreenH;
        this.iMenuButtonStartX = CCanvas.iScreenW >> 1;
        this.iMenuButtonStartY = this.imageMenuLogo.getHeight() + this.imageMenuButton.getHeight();
        this.iMenuButtonGap = Math.abs(CCanvas.iScreenH - this.imageMenuLogo.getHeight() - (this.imageExit.getHeight() + (this.imageExit.getHeight() >> 1)) - this.imageMenuButton.getHeight() * CPortingValues.iMaxLabelsOnMenu) / 4;
        this.iMenuButtonStartY = this.imageMenuLogo.getHeight() + this.iMenuButtonGap;
        if (this.iMenuButtonGap > this.imageMenuButton.getHeight()) {
            this.iMenuButtonGap = this.imageMenuButton.getHeight() >> 1;
            this.iMenuButtonStartY = this.imageMenuLogo.getHeight() + this.imageMenuButton.getHeight() + this.iMenuButtonGap;
        }
        this.iMenuButtonY = new int[CPortingValues.iMaxLabelsOnMenu];
        for (int i2 = 0; i2 < CPortingValues.iMaxLabelsOnMenu; ++i2) {
            this.iMenuButtonY[i2] = this.iMenuButtonStartY + (this.imageMenuButton.getHeight() + this.iMenuButtonGap) * i2;
        }
    }

    public void loadImages() {
        try {
            this.imageMenuBG = Image.createImage((String)"/menu_bg.png");
            this.imageMenuLogo = Image.createImage((String)"/game_logo.png");
            this.imageMenuButton = Image.createImage((String)"/menu_button.png");
            this.imageExit = Image.createImage((String)"/exit.png");
            this.imageYes = Image.createImage((String)"/yes.png");
            this.imageNo = Image.createImage((String)"/no.png");
            this.imageSelect = Image.createImage((String)"/next.png");
            this.imageAamir = Image.createImage((String)"/popup_aamir.png");
            if (this.objMenuSound != null) {
                this.objMenuSound.loadSound(strSound);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g2) {
        g2.setColor(0);
        g2.fillRect(0, 0, CCanvas.iScreenW, CCanvas.iScreenH);
        g2.drawImage(this.imageMenuBG, this.iMenuBGX, this.iMenuBGY, 36);
        g2.drawImage(this.imageMenuLogo, this.iMenuLogoX, this.iMenuLogoY, 20);
        for (int i2 = 0; i2 < CPortingValues.iMaxLabelsOnMenu; ++i2) {
            if (i2 == menuIdx) {
                g2.drawImage(this.imageMenuButton, this.iMenuButtonStartX, this.iMenuButtonY[i2], 17);
                this.objMenuRollFont.drawString(strMenu[i2], this.iMenuButtonStartX >> 1, this.iMenuButtonY[i2] + 5, g2, 5);
                continue;
            }
            g2.drawImage(this.imageMenuButton, this.iMenuButtonStartX, this.iMenuButtonY[i2], 17);
            this.objMenuFont.drawString(strMenu[i2], this.iMenuButtonStartX >> 1, this.iMenuButtonY[i2] + 5, g2, 5);
        }
        if (this.isGameExit) {
            g2.setColor(0x2A2A2A);
            g2.fillRoundRect(CCanvas.iScreenW >> 5, CCanvas.iScreenH - CCanvas.iScreenH / 3, CCanvas.iScreenW - (CCanvas.iScreenW >> 4), CCanvas.iScreenH >> 2, 25, 25);
            g2.setColor(0xFFFFFF);
            g2.drawRoundRect(CCanvas.iScreenW >> 5, CCanvas.iScreenH - CCanvas.iScreenH / 3, CCanvas.iScreenW - (CCanvas.iScreenW >> 4), CCanvas.iScreenH >> 2, 25, 25);
            g2.drawImage(this.imageAamir, CCanvas.iScreenW >> 5, CCanvas.iScreenH - CCanvas.iScreenH / 3 - this.imageAamir.getHeight() + this.imageAamir.getHeight() / 4, 20);
            this.objMenuFont.drawString("Exit Game?", CCanvas.iScreenW >> 1, CCanvas.iScreenH - CCanvas.iScreenH / 3 + (CCanvas.iScreenH >> 3), g2, 3);
            CUtility.paintSoftKeys(g2, this.imageYes, this.imageNo);
        } else {
            CUtility.paintSoftKeys(g2, this.imageSelect, this.imageExit);
        }
    }

    public void update() {
    }

    public void handleInput(int key, boolean isPressed) {
        if (this.isGameExit && isPressed) {
            switch (key) {
                case 211: {
                    CCanvas.exitGame();
                    break;
                }
                case 212: {
                    this.isGameExit = false;
                }
            }
        } else if (isPressed) {
            switch (key) {
                case 202: {
                    menuIdx = (menuIdx + (CPortingValues.iMaxLabelsOnMenu - 1)) % CPortingValues.iMaxLabelsOnMenu;
                    break;
                }
                case 208: {
                    ++menuIdx;
                    menuIdx %= CPortingValues.iMaxLabelsOnMenu;
                    break;
                }
                case 205: 
                case 211: {
                    if (this.iSoundState == 0 && this.objMenuSound != null) {
                        this.objMenuSound.stopSound(0);
                    }
                    CMainMenuManager.getInstance().switchToStates(menuIdx);
                    break;
                }
                case 212: {
                    this.isGameExit = true;
                }
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        block9: {
            int i2;
            block10: {
                block11: {
                    if (iTouchState == 0 && !this.isGameExit) {
                        for (i2 = 0; i2 < CPortingValues.iMaxLabelsOnMenu; ++i2) {
                            if (!CUtility.isPointInRect(pointerX, pointerY, this.iMenuButtonStartX - (this.imageMenuButton.getWidth() >> 1), this.iMenuButtonY[i2], this.imageMenuButton.getWidth(), this.imageMenuButton.getHeight())) continue;
                            menuIdx = i2;
                        }
                    }
                    if (iTouchState != 2) break block9;
                    if (this.iSoundState == 0 && this.objMenuSound != null) {
                        this.objMenuSound.stopSound(0);
                    }
                    if (!CUtility.isRSKPressed(pointerX, pointerY)) break block10;
                    if (!this.isGameExit) break block11;
                    this.isGameExit = false;
                    if (this.iSoundState != 0 || this.objMenuSound == null) break block9;
                    this.objMenuSound.playSound(0, true);
                    break block9;
                }
                this.isGameExit = true;
                break block9;
            }
            if (CUtility.isLSKPressed(pointerX, pointerY) && this.isGameExit) {
                CCanvas.exitGame();
            } else if (CUtility.isLSKPressed(pointerX, pointerY) && !this.isGameExit) {
                CMainMenuManager.getInstance().switchToStates(menuIdx);
            } else if (!this.isGameExit) {
                for (i2 = 0; i2 < CPortingValues.iMaxLabelsOnMenu; ++i2) {
                    if (!CUtility.isPointInRect(pointerX, pointerY, this.iMenuButtonStartX - (this.imageMenuButton.getWidth() >> 1), this.iMenuButtonY[i2], this.imageMenuButton.getWidth(), this.imageMenuButton.getHeight())) continue;
                    CMainMenuManager.getInstance().switchToStates(menuIdx);
                    break;
                }
            }
        }
    }

    public void gameInterrupted(boolean state) {
        if (state) {
            if (this.iSoundState == 0) {
                this.objMenuSound.stopSound(0);
            }
        } else if (this.iSoundState == 0) {
            this.objMenuSound.playSound(0, true);
        }
    }

    public void unLoadImages() {
        this.imageMenuBG = null;
        this.imageMenuLogo = null;
        this.imageMenuButton = null;
        this.imageExit = null;
        this.imageYes = null;
        this.imageNo = null;
        this.imageSelect = null;
        if (this.objMenuSound != null) {
            this.objMenuSound.stopSound(0);
            this.objMenuSound.unloadSound();
            this.objMenuSound = null;
        }
        this.objMenuFont = null;
        this.objMenuRollFont = null;
    }

    static {
        strMenu = new String[]{"PLAY", "OPTIONS", "STORE", "STATISTICS"};
        strSound = new String[]{"/sound/menu.mid"};
    }
}

