/*
 * Decompiled with CFR 0.152.
 */
package mainmenu;

import component.CSpriteAnimation;
import component.CUtility;
import component.customFont;
import component.gameData;
import constants.CGameTexts;
import constants.CPortingValues;
import game.CCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mainmenu.CMainMenuManager;

public class CStore {
    public static final int INAPPSTORE_SAVE_ME = 0;
    public static final int INAPPSTORE_BULLETBIKE = 1;
    public static final int INAPPSTORE_MISSILEBIKE = 2;
    public static final int INAPPSTORE_MAGNET = 3;
    public static final int INAPPSTORE_SHIELD = 4;
    public static final int MSG_SAVE_ME = 0;
    public static final int MSG_BULLET_BIKE = 1;
    public static final int MSG_MISSILE_BIKE = 2;
    public static final int MSG_BULLET_UPGRAD = 3;
    public static final int MSG_MISSILE_UPGRAD = 4;
    public static final int MSG_MAGNET = 5;
    public static final int MSG_SHIELD = 6;
    public static final int MSG_NO_COIN = 7;
    public static final int MSG_FULLY_UPGRADED = 8;
    private Image imageD3Header;
    private Image imageOptionMenuHeaderBar;
    private Image imageOptionMenuHeader;
    private Image imageUPArrow;
    private Image imageDownArrow;
    private Image[] imageArrInapp;
    private Image imageInappBg;
    private Image imagePowerOn;
    private Image imagePowerOff;
    private Image imageLock;
    private Image imageBackButton;
    private Image imageReturnButton;
    private Image imageNoButton;
    private Image imageYesButton;
    private int iHeaderD3X;
    private int iHeaderD3Y;
    private int iOptionMenuHeaderX;
    private int iOptionMenuHeaderY;
    private int iUpArrowX;
    private int iUpArrowY;
    private int iDownArrowX;
    private int iDownArrowY;
    private int iArrowMoveFacUp;
    private int iArrowMoveFacDown;
    private int iOutSideBorderX;
    private int iOutSideBorderY;
    private int iOutSideBorderWidth;
    private int iOutSideBorderHeight;
    private int iInSideBorderX;
    private int iInSideBorderY;
    private int iInSideBorderWidth;
    private int iInSideBorderHeight;
    private int iMoveSpeed;
    private int iMoveFactor;
    private int iAdjustFactor;
    private int iTotalInappImages = 5;
    private int iSelectInappImageIndex;
    private int iGapBtImages = 0;
    private int iTotalImageOnScreen = 0;
    private int iIndex = 0;
    private int iReleasedIndex = 0;
    private int iCounter = 0;
    private int iStarMagnet;
    private int iStarShield;
    private int iTotalSaveMe;
    private int iTotalBullet;
    private int iTotalMissile;
    private int iCostMagnet;
    private int iCostShield;
    private int iCostBullet;
    private int iCostMissile;
    private int iCostBulletBike;
    private int iCostMissileBike;
    private int iCostSaveMe;
    private int iBikeType;
    private int iCurrentCoinStatus;
    private int iPopupMsgIndex = 0;
    private customFont objSmallFont;
    private customFont objLargeFont;
    private boolean isPopupState = false;
    private boolean[] isArrLock;
    private boolean isUpPressed = false;
    private boolean isDownPressed = false;
    private String[] strArrStatus = new String[2];
    private CSpriteAnimation animCoin;
    private int iTotalStars = 5;
    private String[][] strSplitDialog = new String[CGameTexts.strArrStorePopupMsg.length][];
    private int iFontHeight;
    private int iX;
    private int iY;
    private int iPopupX;
    private int iPopupY;
    private int ipopupWidth;
    private int iPopupHeight;

    public CStore() {
        this.objSmallFont = new customFont(0);
        this.objLargeFont = new customFont(1);
        this.loadImages();
        this.initialize();
    }

    private void loadImages() {
        try {
            this.imageD3Header = Image.createImage((String)"/header_3.png");
            this.imageOptionMenuHeaderBar = Image.createImage((String)"/header_bar.png");
            this.imageOptionMenuHeader = Image.createImage((String)"/header_store.png");
            this.imageUPArrow = Image.createImage((String)"/arrow.png");
            this.imageDownArrow = Image.createImage((Image)this.imageUPArrow, (int)0, (int)0, (int)this.imageUPArrow.getWidth(), (int)this.imageUPArrow.getHeight(), (int)3);
            this.imageArrInapp = new Image[this.iTotalInappImages];
            this.isArrLock = new boolean[this.iTotalInappImages];
            for (int i2 = 0; i2 < this.iTotalInappImages; ++i2) {
                this.imageArrInapp[i2] = Image.createImage((String)("/inapp_" + i2 + ".png"));
                this.setLocked(i2, false);
            }
            this.imageInappBg = Image.createImage((String)"/inapp_bg.png");
            this.imagePowerOn = Image.createImage((String)"/power_on.png");
            this.imagePowerOff = Image.createImage((String)"/power_off.png");
            this.imageLock = Image.createImage((String)"/lock.png");
            this.imageNoButton = Image.createImage((String)"/no.png");
            this.imageYesButton = Image.createImage((String)"/yes.png");
            this.imageReturnButton = Image.createImage((String)"/back.png");
            this.imageBackButton = Image.createImage((String)"/next.png");
            this.imageBackButton = Image.createImage((Image)this.imageBackButton, (int)0, (int)0, (int)this.imageBackButton.getWidth(), (int)this.imageBackButton.getHeight(), (int)2);
            this.animCoin = new CSpriteAnimation("/coin.png", 4, 2, false, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initialize() {
        this.iAdjustFactor = this.imageOptionMenuHeaderBar.getWidth() * 6 / 100;
        int n2 = this.imageD3Header.getWidth() + this.imageOptionMenuHeaderBar.getWidth();
        this.iHeaderD3X = (CCanvas.iScreenW >> 1) - (n2 >> 1);
        this.iHeaderD3Y = this.iAdjustFactor >> 1;
        this.iOptionMenuHeaderX = this.iHeaderD3X + this.imageD3Header.getWidth();
        this.iOptionMenuHeaderY = this.iHeaderD3Y + (this.imageD3Header.getHeight() >> 1) - 3;
        this.iOutSideBorderX = CCanvas.iScreenW * 4 / 100;
        this.iOutSideBorderY = this.iOptionMenuHeaderY;
        this.iOutSideBorderWidth = CCanvas.iScreenW - 2 * this.iOutSideBorderX;
        this.iOutSideBorderHeight = CCanvas.iScreenH - (this.iOutSideBorderY + 37);
        this.iUpArrowX = CCanvas.iScreenW >> 1;
        this.iUpArrowY = this.iHeaderD3Y + this.imageD3Header.getHeight();
        this.iDownArrowX = this.iUpArrowX;
        this.iDownArrowY = this.iOutSideBorderY + this.iOutSideBorderHeight - 2 * this.imageDownArrow.getHeight();
        this.iArrowMoveFacUp = 0;
        this.iArrowMoveFacDown = 0;
        int n3 = this.iDownArrowY - (this.iUpArrowY + this.imageUPArrow.getHeight());
        this.iTotalImageOnScreen = n3 / this.imageArrInapp[0].getHeight();
        if (this.iTotalImageOnScreen > this.imageArrInapp.length) {
            this.iTotalImageOnScreen = this.imageArrInapp.length;
        }
        if (this.iTotalImageOnScreen > 3) {
            --this.iTotalImageOnScreen;
        }
        int n4 = n3 - this.iTotalImageOnScreen * this.imageArrInapp[0].getHeight();
        this.iGapBtImages = n4 / (this.iTotalImageOnScreen + 1);
        this.iInSideBorderX = (CCanvas.iScreenW >> 1) - (this.imageArrInapp[0].getWidth() + this.imageInappBg.getWidth() >> 1);
        this.iInSideBorderY = this.iUpArrowY + this.imageUPArrow.getHeight() + (n3 >> 1) - ((this.iTotalImageOnScreen + 1) * this.iGapBtImages + this.iTotalImageOnScreen * this.imageArrInapp[0].getHeight() >> 1);
        this.iInSideBorderWidth = CCanvas.iScreenW - 2 * this.iInSideBorderX;
        this.iInSideBorderHeight = (this.iTotalImageOnScreen + 1) * this.iGapBtImages + this.iTotalImageOnScreen * this.imageArrInapp[0].getHeight();
        this.iMoveSpeed = this.imageArrInapp[0].getHeight() + this.iGapBtImages;
        this.iMoveFactor = 0;
        this.iSelectInappImageIndex = 0;
        this.iStarMagnet = gameData.getData(6);
        this.iStarShield = gameData.getData(7);
        this.iTotalSaveMe = gameData.getData(16);
        this.iTotalBullet = gameData.getData(8);
        this.iTotalMissile = gameData.getData(9);
        this.iBikeType = gameData.getData(5);
        this.iCostBulletBike = 0;
        this.iCostMissileBike = 0;
        this.iCostMagnet = this.iStarMagnet != this.iTotalStars ? CPortingValues.COST_MAGNET[this.iStarMagnet] : CPortingValues.COST_MAGNET[this.iStarMagnet - 1];
        this.iCostShield = this.iStarShield != this.iTotalStars ? CPortingValues.COST_SHIELD[this.iStarShield] : CPortingValues.COST_SHIELD[this.iStarShield - 1];
        this.iCostSaveMe = 0;
        this.iCostBullet = 0;
        this.iCostMissile = 0;
        this.iCurrentCoinStatus = gameData.getData(1);
        if (this.iBikeType == 0) {
            this.strArrStatus[0] = CGameTexts.strArrStoreBuyStatus[0];
            this.strArrStatus[1] = CGameTexts.strArrStoreBuyStatus[0];
        } else if (this.iBikeType == 1) {
            this.strArrStatus[0] = CGameTexts.strArrStoreBuyStatus[1];
            this.strArrStatus[1] = CGameTexts.strArrStoreBuyStatus[0];
        } else {
            this.strArrStatus[0] = CGameTexts.strArrStoreBuyStatus[1];
            this.strArrStatus[1] = CGameTexts.strArrStoreBuyStatus[1];
        }
        for (int i2 = 0; i2 < this.strSplitDialog.length; ++i2) {
            this.strSplitDialog[i2] = CUtility.getTextRows(CGameTexts.strArrStorePopupMsg[i2], this.objSmallFont, CCanvas.iScreenW - ((CCanvas.iScreenW >> 4) + this.objLargeFont.getHeight()));
        }
        this.iFontHeight = this.objSmallFont.getHeight();
        this.iX = CCanvas.iScreenW >> 1;
        this.iPopupX = CCanvas.iScreenW >> 5;
        this.iPopupY = CCanvas.iScreenH - (CCanvas.iScreenH / 3 + (25 + this.iFontHeight));
        this.ipopupWidth = CCanvas.iScreenW - (CCanvas.iScreenW >> 4);
        this.iPopupHeight = CCanvas.iScreenH / 3 + this.iFontHeight;
        this.iY = this.iPopupY + (this.iPopupHeight >> 1);
    }

    public void paint(Graphics g2) {
        CUtility.drawBorder(g2, this.iOutSideBorderX, this.iOutSideBorderY, this.iOutSideBorderWidth, this.iOutSideBorderHeight);
        g2.drawImage(this.imageOptionMenuHeaderBar, this.iOptionMenuHeaderX, this.iOptionMenuHeaderY, 6);
        g2.drawImage(this.imageOptionMenuHeader, this.iOptionMenuHeaderX + (this.imageOptionMenuHeaderBar.getWidth() >> 1) - this.iAdjustFactor, this.iOptionMenuHeaderY, 3);
        g2.drawImage(this.imageD3Header, this.iHeaderD3X, this.iHeaderD3Y, 0);
        if (this.iIndex != 0) {
            g2.drawImage(this.imageUPArrow, this.iUpArrowX, this.iUpArrowY + this.iArrowMoveFacUp, 17);
        }
        if (this.iIndex != this.imageArrInapp.length - 1) {
            g2.drawImage(this.imageDownArrow, this.iDownArrowX, this.iDownArrowY + this.iArrowMoveFacDown, 17);
        }
        this.objLargeFont.drawString("" + this.iCurrentCoinStatus, this.iOutSideBorderWidth, this.iHeaderD3Y + this.imageD3Header.getHeight(), g2, 10);
        this.animCoin.paint(g2, this.iOutSideBorderWidth - (this.objLargeFont.stringWidth("" + this.iCurrentCoinStatus) + (this.animCoin.getCurFrameWidth() >> 1)), this.iHeaderD3Y + this.imageD3Header.getHeight(), 10);
        g2.setClip(this.iOutSideBorderX, this.iInSideBorderY, this.iOutSideBorderWidth, this.iInSideBorderHeight);
        g2.setColor(0xFF0000);
        for (int i2 = 0; i2 < this.iTotalInappImages; ++i2) {
            int y2 = this.iMoveFactor + this.iGapBtImages + (this.iInSideBorderY + i2 * (this.imageArrInapp[i2].getHeight() + this.iGapBtImages)) + (this.imageInappBg.getHeight() >> 1);
            this.setLocked(i2, false);
            if (i2 == this.iSelectInappImageIndex) {
                g2.drawRect(this.iInSideBorderX - 1, this.iInSideBorderY + this.iGapBtImages + i2 * (this.imageArrInapp[i2].getHeight() + this.iGapBtImages) - 1, this.imageArrInapp[0].getWidth() + this.imageInappBg.getWidth() + 1, this.imageArrInapp[i2].getHeight() + 1);
            }
            g2.drawImage(this.imageArrInapp[i2], this.iInSideBorderX, this.iMoveFactor + this.iGapBtImages + (this.iInSideBorderY + i2 * (this.imageArrInapp[i2].getHeight() + this.iGapBtImages)), 0);
            g2.drawImage(this.imageInappBg, this.iInSideBorderX + this.imageArrInapp[i2].getWidth(), this.iMoveFactor + this.iGapBtImages + (this.iInSideBorderY + i2 * (this.imageArrInapp[i2].getHeight() + this.iGapBtImages)), 0);
            this.objLargeFont.drawString("" + this.getCost(i2), this.iInSideBorderX + this.iInSideBorderWidth - (this.iFontHeight >> 1), y2 - 1, g2, 10);
            int iStatusIndex = -1;
            if ((i2 == 1 || i2 == 2) && this.strArrStatus[i2 - 1] == CGameTexts.strArrStoreBuyStatus[0]) {
                iStatusIndex = i2;
            }
            if (i2 == 4 || i2 == 3) {
                for (int j2 = 0; j2 < this.iTotalStars; ++j2) {
                    if (j2 < this.getStar(i2)) {
                        g2.drawImage(this.imagePowerOn, this.iInSideBorderX + this.imageArrInapp[i2].getWidth() + j2 * this.imagePowerOff.getWidth(), y2 - (this.imagePowerOff.getHeight() >> 1), 0);
                        continue;
                    }
                    g2.drawImage(this.imagePowerOff, this.iInSideBorderX + this.imageArrInapp[i2].getWidth() + j2 * this.imagePowerOff.getWidth(), y2 - (this.imagePowerOff.getHeight() >> 1), 0);
                }
            } else if (i2 == 0) {
                this.objLargeFont.drawString("X " + this.iTotalSaveMe, this.iInSideBorderX + this.imageArrInapp[i2].getWidth() + this.objLargeFont.stringWidth("BUY"), y2 - 1, g2, 3);
            } else if (i2 == iStatusIndex) {
                this.objLargeFont.drawString(this.strArrStatus[i2 - 1], this.iInSideBorderX + this.imageArrInapp[i2].getWidth() + this.objLargeFont.stringWidth("BUY"), y2 - 1, g2, 3);
            } else {
                if (i2 == 1) {
                    this.objLargeFont.drawString("X " + this.iTotalBullet, this.iInSideBorderX + this.imageArrInapp[i2].getWidth() + this.objLargeFont.stringWidth("BUY"), y2 - 1, g2, 3);
                }
                if (i2 == 2) {
                    this.objLargeFont.drawString("X " + this.iTotalMissile, this.iInSideBorderX + this.imageArrInapp[i2].getWidth() + this.objLargeFont.stringWidth("BUY"), y2 - 1, g2, 3);
                }
            }
            if (i2 != 2 || this.getBikePurchase() != 0) continue;
            this.setLocked(i2, true);
            g2.drawImage(this.imageLock, this.iInSideBorderX + this.imageArrInapp[i2].getWidth() + this.objLargeFont.stringWidth("BUY"), y2 - 1, 3);
        }
        g2.setClip(0, 0, CCanvas.iScreenW, CCanvas.iScreenH);
        if (this.isPopupState) {
            g2.setColor(0x2A2A2A);
            g2.fillRoundRect(this.iPopupX, this.iPopupY, this.ipopupWidth, this.iPopupHeight, 25, 25);
            g2.setColor(0xDDDDDD);
            g2.drawRoundRect(this.iPopupX, this.iPopupY, this.ipopupWidth, this.iPopupHeight, 25, 25);
            int iTotalMsgRow = this.strSplitDialog[this.iPopupMsgIndex].length;
            int iStartY = 0;
            iStartY = iTotalMsgRow % 2 == 0 ? this.iY - ((iTotalMsgRow - 1) * this.iFontHeight >> 1) : this.iY - (iTotalMsgRow - 1 >> 1) * this.iFontHeight;
            for (int i3 = 0; i3 < iTotalMsgRow; ++i3) {
                this.objSmallFont.drawString(this.strSplitDialog[this.iPopupMsgIndex][i3], this.iX, iStartY + this.iFontHeight * i3, g2, 3);
            }
            if (this.iPopupMsgIndex < 7) {
                CUtility.paintSoftKeys(g2, null, this.imageNoButton);
                CUtility.paintSoftKeys(g2, this.imageYesButton, null);
            } else {
                CUtility.paintSoftKeys(g2, null, this.imageReturnButton);
            }
        } else {
            CUtility.paintSoftKeys(g2, null, this.imageBackButton);
        }
    }

    private void setInfoPopupMsg(boolean popupStatus, int iIndex) {
        this.iPopupMsgIndex = iIndex;
        this.isPopupState = popupStatus;
    }

    private void setLocked(int iLockIndex, boolean lockStatus) {
        this.isArrLock[iLockIndex] = lockStatus;
    }

    private boolean getLocked(int iLockIndex) {
        return this.isArrLock[iLockIndex];
    }

    private int getBikePurchase() {
        return this.iBikeType;
    }

    private void setBikePurchase(int iBike) {
        gameData.saveData(5, iBike);
        this.iBikeType = iBike;
    }

    private void setCurrentCoinStatus(int iNewStatus) {
        this.iCurrentCoinStatus = iNewStatus;
        gameData.saveData(1, this.iCurrentCoinStatus);
    }

    private int getCurrentCoinStatus() {
        return this.iCurrentCoinStatus;
    }

    private int getStar(int indexOfStore) {
        int iStar = 0;
        switch (indexOfStore) {
            case 3: {
                iStar = this.iStarMagnet;
                break;
            }
            case 4: {
                iStar = this.iStarShield;
            }
        }
        return iStar;
    }

    private void setStar(int indexOfStore, int totalStar) {
        switch (indexOfStore) {
            case 3: {
                gameData.saveData(6, totalStar);
                this.iStarMagnet = totalStar;
                break;
            }
            case 4: {
                gameData.saveData(7, totalStar);
                this.iStarShield = totalStar;
            }
        }
    }

    private int getCost(int indexOfStore) {
        int iCost = 0;
        switch (indexOfStore) {
            case 1: {
                if (this.strArrStatus[indexOfStore - 1].equalsIgnoreCase(CGameTexts.strArrStoreBuyStatus[1])) {
                    iCost = this.iCostBullet;
                    break;
                }
                iCost = this.iCostBulletBike;
                break;
            }
            case 2: {
                if (this.strArrStatus[indexOfStore - 1].equalsIgnoreCase(CGameTexts.strArrStoreBuyStatus[1])) {
                    iCost = this.iCostMissile;
                    break;
                }
                iCost = this.iCostMissileBike;
                break;
            }
            case 3: {
                iCost = this.iCostMagnet;
                break;
            }
            case 4: {
                iCost = this.iCostShield;
                break;
            }
            case 0: {
                iCost = this.iCostSaveMe;
            }
        }
        return iCost;
    }

    private void setCost(int indexOfStore, int totalCost) {
        switch (indexOfStore) {
            case 1: {
                this.iCostBulletBike = totalCost;
                break;
            }
            case 2: {
                this.iCostMissileBike = totalCost;
                break;
            }
            case 3: {
                this.iCostMagnet = totalCost;
                break;
            }
            case 4: {
                this.iCostShield = totalCost;
            }
        }
    }

    private void updateStore() {
        switch (this.iPopupMsgIndex) {
            case 1: {
                this.isPopupState = false;
                this.setCurrentCoinStatus(this.getCurrentCoinStatus() - this.getCost(this.iIndex));
                this.setBikePurchase(this.getBikePurchase() + 1);
                this.strArrStatus[this.iIndex - 1] = CGameTexts.strArrStoreBuyStatus[1];
                this.iTotalBullet += 10;
                gameData.saveData(8, this.iTotalBullet);
                break;
            }
            case 2: {
                this.isPopupState = false;
                this.setCurrentCoinStatus(this.getCurrentCoinStatus() - this.getCost(this.iIndex));
                this.setBikePurchase(this.getBikePurchase() + 1);
                this.strArrStatus[this.iIndex - 1] = CGameTexts.strArrStoreBuyStatus[1];
                this.iTotalMissile += 5;
                gameData.saveData(9, this.iTotalMissile);
                break;
            }
            case 3: {
                this.isPopupState = false;
                this.setCurrentCoinStatus(this.getCurrentCoinStatus() - this.getCost(this.iIndex));
                this.iTotalBullet += 10;
                gameData.saveData(8, this.iTotalBullet);
                break;
            }
            case 4: {
                this.isPopupState = false;
                this.setCurrentCoinStatus(this.getCurrentCoinStatus() - this.getCost(this.iIndex));
                this.iTotalMissile += 5;
                gameData.saveData(9, this.iTotalMissile);
                break;
            }
            case 5: {
                this.isPopupState = false;
                this.setCurrentCoinStatus(this.getCurrentCoinStatus() - this.getCost(this.iIndex));
                this.setStar(this.iIndex, this.getStar(this.iIndex) + 1);
                if (this.getStar(this.iIndex) == this.iTotalStars) break;
                this.setCost(this.iIndex, CPortingValues.COST_MAGNET[this.getStar(this.iIndex)]);
                break;
            }
            case 6: {
                this.isPopupState = false;
                this.setCurrentCoinStatus(this.getCurrentCoinStatus() - this.getCost(this.iIndex));
                this.setStar(this.iIndex, this.getStar(this.iIndex) + 1);
                if (this.getStar(this.iIndex) == this.iTotalStars) break;
                this.setCost(this.iIndex, CPortingValues.COST_SHIELD[this.getStar(this.iIndex)]);
                break;
            }
            case 0: {
                this.isPopupState = false;
                this.setCurrentCoinStatus(this.getCurrentCoinStatus() - this.getCost(this.iIndex));
                ++this.iTotalSaveMe;
                gameData.saveData(16, this.iTotalSaveMe);
            }
        }
    }

    public void update() {
        this.animCoin.update();
    }

    public void handleInput(int key, boolean isPressed) {
        if (isPressed) {
            if (!this.isPopupState) {
                block0 : switch (key) {
                    case 202: {
                        this.iArrowMoveFacUp -= 5;
                        this.isUpPressed = true;
                        if (this.iIndex != 0) {
                            --this.iIndex;
                        }
                        if (this.iSelectInappImageIndex != 0) {
                            --this.iSelectInappImageIndex;
                            break;
                        }
                        if (this.iMoveFactor + this.iGapBtImages + this.iInSideBorderY >= this.iInSideBorderY) break;
                        this.iMoveFactor += this.iMoveSpeed;
                        --this.iCounter;
                        break;
                    }
                    case 208: {
                        this.iArrowMoveFacDown += 5;
                        this.isDownPressed = true;
                        if (this.iIndex < this.imageArrInapp.length - 1) {
                            ++this.iIndex;
                        }
                        if (this.iSelectInappImageIndex < this.iTotalImageOnScreen - 1) {
                            ++this.iSelectInappImageIndex;
                            break;
                        }
                        if (this.iMoveFactor + this.iGapBtImages + (this.iInSideBorderY + (this.imageArrInapp.length - 1) * (this.imageArrInapp[0].getHeight() + this.iGapBtImages)) <= this.iInSideBorderY + this.iInSideBorderHeight - this.objLargeFont.getHeight()) break;
                        this.iMoveFactor -= this.iMoveSpeed;
                        ++this.iCounter;
                        break;
                    }
                    case 205: {
                        switch (this.iIndex) {
                            case 1: {
                                if (this.strArrStatus[this.iIndex - 1].equalsIgnoreCase(CGameTexts.strArrStoreBuyStatus[0])) {
                                    if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                        this.setInfoPopupMsg(true, 1);
                                        break block0;
                                    }
                                    this.setInfoPopupMsg(true, 7);
                                    break block0;
                                }
                                if (this.getLocked(this.iIndex)) break;
                                if (this.getStar(this.iIndex) < this.iTotalStars) {
                                    if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                        this.setInfoPopupMsg(true, 3);
                                        break block0;
                                    }
                                    this.setInfoPopupMsg(true, 7);
                                    break block0;
                                }
                                this.setInfoPopupMsg(true, 8);
                                break block0;
                            }
                            case 2: {
                                if (this.getLocked(this.iIndex)) break;
                                if (this.strArrStatus[this.iIndex - 1].equalsIgnoreCase(CGameTexts.strArrStoreBuyStatus[0])) {
                                    if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                        this.setInfoPopupMsg(true, 2);
                                        break block0;
                                    }
                                    this.setInfoPopupMsg(true, 7);
                                    break block0;
                                }
                                if (this.getLocked(this.iIndex)) break;
                                if (this.getStar(this.iIndex) < this.iTotalStars) {
                                    if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                        this.setInfoPopupMsg(true, 4);
                                        break block0;
                                    }
                                    this.setInfoPopupMsg(true, 7);
                                    break block0;
                                }
                                this.setInfoPopupMsg(true, 8);
                                break block0;
                            }
                            case 3: {
                                if (this.getStar(this.iIndex) < this.iTotalStars) {
                                    if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                        this.setInfoPopupMsg(true, 5);
                                        break block0;
                                    }
                                    this.setInfoPopupMsg(true, 7);
                                    break block0;
                                }
                                this.setInfoPopupMsg(true, 8);
                                break block0;
                            }
                            case 4: {
                                if (this.getStar(this.iIndex) < this.iTotalStars) {
                                    if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                        this.setInfoPopupMsg(true, 6);
                                        break block0;
                                    }
                                    this.setInfoPopupMsg(true, 7);
                                    break block0;
                                }
                                this.setInfoPopupMsg(true, 8);
                                break block0;
                            }
                            case 0: {
                                if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                    this.setInfoPopupMsg(true, 0);
                                    break block0;
                                }
                                this.setInfoPopupMsg(true, 7);
                            }
                        }
                        break;
                    }
                    case 212: {
                        CMainMenuManager.getInstance().switchToStates(4);
                    }
                }
            } else {
                if (key == 212) {
                    this.isPopupState = false;
                }
                if (key == 211) {
                    this.updateStore();
                }
            }
        } else if (!this.isPopupState) {
            if (this.isUpPressed) {
                this.iArrowMoveFacUp += 5;
                this.isUpPressed = false;
            }
            if (this.isDownPressed) {
                this.iArrowMoveFacDown -= 5;
                this.isDownPressed = false;
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        int i2;
        if (iTouchState == 0 && !this.isPopupState) {
            if (!CUtility.isRSKPressed(pointerX, pointerY)) {
                if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, 0, this.iInSideBorderWidth, this.iUpArrowY + this.imageUPArrow.getHeight())) {
                    this.iArrowMoveFacUp -= 5;
                    this.isUpPressed = true;
                } else if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, this.iDownArrowY, this.iInSideBorderWidth, CCanvas.iScreenH - (this.iDownArrowY + this.imageDownArrow.getHeight()))) {
                    this.iArrowMoveFacDown += 5;
                    this.isDownPressed = true;
                }
            }
            for (i2 = 0; i2 < this.iTotalImageOnScreen; ++i2) {
                if (!CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, this.iGapBtImages + (this.iInSideBorderY + i2 * (this.imageArrInapp[i2].getHeight() + this.iGapBtImages)), this.iInSideBorderWidth, this.imageArrInapp[i2].getHeight())) continue;
                this.iSelectInappImageIndex = i2;
                this.iIndex = i2 + this.iCounter;
            }
        }
        if (iTouchState == 2) {
            if (!this.isPopupState) {
                block8: for (i2 = 0; i2 < this.iTotalImageOnScreen; ++i2) {
                    if (!CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, this.iGapBtImages + (this.iInSideBorderY + i2 * (this.imageArrInapp[i2].getHeight() + this.iGapBtImages)), this.iInSideBorderWidth, this.imageArrInapp[i2].getHeight())) continue;
                    this.iReleasedIndex = i2 + this.iCounter;
                    if (this.iReleasedIndex != this.iIndex) continue;
                    switch (this.iIndex) {
                        case 1: {
                            if (this.strArrStatus[this.iIndex - 1].equalsIgnoreCase(CGameTexts.strArrStoreBuyStatus[0])) {
                                if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                    this.setInfoPopupMsg(true, 1);
                                    continue block8;
                                }
                                this.setInfoPopupMsg(true, 7);
                                continue block8;
                            }
                            if (this.getLocked(this.iIndex)) continue block8;
                            if (this.getStar(this.iIndex) < this.iTotalStars) {
                                if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                    this.setInfoPopupMsg(true, 3);
                                    continue block8;
                                }
                                this.setInfoPopupMsg(true, 7);
                                continue block8;
                            }
                            this.setInfoPopupMsg(true, 8);
                            continue block8;
                        }
                        case 2: {
                            if (this.getLocked(this.iIndex)) continue block8;
                            if (this.strArrStatus[this.iIndex - 1].equalsIgnoreCase(CGameTexts.strArrStoreBuyStatus[0])) {
                                if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                    this.setInfoPopupMsg(true, 2);
                                    continue block8;
                                }
                                this.setInfoPopupMsg(true, 7);
                                continue block8;
                            }
                            if (this.getLocked(this.iIndex)) continue block8;
                            if (this.getStar(this.iIndex) < this.iTotalStars) {
                                if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                    this.setInfoPopupMsg(true, 4);
                                    continue block8;
                                }
                                this.setInfoPopupMsg(true, 7);
                                continue block8;
                            }
                            this.setInfoPopupMsg(true, 8);
                            continue block8;
                        }
                        case 3: {
                            if (this.getStar(this.iIndex) < this.iTotalStars) {
                                if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                    this.setInfoPopupMsg(true, 5);
                                    continue block8;
                                }
                                this.setInfoPopupMsg(true, 7);
                                continue block8;
                            }
                            this.setInfoPopupMsg(true, 8);
                            continue block8;
                        }
                        case 4: {
                            if (this.getStar(this.iIndex) < this.iTotalStars) {
                                if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                    this.setInfoPopupMsg(true, 6);
                                    continue block8;
                                }
                                this.setInfoPopupMsg(true, 7);
                                continue block8;
                            }
                            this.setInfoPopupMsg(true, 8);
                            continue block8;
                        }
                        case 0: {
                            if (this.getCurrentCoinStatus() >= this.getCost(this.iIndex)) {
                                this.setInfoPopupMsg(true, 0);
                                continue block8;
                            }
                            this.setInfoPopupMsg(true, 7);
                        }
                    }
                }
                if (this.isUpPressed) {
                    this.iArrowMoveFacUp += 5;
                    this.isUpPressed = false;
                }
                if (this.isDownPressed) {
                    this.iArrowMoveFacDown -= 5;
                    this.isDownPressed = false;
                }
                if (CUtility.isRSKPressed(pointerX, pointerY)) {
                    CMainMenuManager.getInstance().switchToStates(4);
                } else if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, 0, this.iInSideBorderWidth, this.iUpArrowY + this.imageUPArrow.getHeight())) {
                    if (this.iIndex != 0) {
                        --this.iIndex;
                    }
                    if (this.iSelectInappImageIndex != 0) {
                        --this.iSelectInappImageIndex;
                    } else if (this.iMoveFactor + this.iGapBtImages + this.iInSideBorderY < this.iInSideBorderY) {
                        this.iMoveFactor += this.iMoveSpeed;
                        --this.iCounter;
                    }
                } else if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, this.iDownArrowY, this.iInSideBorderWidth, CCanvas.iScreenH - (this.iDownArrowY + this.imageDownArrow.getHeight()))) {
                    if (this.iIndex < this.imageArrInapp.length - 1) {
                        ++this.iIndex;
                    }
                    if (this.iSelectInappImageIndex < this.iTotalImageOnScreen - 1) {
                        ++this.iSelectInappImageIndex;
                    } else if (this.iMoveFactor + this.iGapBtImages + (this.iInSideBorderY + (this.imageArrInapp.length - 1) * (this.imageArrInapp[0].getHeight() + this.iGapBtImages)) > this.iInSideBorderY + this.iInSideBorderHeight - this.objLargeFont.getHeight()) {
                        this.iMoveFactor -= this.iMoveSpeed;
                        ++this.iCounter;
                    }
                }
            } else {
                if (CUtility.isRSKPressed(pointerX, pointerY)) {
                    this.isPopupState = false;
                }
                if (CUtility.isLSKPressed(pointerX, pointerY)) {
                    this.updateStore();
                }
            }
        }
    }

    public void unLoadImages() {
        this.imageD3Header = null;
        this.imageOptionMenuHeaderBar = null;
        this.imageOptionMenuHeader = null;
        this.imageUPArrow = null;
        this.imageDownArrow = null;
        this.objSmallFont = null;
        this.objLargeFont = null;
        for (int i2 = 0; i2 < this.iTotalInappImages; ++i2) {
            this.imageArrInapp[i2] = null;
        }
        this.imageInappBg = null;
        this.imagePowerOn = null;
        this.imagePowerOff = null;
        this.imageLock = null;
        this.imageNoButton = null;
        this.imageYesButton = null;
        this.imageBackButton = null;
        this.imageReturnButton = null;
        this.animCoin = null;
    }
}

