/*
 * Decompiled with CFR 0.152.
 */
package com.am.adlib;

import com.am.adlib.AdData;
import com.am.adlib.AdListener;
import com.am.adlib.AdStorage;
import com.am.adlib.BannerListener;
import com.am.adlib.BannerSprite;
import com.am.adlib.BannersRequest;
import com.am.adlib.ImageReceiver;
import com.am.adlib.JSONParser;
import com.am.adlib.Log;
import com.am.adlib.StatListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Ad {
    public final double VERSION;
    private static Ad instance;
    protected static int bannerWidth;
    protected static int bannerHeight;
    private int screenWidth;
    private int screenHeight;
    protected static boolean isShowingDefaultBanner;
    protected static boolean request;
    protected static int n;
    public static int appId;
    public static boolean logging;
    public static final int DEFAULT_BANNER_ID = 0;
    public static final String DEFAULT_BANNER_COMPANY = "AM";
    public static final String DEFAULT_BANNER_LINK = "http://askabout.fm/";
    private String url;
    private MIDlet midlet;
    private AdListener adListener;
    private StatListener statListener;
    private Timer bannerTimer;
    private Timer statTimer;
    protected BannerSprite bannerSprite = null;
    protected BannerListener bannerListener;

    static {
        isShowingDefaultBanner = false;
        request = false;
        n = 0;
        logging = false;
    }

    public static Ad getInstance() {
        return instance;
    }

    public static Ad start(MIDlet midlet, int appId, int screenWidth, int screenHeight) {
        if (instance == null) {
            instance = new Ad(midlet, appId, screenWidth, screenHeight);
        }
        return instance;
    }

    private Ad(MIDlet midlet, int Id, int screenWidth, int screenHeight) {
        this.VERSION = 1.0;
        appId = Id;
        this.midlet = midlet;
        this.url = "http://startposition.net/4/" + appId + "/get";
        this.statListener = new StatListener();
        this.adListener = new AdListener(this.statListener);
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        String data = AdStorage.getInstance().getData();
        if (!data.equals("")) {
            Log.i("Have saved data");
            new JSONParser().parse(data, this.statListener);
        } else {
            Log.i("Haven't saved data");
        }
        if (screenWidth < screenHeight) {
            bannerWidth = screenWidth;
            bannerHeight = 50 * screenWidth / 320;
        } else {
            bannerWidth = screenHeight;
            bannerHeight = 50 * screenHeight / 320;
        }
        this.fetchBanners();
    }

    public void openLink() {
        try {
            String link;
            AdData data = AdData.getInstance();
            if (isShowingDefaultBanner) {
                link = DEFAULT_BANNER_LINK;
                this.statListener.onBannerClicked(0, DEFAULT_BANNER_COMPANY);
            } else {
                int bannerId = data.getId(n);
                String bannerCompany = data.getCompany(n);
                link = data.getLink(n);
                this.statListener.onBannerClicked(bannerId, bannerCompany);
            }
            this.midlet.platformRequest(link);
        }
        catch (Exception e) {
            Log.e(e.toString());
            e.printStackTrace();
        }
    }

    public void fetchBanners() {
        if (!request) {
            request = true;
            Log.d("SENDING REQUEST TO FETCH BANNERS");
            new BannersRequest(this.adListener, this.statListener).fetchBanners(this.url);
        }
    }

    public void setBannerListener(BannerListener listener) {
        this.bannerListener = listener;
    }

    public BannerSprite createBannerSprite() {
        return this.createBannerSprite(0, "center", "bottom");
    }

    public BannerSprite createBannerSprite(int angle, String alignX, String alignY) {
        if (this.bannerSprite != null) {
            return this.bannerSprite;
        }
        Image image = Image.createImage((int)1, (int)1);
        this.bannerSprite = new BannerSprite(image, angle, alignX, alignY, this.screenWidth, this.screenHeight);
        this.setBannerListener(this.bannerSprite);
        return this.bannerSprite;
    }

    public void startAd() {
        if (AdData.getInstance().haveData()) {
            AdData.getInstance().setIsNew(false);
            int bannerId = AdData.getInstance().getId(n);
            String bannerCompany = AdData.getInstance().getCompany(n);
            this.statListener.onBannerRequested(bannerId, bannerCompany);
            String imgSrc = AdData.getInstance().getImgSrc(n);
            ImageReceiver ir = new ImageReceiver(this.adListener, this.statListener);
            ir.fetchBannerImage(imgSrc, bannerId, bannerCompany);
            this.startStatTimer();
        } else {
            this.adListener.handleDefaultBanner();
            this.adListener.handleNoData();
        }
    }

    public void stopAd() {
        this.adListener.stopNoDataTimer();
        this.stopBannerTimer();
        this.stopStatTimer();
    }

    private void startBannerTimer(int delay) {
        if (this.bannerTimer == null) {
            Log.i("START BANNER TIMER: " + delay);
            this.bannerTimer = new Timer();
            this.bannerTimer.schedule(new TimerTask(){

                public void run() {
                    Log.i("BANNER TIMER TIMEOUT");
                    n = AdData.getInstance().isNew() ? 0 : (n = n + 1);
                    Ad.this.startAd();
                    Ad.this.bannerTimer = null;
                }
            }, delay * 1000);
        }
    }

    private void stopBannerTimer() {
        if (this.bannerTimer != null) {
            this.bannerTimer.cancel();
            this.bannerTimer = null;
        }
    }

    private void startStatTimer() {
        if (this.statTimer == null) {
            this.statTimer = new Timer();
            this.statTimer.schedule(new TimerTask(){

                public void run() {
                    Ad.this.statListener.onTimeToSendStat();
                }
            }, 20000L, 20000L);
        }
    }

    private void stopStatTimer() {
        if (this.statTimer != null) {
            this.statTimer.cancel();
            this.statTimer = null;
        }
    }

    protected void checkNext() {
        AdData data = AdData.getInstance();
        if (data.haveData()) {
            int length = data.getBannersArrayLength();
            int delay = data.getRefreshRate(n);
            Log.i("CURRENT BANNER: " + (n + 1) + "/" + length + ". COMPANY: " + data.getCompany(n));
            this.startBannerTimer(delay);
            if (n + 1 == length) {
                this.fetchBanners();
                n = 0;
            }
        }
    }

    protected static Image scaleImage(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int YD = original.getHeight() / newHeight * original.getWidth() - original.getWidth();
        int YR = original.getHeight() % newHeight;
        int XD = original.getWidth() / newWidth;
        int XR = original.getWidth() % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int y = newHeight;
        int YE = 0;
        while (y > 0) {
            int x = newWidth;
            int XE = 0;
            while (x > 0) {
                rawOutput[outOffset++] = rawInput[inOffset];
                inOffset += XD;
                if ((XE += XR) >= newWidth) {
                    XE -= newWidth;
                    ++inOffset;
                }
                --x;
            }
            inOffset += YD;
            if ((YE += YR) >= newHeight) {
                YE -= newHeight;
                inOffset += original.getWidth();
            }
            --y;
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)false);
    }
}

