/*
 * Decompiled with CFR 0.152.
 */
package com.am.adlib;

import com.am.adlib.Ad;
import com.am.adlib.Log;
import com.am.adlib.StatListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Image;

public class AdListener {
    private Timer noDataTimer = null;
    private final int RETRY_TIME;
    private StatListener statListener;

    public AdListener(StatListener statListener) {
        this.RETRY_TIME = 60000;
        this.statListener = statListener;
    }

    public synchronized void handleDefaultBanner() {
        if (!Ad.isShowingDefaultBanner) {
            this.statListener.onBannerRequested(0, "AM");
            Log.d("Loading default banner");
            boolean defaultBannerImp = true;
            try {
                Image defaultImage = Image.createImage((String)"/default_banner.jpg");
                Ad.getInstance().bannerListener.imageReceived(defaultImage);
            }
            catch (Exception e) {
                defaultBannerImp = false;
                Log.e("Can't load default banner");
            }
            if (defaultBannerImp) {
                Ad.isShowingDefaultBanner = true;
                this.statListener.onBannerImpressed(0, "AM");
            }
        }
    }

    public synchronized void handleNoData() {
        if (this.noDataTimer == null && !Ad.request) {
            this.noDataTimer = new Timer();
            this.noDataTimer.schedule(new TimerTask(){

                public void run() {
                    Ad.getInstance().fetchBanners();
                }
            }, 60000L);
        }
    }

    public void stopNoDataTimer() {
        if (this.noDataTimer != null) {
            this.noDataTimer.cancel();
            this.noDataTimer = null;
        }
    }
}

