/*
 * Decompiled with CFR 0.152.
 */
package com.am.adlib;

import com.am.adlib.Ad;
import com.am.adlib.BannerListener;
import com.am.adlib.Log;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class BannerSprite
extends Sprite
implements BannerListener {
    private boolean pressed = false;

    protected BannerSprite(Image image, int angle, String alignX, String alignY, int screenWidth, int screenHeight) {
        super(image);
        switch (angle) {
            case 90: {
                this.setTransform(5);
                break;
            }
            case 180: {
                this.setTransform(3);
                break;
            }
            case 270: {
                this.setTransform(6);
            }
        }
        int x = this.getPositionX(angle, alignX, alignY, screenWidth);
        int y = this.getPositionY(angle, alignX, alignY, screenHeight);
        this.setPosition(x, y);
    }

    public void imageReceived(Image bannerImage) {
        Log.d("IMAGE RECEIVED");
        try {
            this.setImage(bannerImage, bannerImage.getWidth(), bannerImage.getHeight());
        }
        catch (Exception e) {
            Log.e(e.toString());
        }
    }

    private boolean contains(int x, int y) {
        return x > this.getX() && x < this.getX() + this.getWidth() && y > this.getY() && y < this.getY() + this.getHeight();
    }

    public boolean touchDown(int x, int y) {
        if (this.isVisible() && this.contains(x, y)) {
            this.pressed = true;
            return true;
        }
        return false;
    }

    public boolean touchUp(int x, int y) {
        if (this.pressed) {
            this.pressed = false;
            if (this.isVisible() && this.contains(x, y)) {
                return true;
            }
        }
        return false;
    }

    private int getPositionX(int angle, String alignX, String alignY, int screenWidth) {
        int x = 0;
        if (angle == 0) {
            if (alignX.equals("center")) {
                x = (screenWidth - Ad.bannerWidth) / 2;
            } else if (alignX.equals("right")) {
                x = screenWidth - Ad.bannerWidth;
            }
        } else if (angle == 90) {
            if (alignY.equals("top")) {
                x = screenWidth;
            } else if (alignY.equals("center")) {
                x = (screenWidth + Ad.bannerHeight) / 2;
            } else if (alignY.equals("bottom")) {
                x = Ad.bannerHeight;
            }
        } else if (angle == 180) {
            if (alignX.equals("left")) {
                x = screenWidth;
            } else if (alignX.equals("center")) {
                x = (screenWidth + Ad.bannerWidth) / 2;
            } else if (alignX.equals("right")) {
                x = Ad.bannerWidth;
            }
        } else if (angle == 270) {
            if (alignX.equals("center")) {
                x = (screenWidth - Ad.bannerHeight) / 2;
            } else if (alignX.equals("bottom")) {
                x = screenWidth - Ad.bannerHeight;
            }
        }
        return x;
    }

    private int getPositionY(int angle, String alignX, String alignY, int screenHeight) {
        int y = 0;
        if (angle == 0) {
            if (alignY.equals("center")) {
                y = (screenHeight - Ad.bannerHeight) / 2;
            } else if (alignY.equals("bottom")) {
                y = screenHeight - Ad.bannerHeight;
            }
        } else if (angle == 90) {
            if (alignX.equals("center")) {
                y = (screenHeight - Ad.bannerWidth) / 2;
            } else if (alignX.equals("right")) {
                y = screenHeight - Ad.bannerWidth;
            }
        } else if (angle == 180) {
            if (alignY.equals("top")) {
                y = screenHeight;
            } else if (alignY.equals("center")) {
                y = (screenHeight + Ad.bannerHeight) / 2;
            }
        } else if (angle == 270) {
            if (alignX.equals("left")) {
                y = screenHeight;
            } else if (alignX.equals("center")) {
                y = (screenHeight + Ad.bannerWidth) / 2;
            } else if (alignX.equals("right")) {
                y = Ad.bannerWidth;
            }
        }
        return y;
    }
}

