/*
 * Decompiled with CFR 0.152.
 */
package com.am.adlib;

import com.am.adlib.Ad;
import com.am.adlib.AdListener;
import com.am.adlib.Log;
import com.am.adlib.StatListener;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Image;

public class ImageReceiver {
    private AdListener adListener;
    private StatListener statListener;

    public ImageReceiver(AdListener adListener, StatListener statListener) {
        this.adListener = adListener;
        this.statListener = statListener;
    }

    public void fetchBannerImage(final String imgSrc, final int bannerId, final String bannerCompany) {
        new Thread(new Runnable(){

            public void run() {
                block33: {
                    HttpConnection connection;
                    Image bannerImage;
                    block34: {
                        Log.d("LOADING IMAGE...");
                        bannerImage = null;
                        connection = null;
                        InputStream inputstream = null;
                        try {
                            connection = (HttpConnection)Connector.open((String)imgSrc);
                            connection.setRequestMethod("GET");
                            int status = connection.getResponseCode();
                            Log.i("Loading image: status = " + status);
                            if (status != 200) {
                                throw new Exception("BannerImage loading error. Status code = " + status);
                            }
                            inputstream = connection.openInputStream();
                            if (connection.getLength() > 0L) {
                                bannerImage = Ad.scaleImage(Image.createImage((InputStream)inputstream), Ad.bannerWidth, Ad.bannerHeight);
                            }
                        }
                        catch (SecurityException e) {
                            ImageReceiver.this.statListener.onError(bannerId, 3, e.toString());
                            ImageReceiver.this.adListener.handleNoData();
                            ImageReceiver.this.adListener.handleDefaultBanner();
                            if (inputstream != null) {
                                try {
                                    inputstream.close();
                                }
                                catch (Exception error) {
                                    ImageReceiver.this.statListener.onError(bannerId, 3, error.toString());
                                }
                            }
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Exception error) {
                                    ImageReceiver.this.statListener.onError(bannerId, 3, error.toString());
                                }
                            }
                            if (bannerImage != null) {
                                Ad.isShowingDefaultBanner = false;
                                Ad.getInstance().bannerListener.imageReceived(bannerImage);
                                ImageReceiver.this.statListener.onBannerImpressed(bannerId, bannerCompany);
                            }
                            Ad.getInstance().checkNext();
                            break block33;
                        }
                        catch (Exception e) {
                            try {
                                ImageReceiver.this.statListener.onError(bannerId, 3, e.toString());
                                ImageReceiver.this.adListener.handleDefaultBanner();
                                break block33;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (inputstream != null) {
                                    try {
                                        inputstream.close();
                                    }
                                    catch (Exception error) {
                                        ImageReceiver.this.statListener.onError(bannerId, 3, error.toString());
                                    }
                                }
                                if (connection != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Exception error) {
                                        ImageReceiver.this.statListener.onError(bannerId, 3, error.toString());
                                    }
                                }
                                if (bannerImage != null) {
                                    Ad.isShowingDefaultBanner = false;
                                    Ad.getInstance().bannerListener.imageReceived(bannerImage);
                                    ImageReceiver.this.statListener.onBannerImpressed(bannerId, bannerCompany);
                                }
                                Ad.getInstance().checkNext();
                            }
                        }
                        if (inputstream == null) break block34;
                        try {
                            inputstream.close();
                        }
                        catch (Exception error) {
                            ImageReceiver.this.statListener.onError(bannerId, 3, error.toString());
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception error) {
                            ImageReceiver.this.statListener.onError(bannerId, 3, error.toString());
                        }
                    }
                    if (bannerImage != null) {
                        Ad.isShowingDefaultBanner = false;
                        Ad.getInstance().bannerListener.imageReceived(bannerImage);
                        ImageReceiver.this.statListener.onBannerImpressed(bannerId, bannerCompany);
                    }
                    Ad.getInstance().checkNext();
                }
            }
        }).start();
    }
}

