/*
 * Decompiled with CFR 0.152.
 */
package com.am.adlib;

import com.am.adlib.Ad;
import com.am.adlib.AdData;
import com.am.adlib.Banner;
import com.am.adlib.Log;
import com.am.adlib.SparseArray;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import org.json.me.JSONArray;
import org.json.me.JSONObject;

public class StatListener {
    private Vector requestsList = new Vector();
    private Vector impressionsList = new Vector();
    private Vector clicksList = new Vector();
    public static final int STATISTICS_SEND_INTERVAL = 20000;
    static final String hex = "%00%01%02%03%04%05%06%07%08%09%0a%0b%0c%0d%0e%0f%10%11%12%13%14%15%16%17%18%19%1a%1b%1c%1d%1e%1f%20%21%22%23%24%25%26%27%28%29%2a%2b%2c%2d%2e%2f%30%31%32%33%34%35%36%37%38%39%3a%3b%3c%3d%3e%3f%40%41%42%43%44%45%46%47%48%49%4a%4b%4c%4d%4e%4f%50%51%52%53%54%55%56%57%58%59%5a%5b%5c%5d%5e%5f%60%61%62%63%64%65%66%67%68%69%6a%6b%6c%6d%6e%6f%70%71%72%73%74%75%76%77%78%79%7a%7b%7c%7d%7e%7f%80%81%82%83%84%85%86%87%88%89%8a%8b%8c%8d%8e%8f%90%91%92%93%94%95%96%97%98%99%9a%9b%9c%9d%9e%9f%a0%a1%a2%a3%a4%a5%a6%a7%a8%a9%aa%ab%ac%ad%ae%af%b0%b1%b2%b3%b4%b5%b6%b7%b8%b9%ba%bb%bc%bd%be%bf%c0%c1%c2%c3%c4%c5%c6%c7%c8%c9%ca%cb%cc%cd%ce%cf%d0%d1%d2%d3%d4%d5%d6%d7%d8%d9%da%db%dc%dd%de%df%e0%e1%e2%e3%e4%e5%e6%e7%e8%e9%ea%eb%ec%ed%ee%ef%f0%f1%f2%f3%f4%f5%f6%f7%f8%f9%fa%fb%fc%fd%fe%ff";

    public void onBannerRequested(int bannerId, String company) {
        if (AdData.getInstance().isSendStatistics()) {
            Log.i("--- REQUEST --- BannerID: " + bannerId);
            SparseArray element = new SparseArray();
            element.put(bannerId, System.currentTimeMillis());
            this.requestsList.addElement(element);
        }
    }

    public void onBannerImpressed(int bannerId, String company) {
        if (AdData.getInstance().isSendStatistics()) {
            Log.i("--- IMP ------- BannerID: " + bannerId);
            SparseArray element = new SparseArray();
            element.put(bannerId, System.currentTimeMillis());
            this.impressionsList.addElement(element);
        }
    }

    public void onBannerClicked(int bannerId, String company) {
        if (AdData.getInstance().isSendStatistics()) {
            Log.i("--- CLICK ----- BannerID: " + bannerId);
            SparseArray element = new SparseArray();
            element.put(bannerId, System.currentTimeMillis());
            this.clicksList.addElement(element);
        }
    }

    public void onError(int code, String error) {
        this.onError(-1, code, error);
    }

    public void onError(int banner_id, int code, String error) {
        Log.e("ERROR CODE: " + code + ", ERROR: " + error);
    }

    private boolean isSendStat() {
        return this.requestsList.size() > 0 || this.impressionsList.size() > 0 || this.clicksList.size() > 0;
    }

    public void onTimeToSendStat() {
        Log.i("--- TIME TO SEND STATISCTICS ---");
        if (this.isSendStat()) {
            AdData data = AdData.getInstance();
            try {
                long currentTime = System.currentTimeMillis();
                JSONObject jsonStat = new JSONObject();
                JSONArray banners = new JSONArray();
                Vector bannersVector = data.getBanners();
                int[] bannersId = new int[bannersVector.size() + 1];
                String[] bannersCompany = new String[bannersVector.size() + 1];
                int i = 0;
                while (i < bannersVector.size()) {
                    bannersId[i] = ((Banner)bannersVector.elementAt(i)).getId();
                    bannersCompany[i] = ((Banner)bannersVector.elementAt(i)).getCompany();
                    ++i;
                }
                bannersId[bannersVector.size()] = 0;
                bannersCompany[bannersVector.size()] = "AM";
                int j = 0;
                while (j < bannersId.length) {
                    long time;
                    JSONArray requestJSONArray = new JSONArray();
                    JSONArray impressionJSONArray = new JSONArray();
                    JSONArray clickJSONArray = new JSONArray();
                    JSONObject banner = new JSONObject();
                    JSONObject statistics = new JSONObject();
                    i = 0;
                    while (i < this.requestsList.size()) {
                        time = ((SparseArray)this.requestsList.elementAt(i)).get(bannersId[j]);
                        if (time != 0L) {
                            requestJSONArray.put((int)((currentTime - time) / 1000L));
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.impressionsList.size()) {
                        time = ((SparseArray)this.impressionsList.elementAt(i)).get(bannersId[j]);
                        if (time != 0L) {
                            impressionJSONArray.put((int)((currentTime - time) / 1000L));
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.clicksList.size()) {
                        time = ((SparseArray)this.clicksList.elementAt(i)).get(bannersId[j]);
                        if (time != 0L) {
                            clickJSONArray.put((int)((currentTime - time) / 1000L));
                        }
                        ++i;
                    }
                    statistics.put("requests", requestJSONArray);
                    statistics.put("imps", impressionJSONArray);
                    statistics.put("clicks", clickJSONArray);
                    banner.put("banner_id", bannersId[j]);
                    banner.put("company", bannersCompany[j]);
                    banner.put("statistics", statistics);
                    banners.put(banner);
                    ++j;
                }
                jsonStat.put("app_id", Ad.appId);
                jsonStat.put("banners", banners);
                this.sendStat(jsonStat.toString());
                this.requestsList.removeAllElements();
                this.impressionsList.removeAllElements();
                this.clicksList.removeAllElements();
                Log.i(jsonStat.toString());
            }
            catch (Exception e) {
                Log.e(e.toString());
                e.printStackTrace();
            }
        } else {
            Log.i("--- NOTHING TO SEND --- ");
        }
    }

    public void sendStat(final String jsonStr) {
        new Thread(new Runnable(){

            public void run() {
                block25: {
                    String url = "http://pierhistory.info/statistics?stats=" + StatListener.this.urlEncode(jsonStr);
                    HttpConnection connection = null;
                    InputStream inputstream = null;
                    try {
                        try {
                            String responce;
                            connection = (HttpConnection)Connector.open((String)url);
                            connection.setRequestMethod("GET");
                            int status = connection.getResponseCode();
                            Log.d("Send statistics status: " + status);
                            if (status != 200) {
                                throw new Exception("SendStatistics error. Status code = " + status);
                            }
                            inputstream = connection.openInputStream();
                            int length = (int)connection.getLength();
                            if (length != -1) {
                                byte[] incomingData = new byte[length];
                                inputstream.read(incomingData);
                                responce = new String(incomingData);
                            } else {
                                int ch;
                                ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
                                while ((ch = inputstream.read()) != -1) {
                                    bytestream.write(ch);
                                }
                                responce = new String(bytestream.toByteArray());
                                bytestream.close();
                            }
                            if (!responce.equals("success")) {
                                StatListener.this.onError(-1, 2, "Couldn't send STATISTICS. Server responce: " + responce);
                                break block25;
                            }
                            Log.d("Send statistics. Server responce : SUCCESS");
                        }
                        catch (Exception e) {
                            StatListener.this.onError(-1, 2, e.toString());
                            if (inputstream != null) {
                                try {
                                    inputstream.close();
                                }
                                catch (Exception error) {
                                    StatListener.this.onError(-1, 2, error.toString());
                                }
                            }
                            if (connection == null) break block25;
                            try {
                                connection.close();
                            }
                            catch (Exception error) {
                                StatListener.this.onError(-1, 2, error.toString());
                            }
                        }
                    }
                    finally {
                        if (inputstream != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Exception error) {
                                StatListener.this.onError(-1, 2, error.toString());
                            }
                        }
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Exception error) {
                                StatListener.this.onError(-1, 2, error.toString());
                            }
                        }
                    }
                }
            }
        }).start();
    }

    private String urlEncode(String s) {
        StringBuffer sbuf = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
            } else if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
            } else if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
            } else if (ch == ' ') {
                sbuf.append('+');
            } else if (ch == '-' || ch == '_' || ch == '.' || ch == '*') {
                sbuf.append(ch);
            } else if (ch <= '\u007f') {
                sbuf.append(StatListener.hex(ch));
            } else if (ch <= '\u07ff') {
                sbuf.append(StatListener.hex(0xC0 | ch >> 6));
                sbuf.append(StatListener.hex(0x80 | ch & 0x3F));
            } else {
                sbuf.append(StatListener.hex(0xE0 | ch >> 12));
                sbuf.append(StatListener.hex(0x80 | ch >> 6 & 0x3F));
                sbuf.append(StatListener.hex(0x80 | ch & 0x3F));
            }
            ++i;
        }
        return sbuf.toString();
    }

    static String hex(int sym) {
        return hex.substring(sym * 3, sym * 3 + 3);
    }
}

