/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.coldarms.audio;

import com.ittop.coldarms.Main;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class AudioManager
extends Thread
implements PlayerListener {
    private static boolean audioEnabled = true;
    private static final int MAX_PLAYERS = 3;
    private static AudioManager instance;
    private static final Vector playBuffer;
    private boolean stopElectricity = false;
    private PlayItem[] players = new PlayItem[3];
    private int index = 0;
    private PlayItem music;
    static /* synthetic */ Class class$0;

    static {
        playBuffer = new Vector();
        instance = new AudioManager();
        instance.start();
    }

    public static AudioManager getInstance() {
        return instance;
    }

    private AudioManager() {
    }

    public void stopAll() {
        int i = 0;
        while (i < this.players.length) {
            if (this.players[i] != null) {
                this.stop(this.players[i].getPlayer());
            }
            ++i;
        }
    }

    public void stopPlayer(String key) {
        this.stopElectricity = true;
        int i = 0;
        while (i < this.players.length) {
            if (this.players[i] != null && this.players[i].filename.equals(key)) {
                this.stop(this.players[i].getPlayer());
            }
            ++i;
        }
    }

    public void stop(Player player) {
        if (player.getState() == 400) {
            try {
                player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        player.close();
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia")) {
            try {
                player.setMediaTime(0L);
                player.start();
            }
            catch (MediaException me) {
                me.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (audioEnabled) {
                PlayItem[] queue;
                Enumeration e = null;
                Vector vector = playBuffer;
                synchronized (vector) {
                    queue = new PlayItem[playBuffer.size()];
                    e = playBuffer.elements();
                    int i = 0;
                    while (i < playBuffer.size()) {
                        queue[i] = (PlayItem)e.nextElement();
                        ++i;
                    }
                    playBuffer.removeAllElements();
                }
                int i = 0;
                while (i < queue.length) {
                    PlayItem playItem = queue[i];
                    if (this.players[this.index] != null) {
                        this.stop(this.players[this.index].getPlayer());
                    }
                    this.players[this.index] = playItem;
                    ++this.index;
                    if (this.index >= 3) {
                        this.index = 0;
                    }
                    try {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("com.ittop.coldarms.audio.AudioManager");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        InputStream stream = clazz.getResourceAsStream(playItem.getFilename());
                        playItem.setPlayer(Manager.createPlayer((InputStream)stream, (String)"audio/mp3"));
                        playItem.getPlayer().start();
                        if (playItem.looped) {
                            playItem.getPlayer().addPlayerListener((PlayerListener)this);
                            if (this.stopElectricity) {
                                playItem.getPlayer().stop();
                                this.stopElectricity = false;
                            }
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                    catch (RuntimeException rex) {
                        rex.getMessage();
                        rex.printStackTrace();
                    }
                    ++i;
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loopSample(String filename) {
        this.stopElectricity = false;
        PlayItem playItem = new PlayItem(filename, true);
        Vector vector = playBuffer;
        synchronized (vector) {
            if (playBuffer.size() < 3) {
                playBuffer.addElement(playItem);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSample(String filename) {
        PlayItem playItem = new PlayItem(filename, false);
        Vector vector = playBuffer;
        synchronized (vector) {
            playBuffer.addElement(playItem);
            while (playBuffer.size() >= 3) {
                playBuffer.removeElementAt(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAudioEnabled(boolean value) {
        Vector vector = playBuffer;
        synchronized (vector) {
            playBuffer.removeAllElements();
        }
        audioEnabled = value;
    }

    public static boolean isAudioEnabled() {
        return audioEnabled;
    }

    public void setMusic(String filename) {
        Main.logln("AudioManager.setMusic(filename)");
        ++Main.indent;
        if (this.music == null) {
            this.music = new PlayItem(filename, true);
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.ittop.coldarms.audio.AudioManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InputStream stream = clazz.getResourceAsStream(this.music.getFilename());
                this.music.setPlayer(Manager.createPlayer((InputStream)stream, (String)"audio/mp3"));
                this.music.getPlayer().setLoopCount(-1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (MediaException e) {
                e.printStackTrace();
            }
            --Main.indent;
        }
    }

    public void playMusic() {
        Main.logln("AudioManager.playMusic()");
        ++Main.indent;
        try {
            this.music.getPlayer().start();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
        --Main.indent;
    }

    public void stopMusic() {
        Main.logln("AudioManager.stopMusic()");
        ++Main.indent;
        try {
            this.music.getPlayer().stop();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
        --Main.indent;
    }

    private class PlayItem {
        public Player player;
        public String filename;
        public boolean looped;

        public PlayItem(String filename, boolean looped) {
            this.filename = filename;
            this.looped = looped;
        }

        public String getFilename() {
            return this.filename;
        }

        public Player getPlayer() {
            return this.player;
        }

        public void setPlayer(Player player) {
            this.player = player;
        }
    }
}

