/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.coldarms.engine;

import com.am.adlib.Ad;
import com.am.adlib.BannerSprite;
import com.ittop.coldarms.Main;
import com.ittop.coldarms.audio.AudioManager;
import com.ittop.coldarms.connection.ViewInterface;
import com.ittop.coldarms.connection.ViewListener;
import com.ittop.coldarms.engine.Resources;
import com.ittop.coldarms.game.Game;
import com.ittop.coldarms.tools.ALM;
import com.ittop.coldarms.tools.TextField;
import com.ittop.coldarms.view.AboutMenu;
import com.ittop.coldarms.view.HelpMenu;
import com.ittop.coldarms.view.MainMenu;
import com.ittop.coldarms.view.PlayerView;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Engine
extends GameCanvas
implements CommandListener,
ViewListener {
    private static long timeDelta;
    private Resources res;
    private MainMenu mainMenu;
    private GameThread gameThread;
    private ViewInterface currentView;
    private Game game;
    private boolean gamePaused;
    private Graphics g;
    private static int displayWidth;
    private static int displayHeight;
    private static int gameWidth;
    private static int gameHeight;
    private Ad ad;
    private BannerSprite bannerSprite;
    private int id;
    private static final int PLACE_FOR_BANNER = 40;
    public static final int EVENT_EXIT = 1;
    public static final int EVENT_MENU = 2;
    public static final int EVENT_HELP = 3;
    public static final int EVENT_ABOUT = 4;
    public static final int EVENT_LEVEL = 5;
    public static final int EVENT_PLAYER = 6;
    public static final int EVENT_PLAYER_MAN = 7;
    public static final int EVENT_PLAYER_WOMAN = 8;
    private AudioManager audioManager;
    private HelpMenu helpMenu;
    private AboutMenu aboutMenu;
    private int currentLevelPlayed = 1;
    private PlayerView playerMenu;
    public static Font font;
    public static String[] lang;
    private static LayerManager bannerView;
    private String language = "/lang";

    public static int getGameHeight() {
        return gameHeight;
    }

    public static void setGameHeight(int gameHeight) {
        Engine.gameHeight = gameHeight;
    }

    public Engine() {
        super(true);
        Main.logln("Engine.Engine()");
        ++Main.indent;
        this.setFullScreenMode(true);
        this.res = Resources.getInstance();
        this.calculateDisplayVariables();
        ALM.setDisplaySize(Engine.getGameWidth(), gameHeight);
        this.audioManager = AudioManager.getInstance();
        font = Font.getFont((int)0, (int)2, (int)8);
        this.g = this.getGraphics();
        this.g.setFont(font);
        this.g.setColor(255, 255, 255);
        lang = TextField.getTextRow(this.getText(this.language), font, 2500);
        this.getAppId();
        Main.logln(String.valueOf(this.getId()));
        this.ad = Ad.start(Main.getInstance(), this.id, this.getWidth(), this.getHeight());
        this.bannerSprite = this.ad.createBannerSprite();
        --Main.indent;
    }

    private void calculateDisplayVariables() {
        Main.logln("Engine.calculateDisplayVariables() ");
        ++Main.indent;
        Graphics g = this.getGraphics();
        displayWidth = this.getWidth();
        displayHeight = this.getHeight();
        Engine.setGameWidth(displayWidth);
        gameHeight = displayHeight - 40;
        Main.logln("displayWidth = " + displayWidth);
        Main.logln("displayHeight = " + displayHeight);
        Main.logln("gameWidth = " + Engine.getGameWidth());
        Main.logln("gameHeight = " + gameHeight);
        --Main.indent;
    }

    public void update() {
        if (this.currentView == this.game && !this.gamePaused) {
            this.game.update();
        }
    }

    public void render() {
        this.g = this.getGraphics();
        this.paint(this.g);
        this.flushGraphics();
    }

    public void changeState(int state) {
    }

    public void handleEvent(int event) {
        Main.logln(String.valueOf(this.gamePaused));
        if (100 < event && event < 116) {
            this.startNewGame(event);
            --Main.indent;
            return;
        }
        switch (event) {
            case 1: {
                Main.getInstance().exit();
                break;
            }
            case 3: {
                this.changeView(this.helpMenu);
                break;
            }
            case 2: {
                this.changeView(this.mainMenu);
                break;
            }
            case 4: {
                this.changeView(this.aboutMenu);
                break;
            }
            case 6: {
                this.changeView(this.playerMenu);
                break;
            }
            case 7: {
                this.game.initLevel(2);
                this.changeView(this.game);
                break;
            }
            case 8: {
                this.game.initLevel(1);
                this.changeView(this.game);
                break;
            }
            case 201: {
                if (!this.gamePaused) {
                    this.game.pauseGame();
                    this.gamePaused = true;
                    Main.logln(String.valueOf(this.gamePaused));
                    break;
                }
                this.game.resumeGame();
                this.gamePaused = false;
                Main.logln(String.valueOf(this.gamePaused));
                break;
            }
            case 202: {
                this.game.resumeGame();
                this.gamePaused = false;
                break;
            }
            case 205: {
                this.game.reset();
                this.game.resumeGame();
                this.gamePaused = false;
                break;
            }
            case 206: {
                this.game.exitGame();
                this.startNewGame(this.currentLevelPlayed % 17 + 101);
                this.gamePaused = false;
                break;
            }
            case 251: {
                this.gamePaused = true;
                break;
            }
            case 252: {
                this.gamePaused = true;
                break;
            }
        }
    }

    private void startNewGame(int level) {
        Main.logln("Engine.startNewGame( " + level + " )");
        ++Main.indent;
        this.currentLevelPlayed = level - 100;
        this.changeView(this.game);
        this.game.resumeGame();
        this.gamePaused = false;
        --Main.indent;
    }

    public void commandAction(Command arg0, Displayable arg1) {
    }

    public void showNotify() {
        Main.logln("Engine.showNotify");
        ++Main.indent;
        this.res.loadResources(Engine.getGameWidth(), gameHeight);
        if (this.mainMenu == null) {
            this.mainMenu = new MainMenu(this);
            this.mainMenu.initResources();
        }
        if (this.helpMenu == null) {
            this.helpMenu = new HelpMenu(this);
            this.helpMenu.initResources();
        }
        if (this.aboutMenu == null) {
            this.aboutMenu = new AboutMenu(this);
            this.aboutMenu.initResources();
        }
        if (this.game == null) {
            this.game = new Game(this);
            this.game.initResources();
        }
        if (this.playerMenu == null) {
            this.playerMenu = new PlayerView(this);
            this.playerMenu.initResources();
        }
        if (bannerView == null) {
            Engine.createBannerView();
        }
        this.ad.startAd();
        this.startApp();
        if (AudioManager.isAudioEnabled() && this.currentView != this.game) {
            this.audioManager.setMusic("/music/music.mp3");
            this.audioManager.playMusic();
        }
        --Main.indent;
    }

    protected void hideNotify() {
        Main.logln("\nEngine.hideNotify");
        ++Main.indent;
        this.pauseApp();
        this.audioManager.stopAll();
        if (this.currentView != this.game) {
            this.audioManager.stopMusic();
        }
        this.ad.stopAd();
        --Main.indent;
    }

    private void pauseApp() {
        Main.logln("Engine.pauseApp()");
        ++Main.indent;
        if (this.currentView == this.game) {
            this.game.pauseGame();
            this.gamePaused = true;
        }
        this.gameThread.requestPause();
        --Main.indent;
    }

    private void startApp() {
        Main.logln("\n");
        Main.logln("Engine.startApp()");
        ++Main.indent;
        if (this.gameThread == null) {
            Main.logln("Engine.GameThread() construction.");
            this.gameThread = new GameThread();
        }
        this.gameThread.requestStart();
        if (this.currentView == null) {
            this.changeView(this.mainMenu);
        }
        --Main.indent;
    }

    private void changeView(ViewInterface view) {
        Main.logln("Engine.changeView(" + view.toString() + ")");
        if (this.currentView == this.game && view != this.game) {
            this.game.pauseGame();
            this.game.exitGame();
            this.gamePaused = true;
        }
        if (view != this.game) {
            if (AudioManager.isAudioEnabled()) {
                this.audioManager.setMusic("/music/music.mp3");
                this.audioManager.playMusic();
            }
        } else {
            this.audioManager.stopMusic();
        }
        this.currentView = view;
        view.refreshData(null);
    }

    public void paint(Graphics g) {
        g.setFont(font);
        g.setColor(0);
        g.fillRect(0, 0, displayWidth, displayHeight);
        try {
            if (this.currentView != null) {
                this.currentView.paint(g, 0, 0);
            }
        }
        catch (NullPointerException exc) {
            exc.printStackTrace();
        }
        bannerView.paint(g, 0, 0);
        this.bannerSprite.paint(g);
    }

    protected void pointerDragged(int x, int y) {
        this.currentView.pointerDragged(x, y);
    }

    protected void pointerPressed(int x, int y) {
        this.currentView.pointerPressed(x, y);
        this.bannerSprite.touchDown(x, y);
    }

    protected void pointerReleased(int x, int y) {
        this.currentView.pointerReleased(x, y);
        if (this.bannerSprite.touchDown(x, y)) {
            this.pauseApp();
            this.ad.openLink();
        }
    }

    public static int getGameWidth() {
        return gameWidth;
    }

    public static void setGameWidth(int gameWidth) {
        Engine.gameWidth = gameWidth;
    }

    public void stopApp() {
        this.gameThread.requestStop();
    }

    public void saveGame() {
        Main.logln("Engine.saveGame()");
        ++Main.indent;
        if (this.game == null) {
            return;
        }
        try {
            RecordStore snapshot = RecordStore.openRecordStore((String)"GameSnapshot", (boolean)true);
            if (snapshot.getNumRecords() == 0) {
                snapshot.addRecord(null, 0, 0);
            }
            byte[] data = this.game.saveGame();
            snapshot.setRecord(this.getRecordId(snapshot), data, 0, data.length);
            snapshot.closeRecordStore();
            Main.logln("Engine.saveGame() saved successfully");
        }
        catch (RecordStoreException exc) {
            Main.logln("Engine.saveGame() error:");
            exc.printStackTrace();
        }
        --Main.indent;
    }

    private int getRecordId(RecordStore store) throws RecordStoreException {
        RecordEnumeration e = store.enumerateRecords(null, null, false);
        try {
            int n = e.nextRecordId();
            return n;
        }
        finally {
            e.destroy();
        }
    }

    public void getAppId() {
        String property = System.getProperty("App-ID-Asha");
        System.out.println(property);
        System.out.println(property);
        if (Main.getInstance().getAppProperty("Nokia-MIDlet-App-Orientation").equals("portrait")) {
            if (this.getHeight() == 400) {
                this.setId(Integer.parseInt(Main.getInstance().getAppProperty("App-ID-S40")));
            } else {
                this.setId(Integer.parseInt(Main.getInstance().getAppProperty("App-ID-Asha")));
            }
        } else if (this.getWidth() == 400) {
            this.setId(Integer.parseInt(Main.getInstance().getAppProperty("App-ID-S40")));
        } else {
            this.setId(Integer.parseInt(Main.getInstance().getAppProperty("App-ID-Asha")));
        }
    }

    private static void createBannerView() {
        Main.logln("Engine.createBannerView()");
        ++Main.indent;
        bannerView = new LayerManager();
        Sprite pad = new Sprite(Resources.getPadImage());
        pad.setPosition(0, displayHeight - 40);
        bannerView.append((Layer)pad);
        --Main.indent;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getText(String path) {
        String text = "";
        String content = "";
        try {
            int read;
            InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream(path), "UTF-8");
            StringBuffer temp = new StringBuffer(1024);
            char[] buffer = new char[1024];
            while ((read = ((Reader)in).read(buffer, 0, buffer.length)) != -1) {
                temp.append(buffer, 0, read);
            }
            content = temp.toString();
            int i = 0;
            while (i < content.length()) {
                text = String.valueOf(text) + content.charAt(i);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR in getText() " + e);
        }
        return text;
    }

    class GameThread
    extends Thread {
        private static final long THREAD_INTERVAL = 50L;
        private boolean pause = true;
        private boolean stop = false;
        private boolean started = false;
        private long lastTime;

        GameThread() {
        }

        public void requestPause() {
            Main.logln("Engine.GameThread.requestPause()");
            this.pause = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStart() {
            Main.logln("Engine.GameThread.requestStart()");
            this.pause = false;
            if (!this.started) {
                this.start();
                this.started = true;
            } else {
                GameThread gameThread = this;
                synchronized (gameThread) {
                    this.notify();
                }
            }
        }

        public void requestStop() {
            Main.logln("Engine.GameThread.requestStop()");
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Main.logln("*thread Engine.GameThread.run() started");
            long time = 0L;
            while (!this.stop) {
                if (this.pause) {
                    GameThread gameThread = this;
                    synchronized (gameThread) {
                        Main.logln("*thread Engine.GameThread.run() paused");
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                }
                time = System.currentTimeMillis();
                timeDelta = time - this.lastTime;
                this.lastTime = System.currentTimeMillis();
                Engine.this.update();
                Engine.this.render();
                time = time + 50L - System.currentTimeMillis();
                try {
                    Thread.sleep(time < 0L ? 0L : time);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Main.logln("*thread Engine.GameThread.run() stopped");
        }
    }
}

