/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.coldarms.tools;

import com.ittop.coldarms.Main;
import com.ittop.coldarms.connection.GameSaverInterface;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class GameSaver
implements GameSaverInterface {
    private static Hashtable instances = new Hashtable();
    RecordStore recordStore;
    String name = "Achievements";

    private GameSaver(String name) {
        this.name = name;
    }

    public boolean getLevelPassed(int levelNumber) {
        RecordStore recordStore;
        block4: {
            Main.logln("GameSaver.getLevelPassed(" + levelNumber + ")");
            this.showFullData();
            if (levelNumber == 0) {
                return true;
            }
            try {
                recordStore = RecordStore.openRecordStore((String)this.name, (boolean)true);
                if (recordStore.getNumRecords() >= levelNumber) break block4;
                recordStore.closeRecordStore();
                return false;
            }
            catch (Exception exc) {
                Main.logln("RSGS.getLevelPassed error: " + exc.toString());
                exc.printStackTrace();
                return false;
            }
        }
        byte[] record = recordStore.getRecord(levelNumber);
        recordStore.closeRecordStore();
        return record[0] != 0;
    }

    public void setLevelPassed(int levelNumber, boolean isPassed) {
        block6: {
            Main.logln("GameSaver.setLevelPassed(" + levelNumber + " " + isPassed + ")");
            ++Main.indent;
            this.showFullData();
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)this.name, (boolean)true);
                if (recordStore.getNumRecords() >= levelNumber) {
                    Main.logln("recordStore.getNumRecords() >= levelNumber");
                    Main.logln("exactly " + levelNumber);
                    byte[] levelData = recordStore.getRecord(levelNumber);
                    if (isPassed) {
                        levelData[0] = 1;
                    } else {
                        levelData[0] = 0;
                        levelData[1] = 0;
                    }
                    recordStore.setRecord(levelNumber, levelData, 0, 2);
                    break block6;
                }
                if (recordStore.getNumRecords() == levelNumber - 1) {
                    Main.logln("recordStore.getNumRecords() == levelNumber - 1");
                    Main.logln("exactly " + levelNumber);
                    byte[] levelData = new byte[]{1, 0};
                    recordStore.addRecord(levelData, 0, 2);
                    break block6;
                }
                throw new IllegalArgumentException("RSGS.setLevelScore trying to add a level when previous was not passed");
            }
            catch (Exception exc) {
                Main.logln("RSGS.setLevelScore error: ");
                exc.printStackTrace();
            }
        }
        --Main.indent;
    }

    public int getLevelScore(int levelNumber) {
        RecordStore recordStore;
        block4: {
            Main.logln("GameSaver.getLevelScore(" + levelNumber + ")");
            this.showFullData();
            try {
                recordStore = RecordStore.openRecordStore((String)this.name, (boolean)true);
                if (recordStore.getNumRecords() >= levelNumber) break block4;
                return 0;
            }
            catch (Exception exc) {
                Main.logln("RSGS.getLevelPassed error: levelNumber = " + levelNumber);
                exc.printStackTrace();
                return 0;
            }
        }
        byte[] record = recordStore.getRecord(levelNumber);
        if (record[1] >= 0 && record[1] <= 3) {
            return record[1];
        }
        return 3;
    }

    public void setLevelScore(int levelNumber, int levelScore) {
        block4: {
            Main.logln("GameSaver.setLevelScore(" + levelNumber + " " + levelScore + ")");
            ++Main.indent;
            this.showFullData();
            Main.logln("RSGS.setLevelScore ");
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)this.name, (boolean)true);
                if (recordStore.getNumRecords() >= levelNumber) {
                    Main.logln(String.valueOf(recordStore.getNumRecords()) + "recordStore.getNumRecords() >= levelNumber = " + levelNumber);
                    byte[] levelData = recordStore.getRecord(levelNumber);
                    levelData[0] = 1;
                    levelData[1] = (byte)Math.max(levelData[1], levelScore);
                    recordStore.setRecord(levelNumber, levelData, 0, 2);
                    break block4;
                }
                if (recordStore.getNumRecords() == levelNumber - 1) {
                    System.out.println(String.valueOf(recordStore.getNumRecords()) + " = recordStore.getNumRecords() == levelNumber - 1 = " + levelNumber);
                    byte[] levelData = new byte[]{1, (byte)levelScore};
                    recordStore.addRecord(levelData, 0, 2);
                    break block4;
                }
                throw new IllegalArgumentException("RSGS.setLevelScore trying to add a level when previous was not passed");
            }
            catch (Exception exc) {
                Main.logln("RSGS.setLevelScore error: ");
                exc.printStackTrace();
            }
        }
        --Main.indent;
    }

    /*
     * Loose catch block
     */
    public void showFullData() {
        block11: {
            Main.logln("GameSaver.showFullData()");
            ++Main.indent;
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)this.name, (boolean)true);
                int i = 1;
                while (i < recordStore.getNumRecords()) {
                    byte[] bt = recordStore.getRecord(i);
                    int j = 0;
                    while (j < bt.length) {
                        System.out.print(String.valueOf(bt[j]));
                        ++j;
                    }
                    ++i;
                }
            }
            catch (RecordStoreFullException e) {
                e.printStackTrace();
                Main.logln("try{} over");
                break block11;
            }
            catch (RecordStoreNotFoundException e) {
                e.printStackTrace();
                break block11;
            }
            catch (RecordStoreException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                Main.logln("try{} over");
                break block11;
            }
            {
                finally {
                    Main.logln("try{} over");
                }
            }
            Main.logln("try{} over");
        }
        --Main.indent;
    }

    public static GameSaver getInstance(String name) {
        Object instanceForName = instances.get(name);
        if (instanceForName == null) {
            GameSaver instance = new GameSaver(name);
            instances.put(name, instance);
            return instance;
        }
        return (GameSaver)instanceForName;
    }
}

