/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.coldarms.tools;

public class SomeMath {
    public static double pow(double base, int exp) {
        if (exp == 0) {
            return 1.0;
        }
        double res = base;
        while (exp > 1) {
            res *= base;
            --exp;
        }
        return res;
    }

    public static double log(double x) {
        long l = Double.doubleToLongBits(x);
        long exp = ((0x7FF0000000000000L & l) >> 52) - 1023L;
        double man = (double)(0xFFFFFFFFFFFFFL & l) / 4.503599627370496E15 + 1.0;
        double lnm = 0.0;
        double a = (man - 1.0) / (man + 1.0);
        int n = 1;
        while (n < 7) {
            lnm += SomeMath.pow(a, n) / (double)n;
            n += 2;
        }
        return 2.0 * lnm + (double)exp * 0.6931471805599453;
    }

    public static double aTan2(double y, double x) {
        double angle;
        double coeff_1 = 0.7853981633974483;
        double coeff_2 = 3.0 * coeff_1;
        double abs_y = Math.abs(y);
        if (x >= 0.0) {
            double r = (x - abs_y) / (x + abs_y);
            angle = coeff_1 - coeff_1 * r;
        } else {
            double r = (x + abs_y) / (abs_y - x);
            angle = coeff_2 - coeff_1 * r;
        }
        return y < 0.0 ? -angle : angle;
    }
}

