/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.coldarms.view;

import com.ittop.coldarms.Main;
import com.ittop.coldarms.components.Button;
import com.ittop.coldarms.connection.ViewInterface;
import com.ittop.coldarms.connection.ViewListener;
import com.ittop.coldarms.engine.Resources;
import com.ittop.coldarms.tools.ALM;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;

public class GameGui
extends ALM
implements ViewInterface {
    private static final int TEXT_ANCHOR = 20;
    private static final int TEXT_CENTER = 65;
    private Resources res;
    private ViewListener listener;
    private Button[] buttons = new Button[4];
    private Button continueButton;
    private Button replayButton;
    private Button pauseButton;
    private Button backToMenuButton;
    private int starSize = 46;
    private boolean showGameData;
    private boolean pressed;
    private boolean released;

    public GameGui(ViewListener listener) {
        Main.logln("GameGui.GameGui(listener)");
        this.listener = listener;
    }

    public boolean pointerPressed(int x, int y) {
        this.pressed = false;
        int i = 0;
        while (!this.pressed && i < 4) {
            this.pressed |= this.buttons[i].pointerPressed(x, y);
            ++i;
        }
        return this.pressed;
    }

    public boolean pointerReleased(int x, int y) {
        this.released = false;
        int i = 0;
        while (!this.released && i < 4) {
            this.released |= this.buttons[i].pointerReleased(x, y);
            ++i;
        }
        return this.released;
    }

    public boolean pointerDragged(int x, int y) {
        return false;
    }

    public void initResources() {
        Main.logln("GameGui.initResources( " + this.res + " )");
        ++Main.indent;
        this.initGrid(3, 3, 40, 40, 5, 5);
        this.pauseButton = new Button(Resources.pause, new Button.ButtonListener(){

            public void buttonReleased() {
                GameGui.this.listener.handleEvent(201);
                Main.logln("pressed pause");
            }

            public void buttonPressed() {
            }
        });
        this.backToMenuButton = new Button(Resources.menu60, new Button.ButtonListener(){

            public void buttonReleased() {
                GameGui.this.listener.handleEvent(2);
                GameGui.this.showGameVersion();
            }

            public void buttonPressed() {
            }
        });
        System.out.println(((Object)((Object)this.backToMenuButton)).toString());
        this.replayButton = new Button(Resources.replay, new Button.ButtonListener(){

            public void buttonReleased() {
                GameGui.this.listener.handleEvent(205);
            }

            public void buttonPressed() {
            }
        });
        this.continueButton = new Button(Resources.playRound, new Button.ButtonListener(){

            public void buttonReleased() {
                GameGui.this.listener.handleEvent(207);
            }

            public void buttonPressed() {
            }
        });
        this.buttons[0] = this.pauseButton;
        this.buttons[1] = this.backToMenuButton;
        this.buttons[2] = this.replayButton;
        this.buttons[3] = this.continueButton;
        this.insertToGrid((Layer)this.backToMenuButton, 0, 1, 0, 16);
        this.insertToGrid((Layer)this.replayButton, 1, 1, 0, 16);
        this.insertToGrid((Layer)this.continueButton, 2, 1, 0, 16);
        this.insert((Layer)this.pauseButton, 0, 1026);
        --Main.indent;
    }

    public void paint(Graphics g, int x, int y) {
        super.paint(g, 0, 0);
    }

    public void showPauseVersion() {
        Main.logln("GameGui.showPauseVersion()");
        ++Main.indent;
        this.showGameData = false;
        this.pauseButton.setVisible(false);
        this.backToMenuButton.setVisible(true);
        this.continueButton.setVisible(true);
        this.replayButton.setVisible(true);
        --Main.indent;
    }

    public void showGameVersion() {
        Main.logln("GameGui.showGameVersion()");
        ++Main.indent;
        this.showGameData = true;
        this.pauseButton.setVisible(true);
        this.backToMenuButton.setVisible(false);
        this.continueButton.setVisible(false);
        this.replayButton.setVisible(false);
        --Main.indent;
    }

    public void showVictoryVersion(int score) {
        Main.logln("GameGui.showVictoryVersion( " + score + " )");
        ++Main.indent;
        this.showGameData = false;
        this.backToMenuButton.setVisible(true);
        this.continueButton.setVisible(true);
        this.replayButton.setVisible(true);
        --Main.indent;
    }

    public void showGameOverVersion() {
        Main.logln("GameGui.showGameOverVersion()");
        ++Main.indent;
        this.showGameData = false;
        this.backToMenuButton.setVisible(true);
        this.continueButton.setVisible(true);
        this.replayButton.setVisible(true);
        --Main.indent;
    }

    public void refreshData(int[] args) {
    }
}

