/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.coldarms.view;

import com.ittop.coldarms.components.Button;
import com.ittop.coldarms.components.SoundButton;
import com.ittop.coldarms.connection.ViewInterface;
import com.ittop.coldarms.connection.ViewListener;
import com.ittop.coldarms.engine.Resources;
import com.ittop.coldarms.tools.ALM;
import com.ittop.coldarms.tools.ImageHelper;
import javax.microedition.lcdui.game.Layer;

public class MainMenu
extends ALM
implements ViewInterface {
    private ViewListener viewListener;
    private SoundButton sound;
    private Button exit;
    private Button play;
    private Button help;
    private Button about;

    public MainMenu(ViewListener viewListener) {
        this.viewListener = viewListener;
    }

    public void initResources() {
        this.append((Layer)Resources.backMenu);
        this.sound = SoundButton.getInstance();
        this.insert((Layer)this.sound, 0, 1);
        this.exit = new Button(ImageHelper.getInstance().loadImage("/components/exit.png"), new Button.ButtonListener(){

            public void buttonReleased() {
                MainMenu.this.viewListener.handleEvent(1);
            }

            public void buttonPressed() {
            }
        });
        this.insert((Layer)this.exit, 0, 2);
        this.play = new Button(ImageHelper.getInstance().loadImage("/components/play.png"), new Button.ButtonListener(){

            public void buttonReleased() {
                MainMenu.this.viewListener.handleEvent(6);
            }

            public void buttonPressed() {
            }
        });
        this.help = new Button(ImageHelper.getInstance().loadImage("/components/question.png"), new Button.ButtonListener(){

            public void buttonReleased() {
                MainMenu.this.viewListener.handleEvent(3);
            }

            public void buttonPressed() {
            }
        });
        this.about = new Button(ImageHelper.getInstance().loadImage("/components/info.png"), new Button.ButtonListener(){

            public void buttonReleased() {
                MainMenu.this.viewListener.handleEvent(4);
            }

            public void buttonPressed() {
            }
        });
        this.initGrid(3, 5);
        this.insertToGrid((Layer)this.help, 0, 4, 0);
        this.insertToGrid((Layer)this.about, 2, 4, 0);
        this.insertToGrid((Layer)this.play, 1, 4, 0);
    }

    public boolean pointerPressed(int x, int y) {
        this.sound.pointerPressed(x, y);
        this.exit.pointerPressed(x, y);
        this.play.pointerPressed(x, y);
        this.about.pointerPressed(x, y);
        this.help.pointerPressed(x, y);
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        this.sound.pointerReleased(x, y);
        this.exit.pointerReleased(x, y);
        this.play.pointerReleased(x, y);
        this.about.pointerReleased(x, y);
        this.help.pointerReleased(x, y);
        return false;
    }

    public boolean pointerDragged(int x, int y) {
        return false;
    }

    public void refreshData(int[] args) {
    }
}

