/*
 * Decompiled with CFR 0.152.
 */
package com.am.adlib;

import com.am.adlib.AdData;
import com.am.adlib.Banner;
import com.am.adlib.StatListener;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONObject;
import org.json.me.JSONTokener;

public class JSONParser {
    public boolean parse(String jsonStr, StatListener statListener) {
        boolean error = true;
        Vector<Banner> banners = new Vector<Banner>();
        AdData data = AdData.getInstance();
        int weightSum = 0;
        try {
            JSONTokener jsonTokener = new JSONTokener(jsonStr);
            JSONObject jsonObj = new JSONObject(jsonTokener.nextValue().toString());
            boolean active = jsonObj.getBoolean("active");
            boolean statistics = jsonObj.getBoolean("statistics");
            int bannersUpdateRate = Integer.parseInt(jsonObj.getString("banners_update_rate"));
            JSONArray bannersArray = jsonObj.getJSONArray("banners");
            int i = 0;
            while (i < bannersArray.length()) {
                JSONObject bannerObject = (JSONObject)bannersArray.get(i);
                String company = bannerObject.getString("company");
                JSONObject text = bannerObject.getJSONObject("text");
                String imgSrc = text.getString("img");
                String link = text.getString("href");
                int bannerId = bannerObject.getInt("id");
                int refreshRate = Integer.parseInt(bannerObject.getString("refresh_rate"));
                int weight = bannerObject.getInt("weight");
                weightSum += weight;
                Banner banner = new Banner();
                banner.setCompany(company);
                banner.setImgSrc(imgSrc);
                banner.setLink(link);
                banner.setId(bannerId);
                banner.setRefreshRate(refreshRate);
                banner.setWeight(weight);
                banners.addElement(banner);
                ++i;
            }
            data.setData(banners, statistics, bannersUpdateRate, weightSum, active);
            error = false;
        }
        catch (Exception e) {
            statListener.onError(1, e.toString());
        }
        return error;
    }
}

