/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.coldarms.components;

import com.ittop.coldarms.audio.AudioManager;
import com.ittop.coldarms.components.Button;
import com.ittop.coldarms.engine.Resources;
import javax.microedition.lcdui.Image;

public class SoundButton
extends Button {
    static int soundButtonSize;
    private static SoundButton instance;
    static Button.ButtonListener listener;

    static {
        listener = new Button.ButtonListener(){

            public void buttonReleased() {
                if (AudioManager.isAudioEnabled()) {
                    AudioManager.setAudioEnabled(false);
                    AudioManager.getInstance().stopAll();
                    AudioManager.getInstance().stopMusic();
                    instance.setImage(Resources.getInstance().soundOff, soundButtonSize, soundButtonSize);
                } else {
                    AudioManager.setAudioEnabled(true);
                    AudioManager.getInstance().playMusic();
                    instance.setImage(Resources.getInstance().soundOn, soundButtonSize, soundButtonSize);
                }
            }

            public void buttonPressed() {
            }
        };
    }

    public static SoundButton getInstance() {
        if (instance == null) {
            instance = SoundButton.createSoundButton();
        }
        return instance;
    }

    public static SoundButton createSoundButton() {
        return new SoundButton(Resources.getInstance().soundOn);
    }

    private SoundButton(Image image) {
        super(image, listener);
        soundButtonSize = image.getHeight();
    }

    public boolean pointerPressed(int x, int y) {
        if (this.isVisible() && this.enabled && this.contains(x, y)) {
            this.pressed = true;
            listener.buttonPressed();
            return true;
        }
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        if (this.pressed && this.isVisible() && this.enabled && this.contains(x, y)) {
            this.pressed = false;
            listener.buttonReleased();
            return true;
        }
        this.pressed = false;
        return false;
    }
}

