/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.coldarms.engine;

import com.ittop.coldarms.Main;
import com.ittop.coldarms.engine.Engine;
import com.ittop.coldarms.tools.ImageHelper;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Resources {
    private static boolean initialized = false;
    private static Resources instance;
    private static float DEFAULT_WIDTH;
    private static float DEFAULT_HEIGHT;
    public static float scalingWidth;
    public static float scalingHeight;
    public static int HEIGHT_BALL;
    public static final String SAMPLE_MUSIC = "/music/music.mp3";
    public static final String backPathmainMenu = "/start.png";
    public static Sprite backMenu;
    public static final String backPathScrean = "/bg/fon.jpg";
    public static Sprite backScreen;
    public static final String bedPath = "/bg/bed.png";
    public static Sprite bed;
    private static final String levelButtonsPath = "/levelButtons/";
    private static final String levelButtonYellowPath = "/levelButtons/yellow.png";
    private static final String levelButtonGreyPath = "/levelButtons/grey.png";
    private static final String soundOnPath = "/components/sound.png";
    public Image soundOn;
    private static final String soundOffPath = "/components/mute.png";
    public Image soundOff;
    public static final String starOnPath = "/components/starOn.png";
    public static final String starOffPath = "/components/starOff.png";
    public static final String exitPath = "/components/exit.png";
    public static final String backPath = "/components/b_back.png";
    public static final String playPath = "/components/play.png";
    public static final String helpPath = "/components/question.png";
    public static final String aboutpath = "/components/info.png";
    private static final String menuPath = "/components/menu.png";
    private static final String menuPath40 = "/components/menu40.png";
    public static Image menu40;
    public static Image menu60;
    private static final String replayPath = "/components/replay.png";
    public static Image replay;
    private static final String playRoundPath = "/components/play.png";
    public static Image playRound;
    private static final String pausePath = "/components/pause.png";
    public static Image pause;
    public static final String manpath = "/char/ico1.png";
    public static final String womanpath = "/char/ico2.png";
    public static final String manbodypath = "/char/boy.png";
    public static final String womanbodypath = "/char/girl.png";
    private static final String padPath = "/pad.jpg";
    public static final String pincetPath = "/btns/1.png";
    public static final String vataPath = "/btns/2.png";
    public static final String plastrPath = "/btns/3.png";
    public static final String tabletPath = "/btns/4.png";
    public static final String nosepath = "/btns/5.png";
    private static final String instr1 = "/tools/1.png";
    private static Image imginstr1;
    private static final String instr2 = "/tools/2.png";
    private static Image imginstr2;
    private static final String instr3 = "/tools/3.png";
    private static Image imginstr3;
    private static final String instr4 = "/tools/4.png";
    private static Image imginstr4;
    private static final String instr5 = "/tools/5.png";
    private static Image imginstr5;

    public static Resources getInstance() {
        if (instance == null) {
            instance = new Resources();
        }
        return instance;
    }

    public void loadResources(int gameWidth, int gameHeight) {
        Main.logln("Resources.loadResources.gameWidth, gameHeight");
        ++Main.indent;
        Main.logln(Main.getInstance().getAppProperty("Nokia-MIDlet-App-Orientation"));
        this.culculateScalling(gameWidth, gameHeight);
        this.soundOn = ImageHelper.getInstance().loadImage(soundOnPath);
        this.soundOff = ImageHelper.getInstance().loadImage(soundOffPath);
        backMenu = new Sprite(ImageHelper.getInstance().loadImage(backPathmainMenu, scalingWidth, scalingHeight));
        backScreen = new Sprite(ImageHelper.getInstance().loadImage(backPathScrean, scalingWidth, scalingHeight));
        bed = new Sprite(ImageHelper.getInstance().loadImage(bedPath, scalingWidth, scalingHeight));
        pause = ImageHelper.getInstance().loadImage(pausePath);
        menu40 = ImageHelper.getInstance().loadImage(menuPath40);
        menu60 = ImageHelper.getInstance().loadImage(menuPath);
        replay = ImageHelper.getInstance().loadImage(replayPath);
        playRound = ImageHelper.getInstance().loadImage("/components/play.png");
        imginstr1 = ImageHelper.getInstance().loadImage(instr1);
        imginstr2 = ImageHelper.getInstance().loadImage(instr2);
        imginstr3 = ImageHelper.getInstance().loadImage(instr3);
        imginstr4 = ImageHelper.getInstance().loadImage(instr4);
        imginstr5 = ImageHelper.getInstance().loadImage(instr5);
        --Main.indent;
    }

    private void culculateScalling(int defaultWidth, int defaultHeight) {
        if (Main.getInstance().getAppProperty("Nokia-MIDlet-App-Orientation").equals("portrait")) {
            DEFAULT_WIDTH = 240.0f;
            DEFAULT_HEIGHT = 400.0f;
            Main.logln("Resources.culculateScalling");
            ++Main.indent;
            Main.logln("DEFAULT_WIDTH = " + DEFAULT_WIDTH);
            Main.logln("DEFAULT_HEIGHT = " + DEFAULT_HEIGHT);
            --Main.indent;
        } else if (Main.getInstance().getAppProperty("Nokia-MIDlet-App-Orientation").equals("landscape")) {
            DEFAULT_HEIGHT = 240.0f;
            DEFAULT_WIDTH = 426.0f;
            Main.logln("Resources.culculateScalling");
            ++Main.indent;
            Main.logln("DEFAULT_WIDTH = " + DEFAULT_WIDTH);
            Main.logln("DEFAULT_HEIGHT = " + DEFAULT_HEIGHT);
            --Main.indent;
        }
        scalingWidth = (float)defaultWidth / DEFAULT_WIDTH;
        scalingHeight = (float)defaultHeight / DEFAULT_HEIGHT;
        Main.logln("Resources.culculateScalling.defaultWidth, defaultHeight");
        ++Main.indent;
        Main.logln("scalingWidth = " + scalingWidth);
        Main.logln("scalingHeight = " + scalingHeight);
        --Main.indent;
        HEIGHT_BALL = (int)(270.0f * scalingHeight);
    }

    public static int calculateCoordx(int x) {
        x = (int)((float)x * scalingWidth);
        return x;
    }

    public static int calculateCoordy(int y) {
        y = (int)((float)y * scalingHeight);
        return y;
    }

    public static Image getLevelButtonYellowImage(int size) {
        return ImageHelper.getInstance().loadImage(levelButtonYellowPath, size, size);
    }

    public static Image getLevelButtonGreyImage(int size) {
        return ImageHelper.getInstance().loadImage(levelButtonGreyPath, size, size);
    }

    public static Image getLevelButtonImage(int levelNumber, int size) {
        String fullPath = levelButtonsPath + levelNumber + ".png";
        return ImageHelper.getInstance().loadImage(fullPath, size * 4 / 5, size * 4 / 5);
    }

    public static Image getBody(int i) {
        switch (i) {
            case 1: {
                return ImageHelper.getInstance().loadImage(womanbodypath, scalingWidth, scalingHeight);
            }
            case 2: {
                return ImageHelper.getInstance().loadImage(manbodypath, scalingWidth, scalingHeight);
            }
        }
        return null;
    }

    public static Image getInstr(int i) {
        switch (i) {
            case 1: {
                return imginstr1;
            }
            case 2: {
                return imginstr2;
            }
            case 3: {
                return imginstr3;
            }
            case 4: {
                return imginstr4;
            }
            case 5: {
                return imginstr5;
            }
        }
        return null;
    }

    public static Image getVictory() {
        return ImageHelper.getInstance().loadImage("/components/victory.png");
    }

    public static Image getDefeat() {
        return ImageHelper.getInstance().loadImage("/components/defeat.png");
    }

    public static Image getPadImage() {
        return ImageHelper.getInstance().loadImage(padPath, Engine.getGameWidth(), 40);
    }
}

