/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.coldarms.game;

import com.ittop.coldarms.Main;
import com.ittop.coldarms.components.Instrument;
import com.ittop.coldarms.connection.GameInterface;
import com.ittop.coldarms.connection.ViewInterface;
import com.ittop.coldarms.connection.ViewListener;
import com.ittop.coldarms.engine.Resources;
import com.ittop.coldarms.view.GameGui;
import com.ittop.coldarms.view.ManInstr;
import com.ittop.coldarms.view.ManRani;
import com.ittop.coldarms.view.WomanInstr;
import com.ittop.coldarms.view.WomanRani;
import java.util.Timer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Game
implements ViewInterface,
GameInterface,
ViewListener {
    private ViewListener viewListener;
    private Timer sequencer = new Timer();
    private boolean gameJustWon = false;
    private boolean gameJustLost = false;
    private int currentLevel;
    private GameGui gameGui;
    private static final int indent = 30;
    public static final int EVENT_PAUSE_TOGGLE = 201;
    public static final int EVENT_PAUSE_OFF = 202;
    public static final int EVENT_GAME_REPLAY = 205;
    public static final int EVENT_GAME_NEXT_LEVEL = 206;
    public static final int EVENT_GAME_OVER = 251;
    public static final int EVENT_GAME_WON = 252;
    public static final int EVENT_GAME_CONTINUE = 207;
    protected static final int EVENT_PLAY_MUSIC = 208;
    public static final int EVENT_PINCET = 209;
    public static final int EVENT_VATA = 210;
    public static final int EVENT_PLASTR = 211;
    public static final int EVENT_TABLET = 212;
    public static final int EVENT_NOSE = 213;
    private Image person;
    private ViewInterface currentInstuments;
    private ViewInterface currentRani;
    private ManInstr maininstr;
    private WomanInstr womenInstr;
    private ManRani manrani;
    private Instrument instr;
    private int levelinstr;
    private WomanRani womanrani;

    public Game(ViewListener viewListener) {
        this.viewListener = viewListener;
        System.out.println(viewListener.getClass());
    }

    public byte[] saveGame() {
        Main.logln("TankDefence.getSnapshot()");
        ++Main.indent;
        byte[] bt = new byte[]{1};
        --Main.indent;
        return bt;
    }

    public boolean loadGame(byte[] data) {
        return false;
    }

    public void newGame(int level) {
    }

    public void update() {
    }

    public void check() {
        int i;
        if (this.getLevelinstr() == 3) {
            i = 0;
            while (i < 10) {
                if (this.instr.collidesWith((Sprite)this.manrani.getLayerAt(i), true)) {
                    this.manrani.getLayerAt(i).setVisible(false);
                }
                ++i;
            }
        }
        if (this.getLevelinstr() == 2 && this.instr.collidesWith((Sprite)this.manrani.getLayerAt(10), true)) {
            this.manrani.getLayerAt(10).setVisible(false);
        }
        if (this.getLevelinstr() == 1) {
            i = 11;
            while (i < this.manrani.getSize()) {
                if (this.instr.collidesWith((Sprite)this.manrani.getLayerAt(i), true)) {
                    this.manrani.getLayerAt(i).setVisible(false);
                }
                ++i;
            }
            if (this.instr.collidesWith((Sprite)this.manrani.getLayerAt(14), false)) {
                this.manrani.getLayerAt(14).setVisible(false);
            }
        }
        if (this.getLevelinstr() == 4 && this.instr.collidesWith((Sprite)this.womanrani.getLayerAt(3), true)) {
            this.womanrani.getLayerAt(3).setVisible(false);
        }
        if (this.getLevelinstr() == 5 && this.instr.collidesWith((Sprite)this.womanrani.getLayerAt(2), true)) {
            this.womanrani.getLayerAt(2).setVisible(false);
        }
    }

    public void resumeGame() {
        this.gameGui.showGameVersion();
    }

    public void pauseGame() {
        this.gameGui.showPauseVersion();
    }

    public void exitGame() {
    }

    public void initResources() {
        this.gameGui = new GameGui(this);
        this.gameGui.initResources();
        this.gameGui.showGameVersion();
        this.maininstr = new ManInstr(this);
        this.maininstr.initResources();
        this.womenInstr = new WomanInstr(this);
        this.womenInstr.initResources();
        this.manrani = new ManRani();
        this.manrani.initResources();
        this.womanrani = new WomanRani();
        this.womanrani.initResources();
        this.instr = new Instrument(Resources.getInstr(1));
        this.instr.setVisible(false);
    }

    public void paint(Graphics g, int x, int y) {
        Resources.backScreen.paint(g);
        Resources.bed.paint(g);
        g.drawImage(this.getPerson(), x, y, 20);
        this.currentRani.paint(g, x, y);
        this.instr.paint(g);
        this.currentInstuments.paint(g, x, y);
        this.gameGui.paint(g, x, y);
    }

    public boolean pointerPressed(int x, int y) {
        this.currentInstuments.pointerPressed(x, y);
        this.gameGui.pointerPressed(x, y);
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        this.currentInstuments.pointerReleased(x, y);
        this.gameGui.pointerReleased(x, y);
        this.instr.setVisible(false);
        return false;
    }

    public boolean pointerDragged(int x, int y) {
        this.instr.setRefPixelPosition(x, y);
        this.check();
        return false;
    }

    public void refreshData(int[] args) {
    }

    public void changeState(int state) {
    }

    public void handleEvent(int event) {
        Main.logln("Game.GameGui listener.handleEvent( event " + event + ")");
        ++Main.indent;
        switch (event) {
            case 207: {
                if (!this.gameJustLost && !this.gameJustWon) {
                    Main.logln("!gameJustLost && !gameJustWon");
                    this.viewListener.handleEvent(202);
                    break;
                }
                if (this.gameJustWon) {
                    Main.logln("gameJustWon");
                    this.gameJustWon = false;
                    this.viewListener.handleEvent(206);
                    break;
                }
                if (!this.gameJustLost) break;
                Main.logln("gameJustLost");
                this.gameJustLost = false;
                this.viewListener.handleEvent(205);
                break;
            }
            case 201: {
                if (this.gameJustLost || this.gameJustWon) break;
                this.viewListener.handleEvent(201);
                break;
            }
            case 209: {
                this.setLevelinstr(1);
                this.instr.setImage(Resources.getInstr(this.getLevelinstr()));
                this.instr.setPosition(this.maininstr.pincet.getX(), this.maininstr.pincet.getX());
                this.instr.setVisible(true);
                break;
            }
            case 210: {
                this.setLevelinstr(2);
                this.instr.setImage(Resources.getInstr(this.getLevelinstr()));
                this.instr.setPosition(this.maininstr.plastr.getX(), this.maininstr.plastr.getX());
                this.instr.setVisible(true);
                break;
            }
            case 211: {
                this.setLevelinstr(3);
                this.instr.setImage(Resources.getInstr(this.getLevelinstr()));
                this.instr.setPosition(this.maininstr.plastr.getX(), this.maininstr.plastr.getX());
                this.instr.setVisible(true);
                break;
            }
            case 212: {
                this.setLevelinstr(4);
                this.instr.setImage(Resources.getInstr(this.getLevelinstr()));
                this.instr.setPosition(this.maininstr.plastr.getX(), this.maininstr.plastr.getX());
                this.instr.setVisible(true);
                break;
            }
            case 213: {
                this.setLevelinstr(5);
                this.instr.setImage(Resources.getInstr(this.getLevelinstr()));
                this.instr.setPosition(this.maininstr.plastr.getX(), this.maininstr.plastr.getX());
                this.instr.setVisible(true);
                break;
            }
            default: {
                this.viewListener.handleEvent(event);
            }
        }
        --Main.indent;
    }

    public void initLevel(int i) {
        this.setCurrentLevel(i);
        this.setPerson(Resources.getBody(i));
        this.reset();
        switch (i) {
            case 1: {
                this.setCurrentInstuments(this.womenInstr);
                this.setCurrentRani(this.womanrani);
                break;
            }
            case 2: {
                this.setCurrentInstuments(this.maininstr);
                this.setCurrentRani(this.manrani);
                break;
            }
        }
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    public Image getPerson() {
        return this.person;
    }

    public void setPerson(Image person) {
        this.person = person;
    }

    public ViewInterface getCurrentInstuments() {
        return this.currentInstuments;
    }

    public void setCurrentInstuments(ViewInterface currentInstuments) {
        this.currentInstuments = currentInstuments;
    }

    public int getLevelinstr() {
        return this.levelinstr;
    }

    public void setLevelinstr(int levelinstr) {
        this.levelinstr = levelinstr;
    }

    public ViewInterface getCurrentRani() {
        return this.currentRani;
    }

    public void setCurrentRani(ViewInterface currentRani) {
        this.currentRani = currentRani;
    }

    public void reset() {
        int i = 0;
        while (i < this.manrani.getSize()) {
            this.manrani.getLayerAt(i).setVisible(true);
            ++i;
        }
        i = 0;
        while (i < this.womanrani.getSize()) {
            this.womanrani.getLayerAt(i).setVisible(true);
            ++i;
        }
    }
}

