/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.util.Vector;
import math.Rect;

public class Clip {
    public int x;
    public int y;
    public int w;
    public int h;
    Vector clips;

    public Clip() {
        this.clips = new Vector();
    }

    public Clip(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.clips = new Vector();
        this.clips.addElement(new Rect(x, y, w, h));
    }

    public static Clip Union(Clip a, Clip b) {
        Clip temp = new Clip();
        int ax = a.x + a.w;
        int bx = b.x + b.w;
        int ay = a.y + a.h;
        int by = b.y + b.h;
        temp.x = Math.min(a.x, b.x);
        temp.y = Math.min(a.y, b.y);
        temp.w = Math.max(ax, bx) - temp.x;
        temp.h = Math.max(ay, by) - temp.y;
        return temp;
    }

    public static boolean IsEqual(Clip a, Clip b) {
        return a.x == b.x && a.y == b.y && a.h == b.h && a.w == b.w;
    }

    public void addClip(int x, int y, int w, int h) {
        this.clips.addElement(new Rect(x, y, w, h));
    }

    public boolean Contains(int x, int y) {
        for (int i = 0; i < this.clips.size(); ++i) {
            Rect temp = (Rect)this.clips.elementAt(i);
            if (x < temp.x || x > temp.x + temp.w || y < temp.y || y > temp.y + temp.h) continue;
            return true;
        }
        return false;
    }
}

