/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game;

import com.apr.game.ErrorMessage;
import com.apr.game.states.State;
import com.apr.game.states.StateMachine;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.MediaException;
import javax.microedition.midlet.MIDlet;

public abstract class Game
extends GameCanvas
implements Runnable {
    protected boolean done;
    public static int frameRate = 60;
    protected StateMachine machine;
    protected MIDlet mid;
    private Timer timer = new Timer();
    public static int clickX;
    public static int clickY;
    public static boolean screenClicked;
    public static boolean dragDown;
    public static boolean dragUp;
    private Graphics g;
    public boolean onePressed;
    public boolean twoPressed;
    public boolean threePressed;
    public boolean fourPressed;
    public boolean fivePressed;
    public boolean sixPressed;
    public boolean sevenPressed;
    public boolean eightPressed;
    public boolean ninePressed;
    public boolean poundPressed;
    public boolean leftActionPressed;
    public boolean rightActionPressed;
    public static String message;
    public int myKeyCode = -1;
    private long prevTime;
    private long curTime;
    private int time;

    public Game(MIDlet mid) {
        super(true);
        this.mid = mid;
        this.setFullScreenMode(true);
        State.setSize(this.getWidth(), this.getHeight());
        State.soundOn = true;
        try {
            this.initSettings();
        }
        catch (IOException ex) {
            this.setErrorMessage("IO Error");
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            this.setErrorMessage("Media error");
            ex.printStackTrace();
        }
        catch (OutOfMemoryError ex) {
            this.setErrorMessage("Memory not enough");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            this.setErrorMessage("Something bad happened");
            ex.printStackTrace();
        }
    }

    public void start() {
        this.done = false;
        new Thread(this).start();
    }

    public void stop() {
    }

    public void run() {
        this.prevTime = System.currentTimeMillis();
        this.g = this.getGraphics();
        TimerMain timerMain = new TimerMain();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)timerMain, 0L, (long)frameRate);
    }

    public void update() throws InterruptedException, IOException, MediaException, IllegalArgumentException {
        this.curTime = System.currentTimeMillis();
        this.time = (int)(this.curTime - this.prevTime);
        this.prevTime = this.curTime;
        if (this.machine.isDone()) {
            this.done = true;
            this.timer.cancel();
            this.mid.notifyDestroyed();
        } else {
            this.machine.update(this.time);
        }
    }

    public void render(Graphics g) {
        if (this.done) {
            return;
        }
        this.machine.render(g);
        this.flushGraphics();
    }

    public void setErrorMessage(String msg) {
        ErrorMessage error = new ErrorMessage(msg, this.getWidth(), this.getHeight());
        Display.getDisplay((MIDlet)this.mid).setCurrent((Displayable)error);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.timer.cancel();
        this.mid.notifyDestroyed();
    }

    public MIDlet getMidlet() {
        return this.mid;
    }

    protected abstract void initSettings() throws IOException, MediaException;

    protected void keyPressed(int keyCode) {
        message = this.getKeyName(keyCode);
        this.myKeyCode = keyCode;
        if (message.startsWith("SOFT") || message.startsWith("SELECTION") || message.startsWith("ACTION")) {
            if (message.endsWith("LEFT") || message.endsWith("1")) {
                this.leftActionPressed = true;
            }
            if (message.endsWith("RIGHT") || message.endsWith("2")) {
                this.rightActionPressed = true;
            }
        }
        if (message.startsWith("6")) {
            this.leftActionPressed = true;
            return;
        }
        if (message.startsWith("7")) {
            this.rightActionPressed = true;
            return;
        }
        if (keyCode == -6) {
            this.leftActionPressed = true;
            return;
        }
        if (keyCode == -7) {
            this.rightActionPressed = true;
            return;
        }
        if (keyCode == -20) {
            this.leftActionPressed = true;
            return;
        }
        if (keyCode == -21) {
            this.rightActionPressed = true;
            return;
        }
        if (keyCode == -23) {
            this.fivePressed = true;
            return;
        }
        if (keyCode == 35) {
            this.poundPressed = true;
            return;
        }
        if (keyCode == 49) {
            this.onePressed = true;
            return;
        }
        if (keyCode == 50) {
            this.twoPressed = true;
            return;
        }
        if (keyCode == 51) {
            this.threePressed = true;
            return;
        }
        if (keyCode == 52) {
            this.fourPressed = true;
            return;
        }
        if (keyCode == 53) {
            this.fivePressed = true;
            return;
        }
        if (keyCode == 54) {
            this.sixPressed = true;
            return;
        }
        if (keyCode == 55) {
            this.sevenPressed = true;
            return;
        }
        if (keyCode == 56) {
            this.eightPressed = true;
            return;
        }
        if (keyCode == 57) {
            this.ninePressed = true;
            return;
        }
    }

    protected void keyReleased(int keyCode) {
        message = null;
        this.myKeyCode = -1;
        String value = this.getKeyName(keyCode);
        if (value.startsWith("SOFT") || value.startsWith("SELECTION") || value.startsWith("ACTION")) {
            if (value.endsWith("LEFT") || value.endsWith("1")) {
                this.leftActionPressed = false;
            }
            if (value.endsWith("RIGHT") || value.endsWith("2")) {
                this.rightActionPressed = false;
            }
        }
        if (value.startsWith("6")) {
            this.leftActionPressed = false;
            return;
        }
        if (value.startsWith("7")) {
            this.rightActionPressed = false;
            return;
        }
        if (keyCode == -6) {
            this.leftActionPressed = false;
            return;
        }
        if (keyCode == -7) {
            this.rightActionPressed = false;
            return;
        }
        if (keyCode == -20) {
            this.leftActionPressed = false;
            return;
        }
        if (keyCode == -21) {
            this.rightActionPressed = false;
            return;
        }
        if (keyCode == -23) {
            this.fivePressed = false;
            return;
        }
        if (keyCode == 35) {
            this.poundPressed = false;
            return;
        }
        if (keyCode == 49) {
            this.onePressed = false;
            return;
        }
        if (keyCode == 50) {
            this.twoPressed = false;
            return;
        }
        if (keyCode == 51) {
            this.threePressed = false;
            return;
        }
        if (keyCode == 52) {
            this.fourPressed = false;
            return;
        }
        if (keyCode == 53) {
            this.fivePressed = false;
            return;
        }
        if (keyCode == 54) {
            this.sixPressed = false;
            return;
        }
        if (keyCode == 55) {
            this.sevenPressed = false;
            return;
        }
        if (keyCode == 56) {
            this.eightPressed = false;
            return;
        }
        if (keyCode == 57) {
            this.ninePressed = false;
            return;
        }
    }

    protected void pointerPressed(int x, int y) {
        clickX = x;
        clickY = y;
        screenClicked = true;
    }

    protected void pointerReleased(int x, int y) {
        screenClicked = false;
        dragDown = false;
        dragUp = false;
    }

    protected void pointerDragged(int x, int y) {
        if (clickY > y) {
            dragDown = true;
        }
        if (clickY < y) {
            dragUp = true;
        }
        clickX = x;
        clickY = y;
    }

    static {
        message = "";
    }

    class TimerMain
    extends TimerTask {
        TimerMain() {
        }

        public void run() {
            try {
                Game.this.update();
                Game.this.render(Game.this.g);
            }
            catch (MediaException ex) {
                Game.this.setErrorMessage(ex.getMessage());
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                Game.this.setErrorMessage("Interrupted execution");
                ex.printStackTrace();
            }
            catch (IOException ex) {
                Game.this.setErrorMessage(ex.getMessage());
                ex.printStackTrace();
            }
            catch (IllegalArgumentException ex) {
                Game.this.setErrorMessage("An argument is wrong");
                ex.printStackTrace();
            }
            catch (OutOfMemoryError ex) {
                Game.this.setErrorMessage("Memory not enough");
                ex.printStackTrace();
            }
            catch (NullPointerException ex) {
                Game.this.setErrorMessage("Some null pointer: " + message);
                ex.printStackTrace();
            }
            catch (Exception ex) {
                Game.this.setErrorMessage("Unknown error" + message);
                ex.printStackTrace();
            }
        }
    }
}

