/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.font;

import com.apr.game.font.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class AngelFont
implements Font {
    protected Image img;
    private Hashtable map = new Hashtable();
    private int space;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AngelFont(String img, String path) {
        InputStream is = null;
        InputStreamReader isr = null;
        StringBuffer line = new StringBuffer();
        try {
            this.img = Image.createImage((String)img);
            is = this.getClass().getResourceAsStream(path);
            isr = new InputStreamReader(is, "UTF-8");
            boolean done = false;
            while (!done) {
                int bytesRead = isr.read();
                if (bytesRead != -1) {
                    if (bytesRead == 10) {
                        String s = line.toString().trim();
                        if (s.startsWith("info")) {
                            int start = s.indexOf("size=");
                            int end = s.indexOf(" ", start);
                            this.space = Integer.valueOf(s.substring(start + 5, end));
                        } else if (s.startsWith("char ")) {
                            Integer id = new Integer(Integer.parseInt(s.substring(8, 12).trim()));
                            int x = Integer.parseInt(s.substring(15, 18).trim());
                            int y = Integer.parseInt(s.substring(23, 26).trim());
                            byte w = (byte)Integer.parseInt(s.substring(35, 37).trim());
                            byte h = (byte)Integer.parseInt(s.substring(48, 50).trim());
                            byte yo = (byte)Integer.parseInt(s.substring(76, 78).trim());
                            Values value = new Values(x, y, w, h, yo);
                            this.map.put(id, value);
                        }
                        line.setLength(0);
                        continue;
                    }
                    line.append((char)bytesRead);
                    continue;
                }
                done = true;
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (NumberFormatException ne) {
            ne.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException io) {}
        }
    }

    public void print(Graphics g, int x, int y, String text, byte position) throws IllegalArgumentException {
        Values value;
        if (text == null) {
            return;
        }
        int SIZE = 0;
        for (int i = 0; i < text.length(); ++i) {
            Integer textValue = new Integer(text.charAt(i));
            value = (Values)this.map.get(textValue);
            SIZE += value.w;
        }
        switch (position) {
            case 0: {
                SIZE /= 2;
                break;
            }
            case 1: {
                SIZE = 0;
            }
        }
        int px = x;
        if (text.charAt(0) > '\u03e8') {
            for (int i = text.length() - 1; i >= 0; --i) {
                Integer textValue = new Integer(text.charAt(i));
                value = (Values)this.map.get(textValue);
                g.drawRegion(this.img, value.x, value.y, (int)value.w, (int)value.h, 0, px - SIZE, y + value.yo, 20);
                px += value.w;
            }
        } else {
            for (int i = 0; i < text.length(); ++i) {
                Integer textValue = new Integer(text.charAt(i));
                value = (Values)this.map.get(textValue);
                g.drawRegion(this.img, value.x, value.y, (int)value.w, (int)value.h, 0, px - SIZE, y + value.yo, 20);
                px += value.w;
            }
        }
    }

    public int getW() {
        return this.space;
    }

    public int getH() {
        return this.space;
    }

    class Values {
        int x;
        int y;
        byte w;
        byte h;
        byte yo;

        public Values(int x, int y, byte w, byte h, byte yo) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.yo = yo;
        }
    }
}

