/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.sound;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public final class SoundClass
implements Runnable {
    public static String TYPE = "audio/amr";
    public static String EXTENSION = ".amr";
    public static boolean PREFETCH = false;
    private Player player;
    private Thread thread;

    public SoundClass(String path) throws IOException, MediaException {
        InputStream is = this.getClass().getResourceAsStream(path + EXTENSION);
        this.player = Manager.createPlayer((InputStream)is, (String)TYPE);
        if (PREFETCH) {
            this.player.prefetch();
        }
    }

    public void run() {
        try {
            this.player.start();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void play() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.player.close();
        this.player = null;
        this.thread = null;
    }

    public void deactivate() {
        this.player.deallocate();
        this.thread = null;
    }
}

