/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.states;

import com.apr.game.Game;
import com.apr.game.Utils;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;

public abstract class State
extends Utils {
    public static Game game;
    protected boolean upPressed;
    protected boolean downPressed;
    protected boolean leftPressed;
    protected boolean rightPressed;
    protected boolean firePressed;
    protected boolean poundPressed;
    protected boolean leftActionPressed;
    protected boolean rightActionPressed;
    protected boolean clicked;
    protected boolean onePressed;
    protected boolean twoPressed;
    protected boolean threePressed;
    protected boolean fourPressed;
    protected boolean fivePressed;
    protected boolean sixPressed;
    protected boolean sevenPressed;
    protected boolean eightPressed;
    protected boolean ninePressed;
    protected boolean upC;
    protected boolean downC;
    protected boolean leftC;
    protected boolean rightC;
    protected boolean fireC;
    protected boolean done;
    protected byte type;

    public State(byte type) {
        this.type = type;
    }

    public abstract void enter() throws IOException, MediaException;

    public abstract void exit() throws MediaException;

    public abstract byte nextState();

    public abstract void render(Graphics var1);

    public boolean isDone() {
        return this.done;
    }

    public void update(int time) throws IOException, MediaException {
        if (this.clicked && !Game.screenClicked) {
            this.checkClick(Game.clickX, Game.clickY);
            this.clicked = false;
            return;
        }
        if (game.hasPointerEvents() && Game.screenClicked) {
            this.clicked = true;
            return;
        }
        int keyStates = game.getKeyStates();
        if (!State.game.leftActionPressed && this.leftActionPressed) {
            this.leftActionPressed = false;
            this.moveLeftAction();
        }
        if (!State.game.rightActionPressed && this.rightActionPressed) {
            this.rightActionPressed = false;
            this.moveRightAction();
        }
        if (!State.game.onePressed && this.onePressed) {
            this.pressOne();
            this.onePressed = false;
        }
        if (!State.game.threePressed && this.threePressed) {
            this.pressThree();
            this.threePressed = false;
        }
        if (keyStates != 512 && this.sevenPressed) {
            this.pressSeven();
            this.sevenPressed = false;
        }
        if (keyStates != 1024 && this.ninePressed) {
            this.pressNine();
            this.ninePressed = false;
        }
        if (this.leftC) {
            if ((keyStates & 4) != 0) {
                this.moveLeft();
            }
        } else if ((keyStates & 4) == 0 && this.leftPressed || !State.game.fourPressed && this.fourPressed) {
            this.moveLeft();
            this.leftPressed = false;
            this.fourPressed = false;
        }
        if (this.rightC) {
            if ((keyStates & 0x20) != 0) {
                this.moveRight();
            }
        } else if ((keyStates & 0x20) == 0 && this.rightPressed || !State.game.sixPressed && this.sixPressed) {
            this.moveRight();
            this.rightPressed = false;
            this.sixPressed = false;
        }
        if (this.downC) {
            if ((keyStates & 0x40) != 0) {
                this.moveDown();
            }
        } else if ((keyStates & 0x40) == 0 && this.downPressed || !State.game.eightPressed && this.eightPressed) {
            this.moveDown();
            this.downPressed = false;
            this.eightPressed = false;
        }
        if (this.upC) {
            if ((keyStates & 2) != 0) {
                this.moveUp();
            }
        } else if ((keyStates & 2) == 0 && this.upPressed || !State.game.twoPressed && this.twoPressed) {
            this.moveUp();
            this.upPressed = false;
            this.twoPressed = false;
        }
        if (this.fireC) {
            if ((keyStates & 0x100) != 0) {
                this.fire();
            }
        } else if ((keyStates & 0x100) == 0 && this.firePressed || !State.game.fivePressed && this.fivePressed) {
            this.fire();
            this.firePressed = false;
            this.fivePressed = false;
        }
        if (State.game.poundPressed) {
            this.movePound();
        }
        if (keyStates == 4096) {
            this.movePound();
        }
        if ((keyStates & 0x40) != 0 && !this.downPressed) {
            this.downPressed = true;
        }
        if ((keyStates & 2) != 0 && !this.upPressed) {
            this.upPressed = true;
        }
        if ((keyStates & 0x100) != 0 && !this.firePressed) {
            this.firePressed = true;
        }
        if ((keyStates & 4) != 0 && !this.leftPressed) {
            this.leftPressed = true;
        }
        if ((keyStates & 0x20) != 0 && !this.rightPressed) {
            this.rightPressed = true;
        }
        if (State.game.onePressed && !this.onePressed) {
            this.onePressed = true;
        }
        if (State.game.twoPressed && !this.twoPressed) {
            this.twoPressed = true;
        }
        if (State.game.threePressed && !this.threePressed) {
            this.threePressed = true;
        }
        if (State.game.fourPressed && !this.fourPressed) {
            this.fourPressed = true;
        }
        if (State.game.fivePressed && !this.fivePressed) {
            this.fivePressed = true;
        }
        if (State.game.sixPressed && !this.sixPressed) {
            this.sixPressed = true;
        }
        if (keyStates == 512 && !this.sevenPressed) {
            this.sevenPressed = true;
        }
        if (State.game.eightPressed && !this.eightPressed) {
            this.eightPressed = true;
        }
        if (keyStates == 1024 && !this.ninePressed) {
            this.ninePressed = true;
        }
        if (State.game.leftActionPressed && !this.leftActionPressed) {
            this.leftActionPressed = true;
        }
        if (State.game.rightActionPressed && !this.rightActionPressed) {
            this.rightActionPressed = true;
        }
    }

    protected void moveUp() {
    }

    protected void moveDown() {
    }

    protected void fire() {
    }

    protected void moveLeft() {
    }

    protected void moveRight() {
    }

    protected void movePound() {
    }

    protected void moveLeftAction() {
    }

    protected void moveRightAction() {
    }

    protected void pressOne() {
    }

    protected void pressThree() {
    }

    protected void pressSeven() {
    }

    protected void pressNine() {
    }

    protected void checkClick(int x, int y) {
    }
}

