/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.states;

import com.apr.game.Game;
import com.apr.game.displayable.Background;
import com.apr.game.states.State;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

public final class StateAbout
extends State {
    private Image imgPaz;
    private Image imgCellup;
    private byte next;
    private Background back;

    public StateAbout(byte type, byte next, Background back) throws IOException, MediaException {
        super(type);
        this.next = next;
        this.back = back;
    }

    public void enter() throws IOException, MediaException {
        this.done = false;
        this.imgPaz = StateAbout.loadImage("/images/paz.png");
        this.imgCellup = StateAbout.loadImage("/images/cellulup.png");
    }

    public void exit() {
        this.imgPaz = null;
        this.imgCellup = null;
    }

    public byte nextState() {
        return this.next;
    }

    public void update(int time) throws IOException, MediaException {
        super.update(time);
        if (Game.screenClicked) {
            this.done = true;
        }
    }

    public void fire() {
        this.done = true;
    }

    public void render(Graphics g) {
        this.back.render(g);
        font.print(g, HALF_W, 0, "Paz", (byte)0);
        font.print(g, HALF_W, font.getH(), "Interactive", (byte)0);
        font.print(g, HALF_W, font.getH() * 2, "Limited", (byte)0);
        font.print(g, HALF_W, font.getH() * 4, "Entertainment", (byte)0);
        font.print(g, HALF_W, font.getH() * 5, "innovations", (byte)0);
        g.drawImage(this.imgPaz, HALF_W - this.imgPaz.getWidth() / 2, HALF_H, 0);
        g.drawImage(this.imgCellup, HALF_W - this.imgCellup.getWidth() / 2, HALF_H + this.imgPaz.getHeight(), 0);
    }
}

