/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.states;

import com.apr.game.states.State;
import java.io.IOException;
import javax.microedition.media.MediaException;

public abstract class StateClock
extends State {
    protected int curTime;
    protected int maxTime;
    private boolean endWithFire;
    private byte nextState;

    public StateClock(byte type, int maxTime, byte nextState, boolean endWithFire) {
        super(type);
        this.maxTime = maxTime;
        this.endWithFire = endWithFire;
        this.nextState = nextState;
    }

    public void enter() throws IOException {
        this.curTime = 0;
        this.firePressed = false;
        this.done = false;
    }

    public void exit() {
    }

    public void update(int time) throws IOException, MediaException {
        super.update(time);
        this.curTime += time;
        if (this.curTime > this.maxTime) {
            this.done = true;
        }
    }

    protected void fire() {
        if (this.endWithFire) {
            this.done = true;
        }
    }

    public byte nextState() {
        return this.nextState;
    }
}

