/*
 * Decompiled with CFR 0.152.
 */
package logic;

public final class Board {
    public byte[] board;
    private boolean turn;

    public Board(int n, boolean bl) {
        this.board = new byte[n * n];
        this.turn = bl;
    }

    public Board(Board board) {
        this.board = new byte[board.size()];
        this.copy(board);
    }

    public boolean getTurn() {
        return this.turn;
    }

    public void copy(Board board) {
        for (int i = 0; i < this.board.length; ++i) {
            this.board[i] = board.board[i];
        }
        this.turn = board.turn;
    }

    private void set(int n, byte by) {
        this.board[n] = by;
        this.turn = !this.turn;
    }

    public void makeMove(int n) {
        if (this.turn) {
            this.set(n, (byte)1);
        } else {
            this.set(n, (byte)2);
        }
    }

    public byte get(int n) {
        if (n < 0 || n > this.board.length) {
            return -1;
        }
        return this.board[n];
    }

    public int size() {
        return this.board.length;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.board.length; ++i) {
            string = string + this.board[i];
        }
        return string;
    }
}

