/*
 * Decompiled with CFR 0.152.
 */
package states;

import com.apr.game.displayable.Background;
import com.apr.game.states.State;
import game.Locale;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;
import logic.GameState;

public class StateContinueYesNo
extends State {
    private Background background;
    private static String PLAY;
    private static String YES;
    private static String NO;
    private static int yPlay;
    private static int xYesNo;
    private static int yYes;
    private static int yNo;
    private static int wYes;
    private static int hYesNo;
    private static int wNo;
    private boolean play;
    private byte state;
    private byte stateYes;
    private byte stateNo;

    public StateContinueYesNo(byte by, byte by2, byte by3, Background background) throws IOException {
        super(by);
        this.stateYes = by2;
        this.stateNo = by3;
        this.background = background;
        PLAY = Locale.getString("Saved.Continue");
        YES = Locale.getString("Yes");
        NO = Locale.getString("No");
    }

    public void enter() throws IOException, MediaException {
        try {
            if (!GameState.isLoaded()) {
                this.state = this.stateNo;
                this.done = true;
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        this.done = false;
        this.play = true;
        yPlay = HALF_H - font.getH() * 2;
        xYesNo = HALF_W - font.getW();
        yYes = HALF_H - font.getH();
        yNo = HALF_H;
        wYes = font.getW() * 3;
        wNo = font.getW() * 2;
        hYesNo = font.getH();
    }

    public void exit() throws MediaException {
    }

    public byte nextState() {
        return this.state;
    }

    public void render(Graphics graphics) {
        if (this.done) {
            return;
        }
        this.background.render(graphics);
        font.print(graphics, HALF_W, yPlay, PLAY, (byte)0);
        if (this.play) {
            font.print(graphics, HALF_W, yYes, ">" + YES + "<", (byte)0);
            font.print(graphics, HALF_W, yNo, NO, (byte)0);
        } else {
            font.print(graphics, HALF_W, yYes, YES, (byte)0);
            font.print(graphics, HALF_W, yNo, ">" + NO + "<", (byte)0);
        }
    }

    protected void moveUp() {
        this.play = !this.play;
    }

    protected void moveDown() {
        this.play = !this.play;
    }

    protected void fire() {
        if (!this.play) {
            this.state = this.stateNo;
            GameState.deleteSettings();
        } else {
            this.state = this.stateYes;
        }
        this.done = true;
    }

    protected void checkClick(int n, int n2) {
        if (StateContinueYesNo.inBounds(n, n2, xYesNo, yYes, wYes, hYesNo)) {
            this.play = true;
            this.fire();
        }
        if (StateContinueYesNo.inBounds(n, n2, xYesNo, yNo, wNo, hYesNo)) {
            this.play = false;
            this.fire();
        }
    }
}

