/*
 * Decompiled with CFR 0.152.
 */
package states;

import buttons.ButtonBoardSize;
import buttons.ButtonComputerLevel;
import buttons.ButtonComputerOponent;
import buttons.ButtonFinish;
import buttons.ButtonGamePoints;
import buttons.ButtonOColor;
import buttons.ButtonPlayerPiece;
import buttons.ButtonSound;
import buttons.ButtonTurnTime;
import buttons.ButtonVibration;
import buttons.ButtonWhoStarts;
import buttons.ButtonXColor;
import com.apr.game.buttons.Button;
import com.apr.game.buttons.Buttons;
import com.apr.game.displayable.Background;
import com.apr.game.displayable.Title;
import com.apr.game.states.State;
import com.apr.game.states.StateMachine;
import game.Locale;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import logic.TTTConstants;
import states.options.StateOptionsPart;

public class StateOptions
extends StateMachine {
    private static final byte STATE_PART_1 = 1;
    private static final byte STATE_PART_2 = 2;
    private static final byte STATE_PART_3 = 3;

    public StateOptions(byte by, byte by2, int n, Image image) throws IOException, MediaException {
        super(by, by2);
        Background background = new Background("/images/options/back_settings.jpg");
        Title title = new Title(Locale.getString("OptionsImage"));
        State[] stateArray = new State[3];
        ButtonSound buttonSound = new ButtonSound(Locale.getString("Options.Sound"), TTTConstants.SOUND_STRING, image);
        ButtonVibration buttonVibration = new ButtonVibration(Locale.getString("Options.Vibration"), TTTConstants.VIBRATION_STRING, image);
        ButtonGamePoints buttonGamePoints = new ButtonGamePoints(Locale.getString("Options.GamePoints"), TTTConstants.GAME_POINTS_STRING, 10, 99, image);
        String[] stringArray = new String[]{Locale.getString("EasyImage"), Locale.getString("MediumImage"), Locale.getString("HardImage")};
        ButtonComputerLevel buttonComputerLevel = new ButtonComputerLevel(Locale.getString("Options.Difficulty"), TTTConstants.COMPUTER_LEVEL_STRING, stringArray, image);
        Buttons buttons = new Buttons(new Button[]{buttonSound, buttonVibration, buttonGamePoints, buttonComputerLevel});
        stateArray[0] = new StateOptionsPart(1, 3, 2, n, image, background, title, buttons);
        String[] stringArray2 = new String[]{"/images/options/computer.png", "/images/options/player.png"};
        ButtonComputerOponent buttonComputerOponent = new ButtonComputerOponent(Locale.getString("Options.Oponent"), TTTConstants.COMPUTER_OPONENT_STRING, stringArray2, image);
        String[] stringArray3 = new String[]{"/images/options/no_time.png", "/images/options/20.png", "/images/options/30.png", "/images/options/40.png"};
        ButtonTurnTime buttonTurnTime = new ButtonTurnTime(Locale.getString("Options.TurnTime"), TTTConstants.TURN_TIME_STRING, stringArray3, image);
        String[] stringArray4 = new String[]{"Normal", "3inLine"};
        ButtonFinish buttonFinish = new ButtonFinish(Locale.getString("Options.Finish"), TTTConstants.FINISH_ROW_STRING, stringArray4, image);
        String[] stringArray5 = new String[]{"/images/options/3x3.png", "/images/options/4x4.png", "/images/options/5x5.png"};
        ButtonBoardSize buttonBoardSize = new ButtonBoardSize(Locale.getString("Options.Size"), TTTConstants.CURRENT_SIZE_STRING, stringArray5, image, buttonFinish);
        Buttons buttons2 = new Buttons(new Button[]{buttonComputerOponent, buttonTurnTime, buttonBoardSize, buttonFinish});
        stateArray[1] = new StateOptionsPart(2, 1, 3, n, image, background, title, buttons2);
        String[] stringArray6 = new String[]{"/images/x_blue_small.png", "/images/o_blue_small.png", "/images/options/switch.png", "/images/options/random.png"};
        ButtonWhoStarts buttonWhoStarts = new ButtonWhoStarts(Locale.getString("Options.WhoStarts"), TTTConstants.WHO_STARTS_STRING, stringArray6, image);
        String[] stringArray7 = new String[]{"/images/x_blue_small.png", "/images/o_blue_small.png"};
        ButtonPlayerPiece buttonPlayerPiece = new ButtonPlayerPiece(Locale.getString("Options.PlayerPiece"), TTTConstants.PLAYER_PIECE_STRING, stringArray7, image);
        String[] stringArray8 = new String[]{"/images/options/random.png", "/images/x_yellow_small.png", "/images/x_orange_small.png", "/images/x_green_small.png", "/images/x_blue_small.png"};
        ButtonXColor buttonXColor = new ButtonXColor(Locale.getString("Options.XColor"), TTTConstants.X_COLOR_STRING, stringArray8, image);
        String[] stringArray9 = new String[]{"/images/options/random.png", "/images/o_yellow_small.png", "/images/o_orange_small.png", "/images/o_green_small.png", "/images/o_blue_small.png"};
        ButtonOColor buttonOColor = new ButtonOColor(Locale.getString("Options.OColor"), TTTConstants.O_COLOR_STRING, stringArray9, image);
        Buttons buttons3 = new Buttons(new Button[]{buttonWhoStarts, buttonPlayerPiece, buttonXColor, buttonOColor});
        stateArray[2] = new StateOptionsPart(3, 2, 1, n, image, background, title, buttons3);
        this.addStates(stateArray);
        this.setDefaultState(stateArray[0]);
    }
}

