/*
 * Decompiled with CFR 0.152.
 */
package states.play;

import com.apr.game.states.State;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;
import logic.GameState;

public class StateMove
extends State {
    private static final int MAX_TIME = 50;
    private byte nextState;
    private int curTime;
    private byte turnX;
    private byte turnO;
    private byte endGame;
    private byte index;
    private int x;
    private int y;
    private boolean cw;

    public StateMove(byte by, byte by2, byte by3, byte by4) {
        super(by);
        this.turnX = by2;
        this.turnO = by3;
        this.endGame = by4;
    }

    public void enter() throws IOException, MediaException {
        this.curTime = 0;
        this.done = false;
        if (GameState.isTurnX()) {
            this.cw = !this.cw;
        }
        this.index = 0;
        this.x = GameState.getPoint((int)GameState.currentMove).x;
        this.y = GameState.getPoint((int)GameState.currentMove).y;
        StateMove.vibrate(game.getMidlet());
    }

    public void update(int n) {
        this.curTime += n;
        if (this.curTime > 50) {
            this.index = (byte)(this.index + 1);
            this.curTime = 0;
            if (this.index >= GameState.NUM_ANIMS) {
                GameState.makeMove();
                byte by = GameState.isFinish();
                if (by == 0) {
                    this.nextState = GameState.isTurnX() ? this.turnX : this.turnO;
                } else {
                    GameState.WHO_WON = by;
                    this.nextState = this.endGame;
                }
                this.done = true;
            }
        }
    }

    public void exit() throws MediaException {
    }

    public byte nextState() {
        return this.nextState;
    }

    public void render(Graphics graphics) {
        GameState.render(graphics);
        if (this.done) {
            return;
        }
        if (GameState.isTurnX()) {
            if (this.cw) {
                graphics.drawImage(GameState.imgXsCW[this.index], this.x, this.y, 0);
            } else {
                graphics.drawImage(GameState.imgXsCC[this.index], this.x, this.y, 0);
            }
        } else if (this.cw) {
            graphics.drawImage(GameState.imgOsCW[this.index], this.x, this.y, 0);
        } else {
            graphics.drawImage(GameState.imgOsCC[this.index], this.x, this.y, 0);
        }
    }
}

