/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.buttons;

import com.apr.game.Utils;
import com.apr.game.buttons.Button;
import com.apr.game.states.State;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Buttons
extends Utils {
    protected Button[] buttons;
    protected byte curOption;
    protected int startX;
    protected int startY;

    public Buttons(Button[] buttons) {
        this.buttons = buttons;
        this.curOption = 0;
    }

    public void enter(int startX, int startY) throws IOException {
        this.startX = startX;
        this.startY = startY;
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setStringValue();
            this.buttons[i].setPos(startX + HALF_W - this.buttons[i].getWidth() / 2, startY + i * this.buttons[i].getHeight());
            this.buttons[i].loadValue();
            this.buttons[i].setFrame(0);
        }
        this.buttons[this.curOption].setFrame(1);
    }

    public void setPosition(int startX, int startY) {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setPos(startX + State.HALF_W - this.buttons[i].getWidth() / 2, startY + i * this.buttons[i].getHeight());
        }
    }

    public void updatePosition(int dx, int dy) {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].updatePosition(dx, dy);
        }
    }

    public void render(Graphics g) {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].render(g);
        }
    }

    public void moveDown() {
        this.buttons[this.curOption].setFrame(0);
        this.curOption = (byte)(this.curOption + 1);
        if (this.curOption >= this.buttons.length) {
            this.curOption = 0;
        }
        this.buttons[this.curOption].setFrame(1);
    }

    public void moveUp() {
        this.buttons[this.curOption].setFrame(0);
        this.curOption = (byte)(this.curOption - 1);
        if (this.curOption < 0) {
            this.curOption = (byte)(this.buttons.length - 1);
        }
        this.buttons[this.curOption].setFrame(1);
    }

    public byte getCurOption() {
        return this.curOption;
    }

    public void exit() {
    }

    public boolean checkButton(int x, int y) {
        for (int i = 0; i < this.buttons.length; i = (int)((byte)(i + 1))) {
            if (!Buttons.inBounds(x, y, this.buttons[i].getX(), this.buttons[i].getY(), this.buttons[i].getWidth(), this.buttons[i].getHeight())) continue;
            this.buttons[this.curOption].setFrame(0);
            this.curOption = (byte)i;
            this.buttons[this.curOption].setFrame(1);
            return true;
        }
        return false;
    }

    public void fire() {
        this.buttons[this.curOption].fire();
    }

    public void left() {
        this.buttons[this.curOption].left();
    }

    public void right() {
        this.buttons[this.curOption].right();
    }

    public int getCurrentX() {
        return this.buttons[this.curOption].getSX();
    }

    public int getCurrentY() {
        return this.buttons[this.curOption].getSY();
    }
}

