/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.buttons;

import com.apr.game.animations.Point;
import com.apr.game.buttons.Button;
import com.apr.game.buttons.Buttons;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public final class PositionButtons
extends Buttons {
    private Point[] positions;

    public PositionButtons(Button[] buttons, Point[] positions) {
        super(buttons);
        this.positions = positions;
    }

    public void enter(int startX, int startY) throws IOException {
        this.startX = startX;
        this.startY = startY;
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setStringValue();
            this.buttons[i].setPos(startX + this.positions[i].x, startY + this.positions[i].y);
            this.buttons[i].loadValue();
            this.buttons[i].setFrame(0);
        }
        this.buttons[this.curOption].setFrame(1);
    }

    public void setPosition(int startX, int startY) {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setPos(startX + this.positions[i].x, startY + this.positions[i].y);
        }
    }

    private void increaseY(int y) {
        for (int i = 0; i < this.positions.length; ++i) {
            this.buttons[i].setPos(this.buttons[i].getX(), this.startY + this.positions[i].y - y);
        }
    }

    public void moveUp() {
        super.moveUp();
        if (this.curOption <= 6) {
            this.increaseY(0);
        } else {
            this.increaseY((this.curOption - 6) * 30);
        }
    }

    public void moveDown() {
        super.moveDown();
        if (this.curOption <= 6) {
            this.increaseY(0);
        } else {
            this.increaseY((this.curOption - 6) * 30);
        }
    }

    public void render(Graphics g) {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i].getY() < this.startY || this.buttons[i].getY() >= H - this.startY) continue;
            this.buttons[i].render(g);
        }
    }
}

