/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.displayable;

import com.apr.game.displayable.Displayable;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public final class ActionButton
extends Displayable {
    public static final byte BACK = 1;
    public static final byte OK = 2;
    public static final byte PAUSE = 3;
    public static final byte SPECIAL = 0;
    public static final byte LEFT = 0;
    public static final byte RIGHT = 1;
    public static final byte CENTER = 2;
    private byte type;
    private byte position;
    private Image image;
    private Sprite sprite;
    private String path;

    public ActionButton(byte type, byte position) {
        this.type = type;
        this.position = position;
    }

    public ActionButton(String path, byte position) {
        this.type = 0;
        this.position = position;
        this.path = path;
    }

    public void enter() throws IOException {
        switch (this.type) {
            case 1: {
                this.image = Image.createImage((String)"/images/back_button.png");
                break;
            }
            case 2: {
                this.image = Image.createImage((String)"/images/ok_button.png");
                break;
            }
            case 3: {
                this.image = Image.createImage((String)"/images/pause_button.png");
                break;
            }
            case 0: {
                this.image = Image.createImage((String)this.path);
            }
        }
        this.sprite = new Sprite(this.image, this.image.getWidth() / 2, this.image.getHeight());
        switch (this.position) {
            case 0: {
                this.sprite.setPosition(0, H - this.image.getHeight());
                break;
            }
            case 1: {
                this.sprite.setPosition(W - this.image.getWidth() / 2, H - this.image.getHeight());
                break;
            }
            case 2: {
                this.sprite.setPosition(HALF_W - this.image.getWidth() / 4, H - this.image.getHeight());
            }
        }
        this.drop();
    }

    public void render(Graphics g) {
        this.sprite.paint(g);
    }

    public void exit() {
        this.image = null;
        this.sprite = null;
    }

    public int getH() {
        return this.image.getHeight();
    }

    public int getW() {
        return this.sprite.getWidth();
    }

    public int getX() {
        return this.sprite.getX();
    }

    public int getY() {
        return this.sprite.getY();
    }

    public void press() {
        this.sprite.setFrame(1);
    }

    public void drop() {
        this.sprite.setFrame(0);
    }
}

