/*
 * Decompiled with CFR 0.152.
 */
package states;

import com.apr.game.displayable.ActionButton;
import com.apr.game.displayable.Background;
import com.apr.game.states.StateMoving;
import game.Locale;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;

public final class StateInfoTTT
extends StateMoving {
    private static final byte OFFSET = 2;
    private byte prevState;
    private byte nextState;
    private byte state;
    private Background background;
    private ActionButton prevButton;
    private ActionButton nextButton;
    private ActionButton backButton;
    private String[] data;
    private String name;
    private String top;
    private int startY;

    public StateInfoTTT(byte by, byte by2, byte by3, String string, Background background, int n, int n2) {
        super(by, n);
        this.prevState = by2;
        this.nextState = by3;
        this.background = background;
        this.startY = n2;
        this.name = string;
        this.backButton = new ActionButton(Locale.getString("BackImage"), 2);
        this.nextButton = new ActionButton(Locale.getString("NextImage"), 1);
        this.prevButton = new ActionButton(Locale.getString("PrevImage"), 0);
    }

    public void enter() throws IOException, MediaException {
        int n;
        super.enter();
        this.prevButton.enter();
        this.nextButton.enter();
        this.backButton.enter();
        InputStream inputStream = this.getClass().getResourceAsStream("/text/" + this.name + "_he.txt");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        int n3 = 0;
        boolean bl = false;
        while ((n = inputStreamReader.read()) != -1) {
            if (n == 10) {
                if (!bl) {
                    this.top = stringBuffer.toString();
                    bl = true;
                    n3 = 0;
                } else if (n2 == -1) {
                    n2 = Integer.parseInt(stringBuffer.toString());
                    this.data = new String[n2];
                    n3 = 0;
                } else {
                    this.data[n3] = stringBuffer.toString();
                    ++n3;
                }
                stringBuffer.delete(0, stringBuffer.length());
                continue;
            }
            if (n > 10000 || n == 13) continue;
            stringBuffer.append((char)n);
        }
    }

    public void exit() throws MediaException {
        this.data = null;
        this.prevButton.exit();
        this.nextButton.exit();
        this.backButton.exit();
    }

    public byte nextState() {
        return this.state;
    }

    public void render(Graphics graphics) {
        this.background.render(graphics);
        if (this.data == null) {
            return;
        }
        font.print(graphics, this.offset + HALF_W, 0, this.top, (byte)0);
        for (int i = 0; i < this.data.length; ++i) {
            fontSmall.print(graphics, this.offset + HALF_W, this.startY + fontSmall.getH() * i, this.data[i], (byte)0);
        }
        this.prevButton.render(graphics);
        this.nextButton.render(graphics);
        this.backButton.render(graphics);
    }

    public void moveLeftAction() {
        this.state = this.prevState;
        this.currentStart = 1;
        this.prevButton.press();
        this.startEnding();
    }

    public void moveRightAction() {
        this.state = this.nextState;
        this.currentStart = 0;
        this.nextButton.press();
        this.startEnding();
    }

    public void fire() {
        this.state = (byte)-1;
        this.backButton.press();
        this.startEnding();
    }

    public void moveLeft() {
        this.moveLeftAction();
    }

    public void moveRight() {
        this.moveRightAction();
    }

    public void pressFour() {
        this.moveLeftAction();
    }

    public void pressSix() {
        this.moveRightAction();
    }

    public void pressFive() {
        this.fire();
    }

    protected void checkClick(int n, int n2) {
        if (StateInfoTTT.inBounds(n, n2, this.prevButton.getX(), this.prevButton.getY(), this.prevButton.getW(), this.prevButton.getH())) {
            this.moveLeftAction();
        }
        if (StateInfoTTT.inBounds(n, n2, this.nextButton.getX(), this.nextButton.getY(), this.nextButton.getW(), this.nextButton.getH())) {
            this.moveRightAction();
        }
        if (StateInfoTTT.inBounds(n, n2, this.backButton.getX(), this.backButton.getY(), this.backButton.getW(), this.backButton.getH())) {
            this.fire();
        }
    }
}

