/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;

public class UIModel {
    public static final int FOOD_ATTRIBUTE_IMAGE_SIZE = 24;
    public static final int BORDER_ATTRIBUTE_IMAGE_HEITH = 12;
    public static final int BORDER_ATTRIBUTE_IMAGE_WIDTH = 67;
    public static final int ROLE_ATTRIBUTE_WIDTH = 19;
    public static final int ROLE_ATTRIBUTE_HEITH = 32;
    int incresespeed = 3;
    int nextfootgenratY = 120;
    int foodIncY = 30;
    int playerMINY = 20;
    public static final int GAME_ATTRIBUTE_FRAME_DELAY = 50;
    public static final int GAME_ATTRIBUTE_PIXEL_DENSITY_Y = 5;
    public static final int GAME_ATTRIBUTE_LEVEL_UP_FACTOR = 40;
    public static final int GAME_ATTRIBUTE_GRAVITY_VELOCITY = 25;
    public static final int GAME_STATUS_PAUSE = 0;
    public static final int GAME_STATUS_RUNNING = 1;
    public static final int GAME_STATUS_GAMEOVER = 2;
    public static final int EFFECT_FLAG_NO_EFFECT = 0;
    public static final int EFFECT_FLAG_NORMAL = 1;
    public static final int EFFECT_FLAG_UNSTABLE = 2;
    public static final int EFFECT_FLAG_SPRING = 3;
    public static final int EFFECT_FLAG_SPIKED = 4;
    public static final int EFFECT_FLAG_MOVING = 5;
    public static final int EFFECT_FLAG_TOOLS = 6;
    public static final int ROLE_ATTRIBUTE_FRAME_DELAY = 2;
    public static final int ROLE_ATTRIBUTE_HP_MAX = 12;
    public static final int ROLE_STATUS_ON_FOOTBOARD = 0;
    public static final int ROLE_STATUS_ON_FOOTBOARD_LEFT = 1;
    public static final int ROLE_STATUS_ON_FOOTBOARD_RIGHT = 2;
    public static final int ROLE_STATUS_FREEFALL = 3;
    public static final int ROLE_STATUS_FREEFALL_LEFT = 4;
    public static final int ROLE_STATUS_FREEFALL_RIGHT = 5;
    public static final int ROLE_SHARP_STANDING = 0;
    public static final int ROLE_SHARP_FREEFALL_NO1 = 1;
    public static final int ROLE_SHARP_FREEFALL_NO2 = 2;
    public static final int ROLE_SHARP_FREEFALL_NO3 = 3;
    public static final int ROLE_SHARP_FREEFALL_NO4 = 4;
    public static final int ROLE_SHARP_MOVE_LEFT_NO1 = 5;
    public static final int ROLE_SHARP_MOVE_LEFT_NO2 = 6;
    public static final int ROLE_SHARP_MOVE_LEFT_NO3 = 7;
    public static final int ROLE_SHARP_MOVE_LEFT_NO4 = 8;
    public static final int ROLE_SHARP_MOVE_RIGHT_NO1 = 9;
    public static final int ROLE_SHARP_MOVE_RIGHT_NO2 = 10;
    public static final int ROLE_SHARP_MOVE_RIGHT_NO3 = 11;
    public static final int ROLE_SHARP_MOVE_RIGHT_NO4 = 12;
    public static final int FOOD_ATTRIBUTE_DELAY_TIME = 350;
    public static final int BOARD_ATTRIBUTE_LEFT_VELOCITY = -2;
    public static final int BOARD_ATTRIBUTE_RIGHT_VELOCITY = 2;
    public static final int BOARD_ATTRIBUTE_UNSTABLE_DELAY_FACTOR = 5;
    public static final int FOOTBOARD_TYPE_NORMAL = 0;
    public static final int FOOTBOARD_TYPE_UNSTABLE = 1;
    public static final int FOOTBOARD_TYPE_SPRING = 2;
    public static final int FOOTBOARD_TYPE_SPIKED = 3;
    public static final int FOOTBOARD_TYPE_MOVING_LEFT = 4;
    public static final int FOOTBOARD_TYPE_MOVING_RIGHT = 5;
    public static final int FOOD_NONE = 0;
    public static final int FOOD_8 = 4;
    public static final int FOOD_7 = 6;
    public static final int FOOD_6 = 8;
    public static final int FOOD_5 = 10;
    public static final int FOOD_4 = 12;
    public static final int FOOD_3 = 14;
    public static final int FOOD_2 = 16;
    public static final int FOOD_1 = 20;
    private ScreenAttribute mScreenAttribute;
    public int mGameStatus = 1;
    private int mScore = 0;
    public int mLevel = 1;
    private int mHP = 12;
    private int mLevelUpCounter = 0;
    private Random mRan = new Random();
    private int mEffectFlag = 0;
    private Role mRole;
    private int mRoleVelocityX;
    private int mRoleVelocityY;
    private int mAddVelocity;
    private int mFootboardSpaceFactor = this.nextfootgenratY * 5;
    private int mFootboardSpaceCounter = 0;
    private int mFootboartVelocity = -this.incresespeed * 5;
    private Vector mFootboardList;
    private Food mCurFood;
    public static boolean jumpflage;
    boolean leftFlag = false;
    boolean rightFlag = false;
    boolean keyRepeatFlag = false;
    int angelNum = 0;

    public UIModel(ScreenAttribute screenAttribute, int addVelocity) {
        this.mScreenAttribute = screenAttribute;
        this.mAddVelocity = addVelocity;
        this.mRole = new Role((screenAttribute.maxX - 19) / 2, screenAttribute.maxY * 3 / 4, 19, 32, 2);
        this.mRoleVelocityY = 25;
        this.mFootboardList = new Vector();
        this.mFootboardList.addElement(new Footboard((screenAttribute.maxX - 67) / 2, screenAttribute.maxY, 67, 12, 0, 2, 1));
        this.mCurFood = new Food(0, 0, 0, 0, 24);
    }

    public void updateUIModel() {
        for (int j = 0; j < this.mFootboardList.size(); ++j) {
            Footboard footboard = (Footboard)this.mFootboardList.elementAt(j);
            footboard.addY(this.mFootboartVelocity);
        }
        this.mRole.addX(this.mRoleVelocityX);
        this.mRole.addY(this.mRoleVelocityY);
        if (!this.keyRepeatFlag) {
            if (this.leftFlag) {
                --this.angelNum;
                this.handleMoving(this.angelNum);
            } else if (this.rightFlag) {
                ++this.angelNum;
                this.handleMoving(this.angelNum);
            }
        }
        this.handleBorder();
        this.handleRoleAction();
        this.handleFood();
        this.mFootboardSpaceCounter -= this.mFootboartVelocity;
        if (this.mFootboardSpaceCounter >= this.mFootboardSpaceFactor) {
            this.mFootboardSpaceCounter -= this.mFootboardSpaceFactor;
            this.generateFootboard();
            this.generateFood();
            ++this.mLevelUpCounter;
            if (this.mLevelUpCounter == 40) {
                this.mLevelUpCounter = 0;
                this.increaseLevel();
            }
        }
    }

    private void generateFootboard() {
        int frameAmount = 1;
        int frameDelay = 1;
        int frameType = 0;
        switch (this.mRan.nextInt(20)) {
            case 0: 
            case 1: 
            case 2: {
                frameType = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                frameType = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                frameType = 3;
                break;
            }
            case 9: 
            case 10: {
                frameType = 4;
                frameAmount = 2;
                frameDelay = 15;
                break;
            }
            case 11: 
            case 12: {
                frameType = 5;
                frameAmount = 2;
                frameDelay = 15;
                break;
            }
            default: {
                frameType = 0;
            }
        }
        this.mFootboardList.addElement(new Footboard(this.mRan.nextInt(this.mScreenAttribute.maxX - 67), this.mScreenAttribute.maxY + 32, 67, 12, frameType, frameAmount, frameDelay));
    }

    private void generateFood() {
        if (this.mCurFood.mTimeCounter > 0) {
            return;
        }
        switch (this.mRan.nextInt(25)) {
            case 0: {
                this.mCurFood.mFoodReward = 20;
                break;
            }
            case 1: {
                this.mCurFood.mFoodReward = 16;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.mCurFood.mFoodReward = 14;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.mCurFood.mFoodReward = 14;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                this.mCurFood.mFoodReward = 12;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.mCurFood.mFoodReward = 12;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.mCurFood.mFoodReward = 10;
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.mCurFood.mFoodReward = 8;
                break;
            }
            default: {
                this.mCurFood.mFoodReward = 0;
                return;
            }
        }
        this.mCurFood.mMinX = this.mRan.nextInt(this.mScreenAttribute.maxX - 24);
        this.mCurFood.mMinY = this.foodIncY + this.mRan.nextInt(this.mScreenAttribute.maxY - 24);
        this.mCurFood.mMaxX = this.mCurFood.mMinX + 24;
        this.mCurFood.mMaxY = this.mCurFood.mMinY + 24;
        this.mCurFood.mTimeCounter = 350;
    }

    public void handleMoving(float angleValue) {
        if (angleValue < -5.0f) {
            this.mRoleVelocityX = 10 + this.mAddVelocity;
        } else if (angleValue >= -5.0f && angleValue < -4.0f) {
            this.mRoleVelocityX = 8 + this.mAddVelocity;
        } else if (angleValue >= -4.0f && angleValue < -3.0f) {
            this.mRoleVelocityX = 6 + this.mAddVelocity;
        } else if (angleValue >= -3.0f && angleValue < -2.0f) {
            this.mRoleVelocityX = 5 + this.mAddVelocity;
        } else if (angleValue >= -2.0f && (double)angleValue < -1.5) {
            this.mRoleVelocityX = 4 + this.mAddVelocity;
        } else if ((double)angleValue >= -1.5 && (double)angleValue < 1.5) {
            this.mRoleVelocityX = 0;
            this.leftFlag = false;
            this.rightFlag = false;
        } else if ((double)angleValue >= 1.5 && angleValue < 2.0f) {
            this.mRoleVelocityX = -4 - this.mAddVelocity;
        } else if (angleValue >= 2.0f && angleValue < 3.0f) {
            this.mRoleVelocityX = -5 - this.mAddVelocity;
        } else if (angleValue >= 3.0f && angleValue < 4.0f) {
            this.mRoleVelocityX = -6 - this.mAddVelocity;
        } else if (angleValue >= 4.0f && angleValue < 5.0f) {
            this.mRoleVelocityX = -8 - this.mAddVelocity;
        } else if (angleValue > 5.0f) {
            this.mRoleVelocityX = -10 - this.mAddVelocity;
        }
    }

    private void increaseLevel() {
        ++this.mLevel;
        if (this.mLevel < 18 || this.mLevel % 20 == 0) {
            this.mFootboartVelocity -= 2;
            int roleStatus = this.mRole.getRoleStatus();
            if (roleStatus == 0 || roleStatus == 2 || roleStatus == 1) {
                this.mRoleVelocityY = this.mFootboartVelocity;
            }
        }
    }

    private void handleBorder() {
        if (this.mFootboardList.size() > 0 && ((Footboard)this.mFootboardList.firstElement()).getMaxY() <= this.mScreenAttribute.minY + 27) {
            this.mFootboardList.removeElementAt(0);
        }
        if (this.mRole.getMinY() <= this.mScreenAttribute.minY + this.playerMINY) {
            this.mHP -= 3;
            if (this.mHP <= 0) {
                this.mGameStatus = 2;
            } else if (this.mRole.getRoleStatus() == 0 || this.mRole.getRoleStatus() == 1 || this.mRole.getRoleStatus() == 2) {
                this.mRole.addY(60);
            }
            this.mRoleVelocityY = 25;
            this.mEffectFlag = 4;
            return;
        }
        if (this.mRole.getMinY() > this.mScreenAttribute.maxY) {
            this.mGameStatus = 2;
            return;
        }
        if (this.mRole.getMinX() < this.mScreenAttribute.minX) {
            this.mRoleVelocityX = 0;
            this.mRole.setX(0);
            return;
        }
        if (this.mRole.getMaxX() > this.mScreenAttribute.maxX) {
            this.mRoleVelocityX = 0;
            this.mRole.setX(this.mScreenAttribute.maxX - 19);
            return;
        }
    }

    private void handleRoleAction() {
        Role role = this.mRole;
        for (int j = 0; j < this.mFootboardList.size(); ++j) {
            Footboard footboard = (Footboard)this.mFootboardList.elementAt(j);
            if (role.getMaxY() < footboard.getMinY() || role.getMaxY() >= footboard.getMaxY() || role.getMaxX() <= footboard.getMinX() || role.getMinX() >= footboard.getMaxX()) continue;
            if (role.getRoleStatus() == 0 || role.getRoleStatus() == 2 || role.getRoleStatus() == 1) {
                if (footboard.getType() == 2) {
                    jumpflage = true;
                    this.mRoleVelocityY = this.mFootboartVelocity - 25;
                    role.addY(-5);
                    this.updateRoleStatus(3);
                    return;
                }
                if (footboard.getType() == 4) {
                    role.addX(-2);
                } else if (footboard.getType() == 5) {
                    role.addX(2);
                } else if (footboard.getType() == 1 && footboard.isBoardBreak()) {
                    this.mFootboardList.removeElement(footboard);
                }
                this.updateRoleStatus(0);
            } else {
                this.mScore += this.mLevel;
                this.mRoleVelocityY = this.mFootboartVelocity;
                role.setVirtualY(footboard.getVirtualY() - 160);
                if (footboard.getType() == 3) {
                    this.mHP -= 3;
                } else if (this.mHP < 12) {
                    ++this.mHP;
                }
                if (this.mHP <= 0) {
                    this.mGameStatus = 2;
                }
                this.updateRoleStatus(0);
                switch (footboard.getType()) {
                    case 1: {
                        this.mEffectFlag = 2;
                        break;
                    }
                    case 2: {
                        this.mEffectFlag = 3;
                        break;
                    }
                    case 3: {
                        this.mEffectFlag = 4;
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.mEffectFlag = 5;
                        break;
                    }
                    default: {
                        this.mEffectFlag = 1;
                    }
                }
            }
            return;
        }
        this.mRoleVelocityY = this.mRoleVelocityY < this.mFootboartVelocity ? (this.mRoleVelocityY += 3) : 25;
        this.updateRoleStatus(3);
    }

    private void handleFood() {
        Food food = this.mCurFood;
        --food.mTimeCounter;
        if (food.mFoodReward != 0 && food.mTimeCounter > 0 && this.mRole.getMaxX() > food.mMinX && this.mRole.getMinX() < food.mMaxX && (this.mRole.getMaxY() >= food.mMinY && this.mRole.getMaxY() < food.mMaxY || this.mRole.getMinY() > food.mMinY && this.mRole.getMinY() <= food.mMaxY)) {
            this.mEffectFlag = 6;
            this.mScore += food.mFoodReward;
            food.mFoodReward = 0;
        }
    }

    private void updateRoleStatus(int status) {
        if (status == 3) {
            if (this.mRoleVelocityX > 0) {
                this.mRole.setRoleStatus(5);
            } else if (this.mRoleVelocityX < 0) {
                this.mRole.setRoleStatus(4);
            } else {
                this.mRole.setRoleStatus(3);
            }
        } else if (this.mRoleVelocityX > 0) {
            this.mRole.setRoleStatus(2);
        } else if (this.mRoleVelocityX < 0) {
            this.mRole.setRoleStatus(1);
        } else {
            this.mRole.setRoleStatus(0);
        }
    }

    public void destroy() {
        this.mScreenAttribute = null;
        this.mRole = null;
        this.mRan = null;
        this.mFootboardList.removeAllElements();
        this.mFootboardList = null;
    }

    public Role getRoleUIObject() {
        return this.mRole;
    }

    public Vector getFootboardUIObjects() {
        return this.mFootboardList;
    }

    public Food getFood() {
        return this.mCurFood;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEffectFlag() {
        try {
            int n = this.mEffectFlag;
            return n;
        }
        finally {
            this.mEffectFlag = 0;
        }
    }

    public String getLevel() {
        return "" + this.mLevel;
    }

    public String getScoreStr() {
        return "" + this.mScore;
    }

    public int getScore() {
        return this.mScore;
    }

    public float getHp() {
        return this.mHP;
    }
}

