/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

class Texts {
    public StringBuffer stringBuffer = new StringBuffer();
    public final String STRING_BIN;
    final Hashtable hashedStrings = new Hashtable();

    Texts() {
        this.STRING_BIN = "/g.csr";
    }

    String fromUTF8(byte[] ao) {
        int nLength = ao.length;
        char[] ach = new char[nLength];
        int nCount = 0;
        for (int i = 0; i < nLength; ++i) {
            int nCharCode = ao[i] & 0xFF;
            if (nCharCode >= 128) {
                if (nCharCode < 224) {
                    nCharCode = (nCharCode & 0x1F) << 6;
                    nCharCode |= ao[++i] & 0x3F;
                } else {
                    nCharCode = (nCharCode & 0xF) << 12;
                    nCharCode |= (ao[++i] & 0x3F) << 6;
                    if ((nCharCode |= ao[++i] & 0x3F) == 65279) continue;
                }
            }
            ach[nCount++] = (char)nCharCode;
        }
        return new String(ach, 0, nCount);
    }

    final boolean loadTextResource(String resName) {
        MainCanvas.trace("loadTextResource() - in");
        boolean loaded = false;
        this.stringBuffer.setLength(0);
        try {
            InputStream is = this.getClass().getResourceAsStream(resName);
            InputStreamReader isr = new InputStreamReader(is);
            int ch = isr.read();
            while (ch != -1) {
                this.stringBuffer.append((char)ch);
                ch = isr.read();
            }
            is = null;
            isr = null;
            loaded = true;
            System.gc();
        }
        catch (Throwable t) {
            MainCanvas.trace("loadTextResource exception : " + t.toString());
        }
        String tmpString = this.fromUTF8(this.stringBuffer.toString().getBytes());
        this.stringBuffer.setLength(0);
        this.stringBuffer.append(tmpString);
        tmpString = null;
        System.gc();
        MainCanvas.trace("loadTextResource() - out");
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String getString(String id) {
        InputStream is = null;
        DataInputStream dis = null;
        try {
            is = this.getClass().getResourceAsStream("/g.csr");
            dis = new DataInputStream(is);
            for (int i = dis.readInt(); i > 0; --i) {
                String key = dis.readUTF();
                String value = dis.readUTF();
                if (!key.equals(id)) continue;
                String string = value.trim();
                return string;
            }
        }
        catch (Throwable t) {
            MainCanvas.trace("ERROR executing getString: " + t.toString());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable t) {}
            }
        }
        MainCanvas.trace("WARNING getString(" + id + ") returns null!");
        return null;
    }

    final String getHashedString(String id) {
        if (this.hashedStrings.containsKey(id)) {
            return (String)this.hashedStrings.get(id);
        }
        String value = this.getString(id);
        this.hashedStrings.put(id, value);
        return value;
    }
}

