/*
 * Decompiled with CFR 0.152.
 */
package SnS;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GameScore {
    static int MAX_LEVEL = 25;
    static int MAX_FBSCORE = 11;
    public static short[] highScore = new short[MAX_LEVEL];
    public static int[] TopFive = new int[MAX_LEVEL];
    public static boolean[] level_flag = new boolean[MAX_LEVEL];
    public static String[] highScoreName = new String[MAX_FBSCORE];
    public static RecordStore myStore;
    public static RecordStore rs;
    public static RecordStore Tscore;
    public static boolean highScoresHaveBeenInit;
    public static boolean LevellockHaveBeenInit;
    public static boolean TopFiveinit;
    static final String REC_STORE = "ReadWriteRMS";

    public GameScore() {
        GameScore.openHighScores();
        GameScore.openLevelLock();
        GameScore.openTopFiveScores();
    }

    public static void initializeLock() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b;
            try {
                dos.writeBoolean(false);
                b = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            for (int i = 0; i < MAX_LEVEL; ++i) {
                rs.addRecord(b, 0, b.length);
            }
        }
        catch (RecordStoreException rse) {
            GameScore.closeHighScores();
        }
    }

    static void openLevelLock() {
        try {
            rs = RecordStore.openRecordStore((String)"Levellock", (boolean)true);
            if (LevellockHaveBeenInit) {
                return;
            }
            if (rs.getNumRecords() == 0) {
                GameScore.initializeLock();
            } else {
                for (int i = 0; i < MAX_LEVEL; ++i) {
                    byte[] data = rs.getRecord(i + 1);
                    if (data == null) continue;
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        DataInputStream dis = new DataInputStream(bais);
                        GameScore.level_flag[i] = dis.readBoolean();
                        dis.close();
                        continue;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            LevellockHaveBeenInit = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public static void initializeTopFiveScores() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b;
            try {
                dos.writeInt(0);
                dos.writeUTF("");
                b = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            for (int i = 0; i < MAX_FBSCORE; ++i) {
                Tscore.addRecord(b, 0, b.length);
            }
        }
        catch (RecordStoreException rse) {
            GameScore.closeHighScores();
        }
    }

    public static void initializeScores() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b;
            try {
                dos.writeShort(0);
                dos.writeUTF("");
                b = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            for (int i = 0; i < MAX_LEVEL; ++i) {
                myStore.addRecord(b, 0, b.length);
            }
        }
        catch (RecordStoreException rse) {
            GameScore.closeHighScores();
        }
    }

    static void openHighScores() {
        try {
            myStore = RecordStore.openRecordStore((String)"HighScores", (boolean)true);
            if (highScoresHaveBeenInit) {
                return;
            }
            if (myStore.getNumRecords() == 0) {
                GameScore.initializeScores();
            } else {
                for (int i = 0; i < MAX_LEVEL; ++i) {
                    byte[] data = myStore.getRecord(i + 1);
                    if (data == null) continue;
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        DataInputStream dis = new DataInputStream(bais);
                        GameScore.highScore[i] = dis.readShort();
                        dis.close();
                        continue;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            highScoresHaveBeenInit = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static void openTopFiveScores() {
        try {
            Tscore = RecordStore.openRecordStore((String)"TopFiveScore", (boolean)true);
            if (TopFiveinit) {
                return;
            }
            if (Tscore.getNumRecords() == 0) {
                GameScore.initializeTopFiveScores();
            } else {
                for (int i = 0; i < MAX_FBSCORE; ++i) {
                    byte[] data = Tscore.getRecord(i + 1);
                    if (data == null) continue;
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        DataInputStream dis = new DataInputStream(bais);
                        GameScore.TopFive[i] = dis.readInt();
                        GameScore.highScoreName[i] = dis.readUTF();
                        dis.close();
                        continue;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            TopFiveinit = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static void closeHighScores() {
        if (myStore != null) {
            try {
                myStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            myStore = null;
        }
    }

    static void closeTopFiveScore() {
        if (Tscore != null) {
            try {
                Tscore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            Tscore = null;
        }
    }

    static void closeLevellock() {
        if (rs != null) {
            try {
                rs.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            rs = null;
        }
    }

    public void setlevelLock(int level, boolean lvl_lock) {
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeBoolean(lvl_lock);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            rs.setRecord(level + 1, data, 0, data.length);
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        GameScore.level_flag[level] = lvl_lock;
    }

    public void setTopFiveScore(int count, int newScore, String name) {
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeInt(newScore);
                das.writeUTF(name);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            Tscore.setRecord(count + 1, data, 0, data.length);
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        GameScore.TopFive[count] = newScore;
        GameScore.highScoreName[count] = name;
    }

    public void setHighScore(int level, int newScore, String name) {
        if (newScore <= highScore[level]) {
            return;
        }
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeShort((short)newScore);
                das.writeUTF(name);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            myStore.setRecord(level + 1, data, 0, data.length);
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        GameScore.highScore[level] = (short)newScore;
    }

    public boolean getLevelLock(int Level2) {
        if (!LevellockHaveBeenInit) {
            GameScore.openLevelLock();
            GameScore.closeLevellock();
        }
        return level_flag[Level2];
    }

    public short getHighScore(int level) {
        if (!highScoresHaveBeenInit) {
            GameScore.openHighScores();
            GameScore.closeHighScores();
        }
        return highScore[level];
    }

    public int getTopFiveScore(int count) {
        if (!TopFiveinit) {
            GameScore.openTopFiveScores();
            GameScore.closeTopFiveScore();
        }
        return TopFive[count];
    }

    public static String getHighScoreName(int count) {
        if (!TopFiveinit) {
            GameScore.openTopFiveScores();
            GameScore.closeTopFiveScore();
        }
        return highScoreName[count];
    }
}

