/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Button;
import game.DisplayableCanvas;
import game.DrawString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class MainMenu {
    DrawString ds;
    DisplayableCanvas dc;
    int MENU_MODE;
    final byte SPLASH;
    final byte MAIN_MENU;
    final byte OPTIONS = (byte)2;
    final byte HELP = (byte)3;
    final byte ABOUT = (byte)4;
    final byte RESETGAME = (byte)5;
    final byte GAME_TYPE = (byte)5;
    int WIDTH;
    int HEIGHT;
    Image imgLogo;
    Image imgSplash;
    Image imgAboutLogo;
    Image imgReset;
    Font font = Font.getFont((int)0, (int)1, (int)16);
    boolean isContinue;
    boolean onoffs = true;
    boolean onoffv = true;
    Button butContinue;
    Button butNewGame;
    Button butOption;
    Button butHelp;
    Button butAbout;
    Button butExit;
    Button butSoundon;
    Button butSoundoff;
    Button butVibrateon;
    Button butVibrateoff;
    Button butResetGame;
    Button buttonHome;
    Image optionTop;
    Image helpTop;
    Image aboutTop;
    Image gameLogo;
    Image aboutLogo;
    Image optionLogo;
    Image imgHelpText;
    Image imgUpArrow;
    Image imgDownArrow;
    int selectIndex = 1;
    byte optionIndex = 0;
    RecordStore soundSettings;

    public MainMenu(DisplayableCanvas dc, DrawString ds) {
        this.SPLASH = 0;
        this.MAIN_MENU = 1;
        this.dc = dc;
        this.ds = ds;
        this.WIDTH = dc.WIDTH;
        this.HEIGHT = dc.HEIGHT;
    }

    public void resetSplash() {
        try {
            this.imgLogo = Image.createImage((String)"/res/menu/logo.png");
            this.imgSplash = Image.createImage((String)"/res/menu/menuBg.jpg");
            this.gameLogo = Image.createImage((String)"/res/menu/gamelogo.png");
            this.imgAboutLogo = Image.createImage((String)"/res/menu/aboutLogo.png");
            this.imgReset = Image.createImage((String)"/res/menu/reset.png");
            this.dc.imgTouchBox = Image.createImage((String)"/res/game/box.png");
            this.dc.buttonOK = new Button(120, 170, "/res/game/right0.png", "/res/game/right1.png");
            this.dc.buttonCancel = new Button(240, 170, "/res/game/wrong0.png", "/res/game/wrong1.png");
        }
        catch (Exception io) {
            io.printStackTrace();
        }
        this.readSettings();
        this.MENU_MODE = 0;
    }

    public void resetMainMenu() {
        if (this.imgSplash == null) {
            try {
                this.imgSplash = Image.createImage((String)"/res/menu/menuBg.jpg");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            this.optionTop = Image.createImage((String)"/res/menu/optiontop.png");
            this.helpTop = Image.createImage((String)"/res/menu/helptop.png");
            this.aboutTop = Image.createImage((String)"/res/menu/abouttop.png");
            this.gameLogo = Image.createImage((String)"/res/menu/menulogo.png");
            this.optionLogo = Image.createImage((String)"/res/menu/menulogo2.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.butContinue == null) {
            this.butContinue = new Button(0, 0, "/res/menu/continue0.png", "/res/menu/continue1.png");
            this.butNewGame = new Button(0, 0, "/res/menu/play0.png", "/res/menu/play1.png");
            this.butOption = new Button(0, 0, "/res/menu/option0.png", "/res/menu/option1.png");
            this.butHelp = new Button(0, 0, "/res/menu/help0.png", "/res/menu/help1.png");
            this.butAbout = new Button(0, 0, "/res/menu/about0.png", "/res/menu/about1.png");
            this.butExit = new Button(0, 0, "/res/menu/exit0.png", "/res/menu/exit1.png");
            this.butSoundon = new Button(62, 110, "/res/menu/soundon0.png", "/res/menu/soundon1.png");
            this.butSoundoff = new Button(58, 110, "/res/menu/soundoff0.png", "/res/menu/soundoff1.png");
            this.butVibrateon = new Button(46, 145, "/res/menu/vibrateon0.png", "/res/menu/vibrateon1.png");
            this.butVibrateoff = new Button(42, 145, "/res/menu/vibrateoff0.png", "/res/menu/vibrateoff1.png");
            this.butResetGame = new Button(52, 180, "/res/menu/resetgame0.png", "/res/menu/resetgame1.png");
            this.buttonHome = new Button(2, 2, "/res/menu/homeIcon0.png", "/res/menu/homeIcon1.png");
        }
        if (this.isContinue) {
            this.butContinue.setXY(120 - (this.butContinue.width >> 1), 10);
            this.butNewGame.setXY(120 - (this.butNewGame.width >> 1), this.butContinue.y + 40);
            this.butOption.setXY(120 - (this.butOption.width >> 1), this.butNewGame.y + 40);
            this.butHelp.setXY(120 - (this.butHelp.width >> 1), this.butOption.y + 40);
            this.butAbout.setXY(120 - (this.butAbout.width >> 1), this.butHelp.y + 40);
            this.butExit.setXY(120 - (this.butExit.width >> 1), this.butAbout.y + 40);
        } else {
            this.butNewGame.setXY(120 - (this.butNewGame.width >> 1), 55);
            this.butOption.setXY(120 - (this.butOption.width >> 1), this.butNewGame.y + 40);
            this.butHelp.setXY(120 - (this.butHelp.width >> 1), this.butOption.y + 40);
            this.butAbout.setXY(120 - (this.butAbout.width >> 1), this.butHelp.y + 40);
            this.butExit.setXY(120 - (this.butExit.width >> 1), this.butAbout.y + 40);
        }
        this.MENU_MODE = 1;
    }

    public void resetOptions() {
        try {
            this.optionLogo = Image.createImage((String)"/res/menu/menulogo2.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetHelp() {
        try {
            if (this.imgHelpText == null) {
                try {
                    this.imgHelpText = this.dc.hasPointerEvents() ? Image.createImage((String)"/res/menu/helpText.png") : Image.createImage((String)"/res/menu/helpText1.png");
                    this.imgUpArrow = Image.createImage((String)"/res/menu/upArrow.png");
                    this.imgDownArrow = Image.createImage((String)"/res/menu/downArrow.png");
                }
                catch (Exception e) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetAbout() {
        try {
            this.aboutLogo = Image.createImage((String)"/res/menu/menulogo1.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetMode(int gameMode) {
        switch (gameMode) {
            case 0: 
            case 5: {
                this.resetSplash();
                break;
            }
            case 1: {
                if (this.imgSplash == null) {
                    try {
                        this.imgSplash = Image.createImage((String)"/res/menu/menuBg.jpg");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.resetMainMenu();
                break;
            }
            case 2: {
                this.resetOptions();
                break;
            }
            case 3: {
                this.resetHelp();
                break;
            }
            case 4: {
                this.resetAbout();
            }
        }
        this.MENU_MODE = gameMode;
        this.dc.resetAdSetXY();
    }

    protected void pointerPressed(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isContinue && (result = this.butContinue.isPressed(x, y))) {
                    this.selectIndex = 0;
                }
                if (result) break;
                result = this.butNewGame.isPressed(x, y);
                if (!result) {
                    result = this.butOption.isPressed(x, y);
                    if (!result) {
                        result = this.butHelp.isPressed(x, y);
                        if (!result) {
                            result = this.butAbout.isPressed(x, y);
                            if (!result) {
                                result = this.butExit.isPressed(x, y);
                                if (!result) break;
                                this.selectIndex = 5;
                                break;
                            }
                            this.selectIndex = 4;
                            break;
                        }
                        this.selectIndex = 3;
                        break;
                    }
                    this.selectIndex = 2;
                    break;
                }
                this.selectIndex = 1;
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                } else {
                    result = this.butSoundoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                } else {
                    result = this.butVibrateoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                }
                if (result || (result = this.buttonHome.isPressed(x, y))) break;
                result = this.butResetGame.isPressed(x, y);
                break;
            }
            case 3: {
                if (result) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 4: {
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 5: {
                result = this.dc.buttonOK.isPressed(x, y);
                if (result) break;
                result = this.dc.buttonCancel.isPressed(x, y);
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                result = this.butExit.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                if (this.isContinue && (result = this.butContinue.isReleased(x, y))) {
                    this.selection();
                }
                if (result) break;
                result = this.butNewGame.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butOption.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butHelp.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butAbout.isReleased(x, y);
                if (!result) break;
                this.selection();
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isReleased(x, y);
                    if (result) {
                        this.onoffs = false;
                    }
                } else {
                    result = this.butSoundoff.isReleased(x, y);
                    if (result) {
                        this.onoffs = true;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isReleased(x, y);
                    if (result) {
                        this.onoffv = false;
                    }
                } else {
                    result = this.butVibrateoff.isReleased(x, y);
                    if (result) {
                        this.onoffv = true;
                    }
                }
                if (!result) {
                    result = this.buttonHome.isReleased(x, y);
                    if (result) {
                        this.resetMainMenu();
                    }
                    if (!result && (result = this.butResetGame.isReleased(x, y))) {
                        this.MENU_MODE = 5;
                    }
                }
                this.optionIndex = (byte)-1;
                break;
            }
            case 3: {
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
                break;
            }
            case 4: {
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
                break;
            }
            case 5: {
                result = this.dc.buttonOK.isReleased(x, y);
                if (result) {
                    for (int i = 0; i < this.dc.lilstarCount.length; ++i) {
                        this.dc.lilstarCount[i] = 0;
                    }
                    this.MENU_MODE = 2;
                }
                if (result || !(result = this.dc.buttonCancel.isReleased(x, y))) break;
                this.MENU_MODE = 2;
            }
        }
    }

    public void storeSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"TennisSettings", (boolean)true);
            byte[] Byte = null;
            ByteArrayOutputStream bout = new ByteArrayOutputStream(60);
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeBoolean(this.onoffs);
            dout.writeBoolean(this.onoffv);
            dout.write(this.dc.lilstarCount);
            System.out.println("dout" + this.dc.lilstarCount[0]);
            dout.flush();
            dout.close();
            Byte = bout.toByteArray();
            dout.close();
            if (this.soundSettings.getNumRecords() > 0) {
                this.soundSettings.setRecord(1, Byte, 0, Byte.length);
            } else {
                this.soundSettings.addRecord(Byte, 0, Byte.length);
            }
            this.soundSettings.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"TennisSettings", (boolean)true);
            if (this.soundSettings.getNumRecords() > 0) {
                byte[] Byte = null;
                Byte = this.soundSettings.getRecord(1);
                DataInputStream din = new DataInputStream(new ByteArrayInputStream(Byte));
                this.onoffs = din.readBoolean();
                this.onoffv = din.readBoolean();
                din.read(this.dc.lilstarCount);
                System.out.println("din" + this.dc.lilstarCount[0]);
                din.close();
            } else {
                byte[] Byte = null;
                ByteArrayOutputStream bout = new ByteArrayOutputStream(60);
                DataOutputStream dout = new DataOutputStream(bout);
                this.onoffs = true;
                this.onoffv = true;
                dout.writeBoolean(this.onoffs);
                dout.writeBoolean(this.onoffv);
                dout.flush();
                dout.close();
                Byte = bout.toByteArray();
                dout.close();
                this.soundSettings.addRecord(Byte, 0, Byte.length);
            }
            this.soundSettings.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selection() {
        switch (this.selectIndex) {
            case 0: {
                this.dc.continueGame();
                this.dc.getClass();
                this.dc.GAME_MODE = 5;
                break;
            }
            case 1: {
                this.dc.initGame();
                break;
            }
            case 2: {
                this.resetMode(2);
                break;
            }
            case 3: {
                this.resetMode(3);
                break;
            }
            case 4: {
                this.resetMode(4);
                break;
            }
            case 5: {
                this.dc.midlet.exit();
                break;
            }
            case 6: {
                if (this.dc.imgAd == null) break;
                this.dc.onClickBannerAd();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void input(int KEY) {
        block39: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block38: {
                                block37: {
                                    if (KEY == this.dc.KEY_LEFT_SOFT) break block37;
                                    if (KEY != 42) break block38;
                                }
                                if (this.MENU_MODE == 5) {
                                    for (int i = 0; i < this.dc.lilstarCount.length; ++i) {
                                        this.dc.lilstarCount[i] = 0;
                                    }
                                    this.MENU_MODE = 2;
                                }
                                this.dc.KEY = 0;
                                break block39;
                            }
                            if (KEY == this.dc.KEY_RIGHT_SOFT) break block40;
                            if (KEY != 35) break block41;
                        }
                        switch (this.MENU_MODE) {
                            case 2: 
                            case 3: 
                            case 4: {
                                this.resetMainMenu();
                                break;
                            }
                            case 5: {
                                this.MENU_MODE = 2;
                                break;
                            }
                        }
                        break block39;
                    }
                    if (KEY == 49) break block39;
                    if (KEY != 50) break block42;
                    switch (this.MENU_MODE) {
                        case 1: {
                            if (this.isContinue) {
                                this.selectIndex = (this.selectIndex + 5) % 6;
                                break;
                            }
                            --this.selectIndex;
                            if (this.selectIndex == 0) {
                                this.selectIndex = this.dc.imgAd != null ? 6 : 5;
                            }
                            if (this.dc.imgAd != null && this.selectIndex == 6) {
                                this.selectIndex = 6;
                            }
                            if (this.dc.imgAd != null || this.selectIndex != 5) break;
                            this.selectIndex = 5;
                            break;
                        }
                        case 2: {
                            if (this.optionIndex == 0) {
                                if (this.dc.imgAd != null) {
                                    this.optionIndex = (byte)3;
                                    break;
                                }
                                this.optionIndex = (byte)2;
                                break;
                            }
                            if (this.optionIndex == 1) {
                                this.optionIndex = 0;
                                break;
                            }
                            if (this.optionIndex == 2) {
                                this.optionIndex = 1;
                                break;
                            }
                            if (this.optionIndex != 3) break;
                            this.optionIndex = (byte)2;
                            break;
                        }
                    }
                    this.dc.KEY = 0;
                    break block39;
                }
                if (KEY != 56) break block43;
                switch (this.MENU_MODE) {
                    case 1: {
                        if (this.isContinue) {
                            this.selectIndex = (this.selectIndex + 1) % 6;
                            break;
                        }
                        ++this.selectIndex;
                        if (this.selectIndex == (this.dc.imgAd != null ? 7 : 6)) {
                            this.selectIndex = 1;
                            break;
                        }
                        break block39;
                    }
                    case 2: {
                        if (this.optionIndex == 0) {
                            this.optionIndex = 1;
                            break;
                        }
                        if (this.optionIndex == 1) {
                            this.optionIndex = (byte)2;
                            break;
                        }
                        if (this.optionIndex == 2) {
                            if (this.dc.imgAd != null) {
                                this.optionIndex = (byte)3;
                                break;
                            }
                            this.optionIndex = 0;
                            break;
                        }
                        if (this.optionIndex == 3) {
                            this.optionIndex = 0;
                            break;
                        }
                        break block39;
                    }
                }
                break block39;
            }
            if (KEY == 53) {
                switch (this.MENU_MODE) {
                    case 1: {
                        this.selection();
                        break;
                    }
                    case 2: {
                        if (this.optionIndex == 0) {
                            this.onoffs = !this.onoffs;
                            break;
                        }
                        if (this.optionIndex == 1) {
                            this.onoffv = !this.onoffv;
                            break;
                        }
                        if (this.optionIndex == 2) {
                            this.MENU_MODE = 5;
                            break;
                        }
                        if (this.dc.buttonAd == null) break;
                        this.dc.onClickBannerAd();
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (this.dc.buttonAd == null) break;
                        this.dc.onClickBannerAd();
                        break;
                    }
                }
            }
        }
        this.dc.KEY = 0;
    }

    public void run() {
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter <= 60) break;
                this.imgLogo = null;
                this.imgSplash = null;
                this.resetMode(1);
                this.dc.refreshTheBannerAd();
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter < 40) {
                    g.setColor(0xFFFFFF);
                    g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                    g.drawImage(this.imgLogo, this.WIDTH >> 1, this.HEIGHT >> 1, 1 | 2);
                    break;
                }
                g.drawImage(this.gameLogo, this.WIDTH >> 1, this.HEIGHT >> 1, 1 | 2);
                break;
            }
            case 1: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.gameLogo, this.WIDTH >> 1, this.HEIGHT - this.gameLogo.getHeight() + 5, 1 | 0x10);
                if (this.isContinue) {
                    this.butContinue.paint(g);
                }
                this.butNewGame.paint(g);
                this.butOption.paint(g);
                this.butHelp.paint(g);
                this.butAbout.paint(g);
                this.butExit.paint(g);
                switch (this.selectIndex) {
                    case 0: {
                        if (!this.isContinue || this.butContinue.buttonState != 0) break;
                        this.butContinue.buttonState = 1;
                        this.butContinue.paint(g);
                        this.butContinue.buttonState = 0;
                        break;
                    }
                    case 1: {
                        if (this.butNewGame.buttonState != 0) break;
                        this.butNewGame.buttonState = 1;
                        this.butNewGame.paint(g);
                        this.butNewGame.buttonState = 0;
                        break;
                    }
                    case 2: {
                        if (this.butOption.buttonState != 0) break;
                        this.butOption.buttonState = 1;
                        this.butOption.paint(g);
                        this.butOption.buttonState = 0;
                        break;
                    }
                    case 3: {
                        if (this.butHelp.buttonState != 0) break;
                        this.butHelp.buttonState = 1;
                        this.butHelp.paint(g);
                        this.butHelp.buttonState = 0;
                        break;
                    }
                    case 4: {
                        if (this.butAbout.buttonState != 0) break;
                        this.butAbout.buttonState = 1;
                        this.butAbout.paint(g);
                        this.butAbout.buttonState = 0;
                        break;
                    }
                    case 5: {
                        if (this.butExit.buttonState != 0) break;
                        this.butExit.buttonState = 1;
                        this.butExit.paint(g);
                        this.butExit.buttonState = 0;
                    }
                }
                break;
            }
            case 2: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.optionTop, 120 - (this.optionTop.getWidth() >> 1), 60, 20);
                g.drawImage(this.gameLogo, this.WIDTH >> 1, this.HEIGHT - this.gameLogo.getHeight() + 5, 1 | 0x10);
                this.butResetGame.paint(g);
                if (this.onoffs) {
                    this.butSoundon.paint(g);
                } else {
                    this.butSoundoff.paint(g);
                }
                if (this.onoffv) {
                    this.butVibrateon.paint(g);
                } else {
                    this.butVibrateoff.paint(g);
                }
                if (this.optionIndex == 0) {
                    if (this.onoffs) {
                        if (this.butSoundon.buttonState == 0) {
                            this.butSoundon.buttonState = 1;
                            this.butSoundon.paint(g);
                            this.butSoundon.buttonState = 0;
                        }
                    } else if (this.butSoundoff.buttonState == 0) {
                        this.butSoundoff.buttonState = 1;
                        this.butSoundoff.paint(g);
                        this.butSoundoff.buttonState = 0;
                    }
                } else if (this.optionIndex == 1) {
                    if (this.onoffv) {
                        if (this.butVibrateon.buttonState == 0) {
                            this.butVibrateon.buttonState = 1;
                            this.butVibrateon.paint(g);
                            this.butVibrateon.buttonState = 0;
                        }
                    } else if (this.butVibrateoff.buttonState == 0) {
                        this.butVibrateoff.buttonState = 1;
                        this.butVibrateoff.paint(g);
                        this.butVibrateoff.buttonState = 0;
                    }
                } else if (this.optionIndex == 2 && this.butResetGame.buttonState == 0) {
                    this.butResetGame.buttonState = 1;
                    this.butResetGame.paint(g);
                    this.butResetGame.buttonState = 0;
                }
                this.buttonHome.setXY(this.WIDTH - 60, this.HEIGHT - 25);
                this.buttonHome.paint(g);
                break;
            }
            case 3: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.helpTop, 120 - (this.helpTop.getWidth() >> 1), 60, 20);
                if (this.dc.hasPointerEvents()) {
                    g.drawImage(this.imgHelpText, this.WIDTH - this.imgHelpText.getWidth() >> 1, 90, 0x10 | 4);
                } else {
                    g.drawImage(this.imgHelpText, this.WIDTH - this.imgHelpText.getWidth() >> 1, 110, 0x10 | 4);
                }
                this.buttonHome.setXY(this.WIDTH - 60, this.HEIGHT - 25);
                this.buttonHome.paint(g);
                break;
            }
            case 5: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.dc.imgTouchBox, this.WIDTH - this.dc.imgTouchBox.getWidth() >> 1, this.HEIGHT - this.dc.imgTouchBox.getHeight() >> 1, 0x10 | 4);
                g.drawImage(this.imgReset, this.WIDTH - this.imgReset.getWidth() >> 1, this.HEIGHT - this.imgReset.getHeight() >> 1, 0x10 | 4);
                this.dc.buttonCancel.setXY(this.WIDTH - 48, this.HEIGHT - 25);
                this.dc.buttonCancel.paint(g);
                this.dc.buttonOK.setXY(-5, this.HEIGHT - 25);
                this.dc.buttonOK.paint(g);
                break;
            }
            case 4: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.aboutTop, this.WIDTH >> 1, 60, 1 | 0x10);
                g.drawImage(this.aboutLogo, this.WIDTH >> 1, 100, 1 | 0x10);
                if (this.imgAboutLogo != null) {
                    g.drawImage(this.imgAboutLogo, this.WIDTH >> 1, 170, 1 | 0x10);
                }
                this.buttonHome.setXY(this.WIDTH - 60, this.HEIGHT - 25);
                this.buttonHome.paint(g);
            }
        }
    }

    protected void pointerDragged(int x, int y) {
    }
}

