/*
 * Decompiled with CFR 0.152.
 */
package Screen.Tutorial;

import Object.Alien.Alien;
import Object.Alien.AlienAir;
import Object.Alien.AlienAngin;
import Object.Alien.AlienApi;
import Object.Alien.AlienTanah;
import Object.Pendukung.Coin;
import Object.Pendukung.ScoreAnimation;
import Object.Tebing.Tebing;
import Object.Tebing.TebingLangit;
import Screen.AlienJump;
import Screen.MainMenu;
import Screen.Stage.Stage;
import Screen.Tutorial.InstructionBox;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class StageTutorial
extends Stage {
    static final int TUTORIAL_1 = 0;
    static final int TUTORIAL_2 = 1;
    static final int TUTORIAL_3 = 2;
    static final int TUTORIAL_4 = 3;
    static final int TUTORIAL_5 = 4;
    static final int TUTORIAL_6 = 5;
    int state = 0;
    Sprite spTouch;
    Sprite spBenar;
    Sprite btnOk;
    private InstructionBox textInstruction = new InstructionBox(0);
    private final Alien[] line;
    TebingLangit[] tebing;
    private boolean nextTutorial;
    private int tempState;

    public StageTutorial() {
        this.textInstruction.setTextImage("/Tutorial/tutorial-1.png");
        this.player = new Alien[1];
        this.line = new Alien[1];
        this.gameOver = false;
        Stage.start = false;
        this.init_hero();
        Stage.tebing = this.tebing;
        this.player[0] = this.hero;
        this.line[0] = this.hero;
        try {
            this.spTouch = new Sprite(Image.createImage((String)"/Tutorial/kursor_diam.png"), 100, 100);
            this.spTouch.setFrameSequence(new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2});
            this.spBenar = new Sprite(Image.createImage((String)"/Tutorial/contreng.png"), 160, 160);
            this.spBenar.setFrameSequence(new int[]{0, 1, 2, 3, 4, 4, 4, 4, 4, 4, 4});
            this.spBenar.setPosition(50, 100);
            this.spBenar.setFrame(0);
            this.spBenar.setVisible(false);
            this.btnOk = new Sprite(Image.createImage((String)"/Tutorial/ok.png"), 100, 42);
            this.btnOk.setFrameSequence(new int[]{1, 2});
            this.btnOk.setFrame(0);
            this.background = Image.createImage((String)"/Game/background_game/stage6/background.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initTutorial1();
        dasarY = 340;
        dasarX = 0;
    }

    public void draw(Graphics g) {
        try {
            g.drawImage(this.background, 0, 0, 20);
            if (!this.pause) {
                int i;
                if (this.state == 2) {
                    for (i = 0; i < coin.length; ++i) {
                        coin[i].draw(g);
                    }
                }
                for (i = 0; i < this.tebing.length; ++i) {
                    this.tebing[i].draw(g);
                }
                this.hero.draw(g);
                this.sam.draw(g);
                for (i = 0; i < this.line.length; ++i) {
                    if (this.line[i].finish) continue;
                    for (int j = 0; j < this.line.length; ++j) {
                        if (this.line[i].posY >= this.line[j].posY || this.line[j].finish) continue;
                        Alien temp = this.line[i];
                        this.line[i] = this.line[j];
                        this.line[j] = temp;
                    }
                }
                this.cetakScore(g, "" + (scoreHero + this.scoreStage));
                int xJuara = 17;
                int yJuara = -2;
                if (this.line[0] == this.hero) {
                    g.drawImage(this.first, xJuara, yJuara, 20);
                } else if (this.line[1] == this.hero) {
                    g.drawImage(this.second, xJuara, yJuara, 20);
                } else if (this.line[2] == this.hero) {
                    g.drawImage(this.third, xJuara, yJuara, 20);
                } else {
                    g.drawImage(this.fourth, xJuara, yJuara, 20);
                }
                for (int i2 = 0; i2 < this.player.length; ++i2) {
                    this.kolisiAlien(g, this.player[i2]);
                }
                this.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.spBenar.paint(g);
        switch (this.state) {
            case 0: {
                this.textInstruction.draw(g);
                this.spTouch.paint(g);
                this.spTouch.nextFrame();
                break;
            }
            case 1: {
                this.textInstruction.draw(g);
                this.spTouch.paint(g);
                this.spTouch.nextFrame();
                break;
            }
            case 2: {
                this.textInstruction.draw(g);
                this.btnOk.paint(g);
                break;
            }
            case 3: {
                this.textInstruction.draw(g);
                this.btnOk.paint(g);
                break;
            }
            case 4: {
                this.textInstruction.draw(g);
                break;
            }
            case 5: {
                this.textInstruction.draw(g);
                this.btnOk.paint(g);
                break;
            }
        }
    }

    public void kolisiAlien(Graphics g, Alien alien) {
        int i;
        int indColl = -1;
        for (i = 0; i < this.tebing.length; ++i) {
            if (this.tebing[i].posY < alien.posY - 100 || !this.tebing[i].collision(alien)) continue;
            indColl = i;
        }
        if (indColl != -1) {
            alien.dasarY = this.tebing[indColl].posY;
            if (alien.jeda && this.tebing[indColl].getStatus() != TebingLangit.NORMAL) {
                alien.posX = this.tebing[indColl].isKeKiri() ? (alien.posX -= this.tebing[indColl].getKecGerak()) : (alien.posX += this.tebing[indColl].getKecGerak());
            }
        } else {
            alien.dasarY = alien.posY + alien.height >= dasarY ? 400 - alien.imgAlien.getHeight() - 40 : 400;
        }
        if (this.state == 2) {
            for (i = 0; i < coin.length; ++i) {
                if (StageTutorial.coin[i].posY < alien.posY - 100 || !coin[i].collision(alien.sprAlien)) continue;
                if (!alien.equals(this.hero) || !AlienJump.soundOn || alien == this.hero) {
                    // empty if block
                }
                coin[i].setVisible(false);
                alien.tambahKekuatan();
                if (alien == this.hero) {
                    this.scoreStage += 50;
                    this.sam.addSA(new ScoreAnimation(50, this.hero.posX, this.hero.posY));
                    this.setFramePower();
                }
                if (alien.getJumlahKekuatan() < 5) continue;
                this.nextTutorial(3);
            }
        }
        if (alien.jurus && (alien.jenisAlien == 1 || alien.jenisAlien == 4)) {
            for (i = 0; i < this.player.length; ++i) {
                if (this.player[i] == alien) continue;
                alien.collisionJurus(this.player[i]);
            }
        }
    }

    public void update() {
        if (this.nextTutorial) {
            if (this.spBenar.getFrame() >= 10) {
                this.spBenar.setVisible(false);
                this.nextTutorial = false;
                this.state = this.tempState;
            }
            this.spBenar.nextFrame();
        }
        if (this.hero.lompat) {
            if (!start) {
                // empty if block
            }
            if (this.hero.posY < 160) {
                int i;
                for (i = 0; i < this.tebing.length; ++i) {
                    this.tebing[i].posY += this.hero.kecLompat;
                }
                for (i = 0; i < Stage.coin.length; ++i) {
                    Stage.coin[i].posY += this.hero.kecLompat;
                }
                for (i = 1; i < this.player.length; ++i) {
                    this.player[i].posY += this.hero.kecLompat;
                    this.player[i].dasarY += this.hero.kecLompat;
                }
                Stage.dasarY += this.hero.kecLompat;
                this.hero.dasarY += this.hero.kecLompat;
            }
        } else if (this.hero.jatuh) {
            if (dasarY + 60 <= heightScreen) {
                this.hero.kameraDasar = true;
            } else if (this.hero.posY > heightScreen - 110) {
                int i;
                this.hero.kameraDasar = false;
                for (i = 0; i < this.tebing.length; ++i) {
                    this.tebing[i].posY -= this.hero.kecLompat * 5 / 4;
                }
                for (i = 0; i < Stage.coin.length; ++i) {
                    Stage.coin[i].posY -= this.hero.kecLompat * 5 / 4;
                }
                for (i = 1; i < this.player.length; ++i) {
                    this.player[i].posY -= this.hero.kecLompat * 5 / 4;
                    this.player[i].dasarY -= this.hero.kecLompat * 5 / 4;
                }
                if (dasarY + 60 > heightScreen) {
                    dasarY -= this.hero.kecLompat * 5 / 4;
                }
            }
        }
        this.hero.update();
        this.sam.update();
    }

    private void drawUfo(Graphics g) {
        TebingLangit tbFinish = this.tebing[this.tebing.length - 1];
        this.spUfo.setPosition(tbFinish.posX + tbFinish.width / 2 - this.spUfo.getWidth() / 2, tbFinish.posY - this.spUfo.getHeight());
        this.spUfo.paint(g);
        this.spUfo.nextFrame();
    }

    private void init_hero() {
        switch (jenisHero) {
            case 1: {
                this.hero = new AlienApi(this);
                break;
            }
            case 2: {
                this.hero = new AlienAir(this);
                break;
            }
            case 3: {
                this.hero = new AlienTanah(this);
                break;
            }
            case 4: {
                this.hero = new AlienAngin(this);
            }
        }
        this.hero.posX = 60;
        this.hero.posY = 330;
    }

    private void init_coin() {
        coin = new Coin[20];
        StageTutorial.coin[0] = new Coin(10, 235);
        StageTutorial.coin[1] = new Coin(200, 235);
        StageTutorial.coin[2] = new Coin(60, 165);
        StageTutorial.coin[3] = new Coin(90, 165);
        StageTutorial.coin[4] = new Coin(120, 165);
        StageTutorial.coin[5] = new Coin(200, 115);
        StageTutorial.coin[6] = new Coin(80, 45);
        StageTutorial.coin[7] = new Coin(100, 20);
        StageTutorial.coin[8] = new Coin(120, 45);
        StageTutorial.coin[9] = new Coin(120, -15);
        StageTutorial.coin[10] = new Coin(100, -85);
        StageTutorial.coin[11] = new Coin(20, -125);
        StageTutorial.coin[12] = new Coin(160, -185);
        StageTutorial.coin[13] = new Coin(200, -245);
        StageTutorial.coin[14] = new Coin(90, -245);
        StageTutorial.coin[15] = new Coin(5, -305);
        StageTutorial.coin[16] = new Coin(5, -435);
        StageTutorial.coin[17] = new Coin(65, -615);
        StageTutorial.coin[18] = new Coin(5, -725);
        StageTutorial.coin[19] = new Coin(210, -785);
    }

    public void pointerPressed(int x, int y) {
        if (this.pause) {
            if (x >= this.main_menu.getX() && x <= this.main_menu.getX() + this.main_menu.getWidth() && y >= this.main_menu.getX() && y <= this.main_menu.getY() + this.main_menu.getHeight()) {
                this.main_menu.setFrame(1);
            } else if (x >= this.resume.getX() && x <= this.resume.getX() + this.main_menu.getWidth() && y >= this.resume.getX() && y <= this.resume.getY() + this.main_menu.getHeight()) {
                this.resume.setFrame(1);
            }
        } else {
            this.hero.pointerPressed(x, y);
            if (x >= 240 - this.imgPause.getWidth() && x <= 240 && y >= 0 && y <= this.imgPause.getHeight()) {
                this.pause = true;
            }
            if (this.state == 0 && this.hero.kanan) {
                this.nextTutorial(1);
            } else if (this.state == 1 && this.hero.kiri) {
                this.nextTutorial(2);
            }
        }
        if (this.state == 2 || this.state == 3 || this.state == 5) {
            if (x >= this.btnOk.getX() && x <= this.btnOk.getX() + this.btnOk.getWidth() && y >= this.btnOk.getY() && y <= this.btnOk.getY() + this.btnOk.getHeight()) {
                this.btnOk.setFrame(1);
            } else {
                this.btnOk.setFrame(0);
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.pause) {
            if (x >= this.main_menu.getX() && x <= this.main_menu.getX() + this.main_menu.getWidth() && y >= this.main_menu.getX() && y <= this.main_menu.getY() + this.main_menu.getHeight()) {
                AlienJump.layarSekarang = new MainMenu();
            } else if (x >= this.resume.getX() && x <= this.resume.getX() + this.main_menu.getWidth() && y >= this.resume.getX() && y <= this.resume.getY() + this.main_menu.getHeight()) {
                this.pause = false;
            }
        } else {
            this.hero.pointerReleased(x, y);
        }
        if (this.state == 2 || this.state == 3) {
            this.btnOk.setFrame(0);
            if (x >= this.btnOk.getX() && x <= this.btnOk.getX() + this.btnOk.getWidth() && y >= this.btnOk.getY() && y <= this.btnOk.getY() + this.btnOk.getHeight()) {
                this.btnOk.setVisible(false);
                this.textInstruction.setVisible(false);
                if (this.state == 3) {
                    this.textInstruction = new InstructionBox(0);
                    this.textInstruction.setAlien(jenisHero);
                    this.state = 4;
                }
            }
        }
        if (this.state == 5 && x >= this.btnOk.getX() && x <= this.btnOk.getX() + this.btnOk.getWidth() && y >= this.btnOk.getY() && y <= this.btnOk.getY() + this.btnOk.getHeight()) {
            this.btnOk.setVisible(false);
            this.textInstruction.setVisible(false);
            AlienJump.layarSekarang = new MainMenu();
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.pause) {
            if (!(x >= this.main_menu.getX() && x <= this.main_menu.getX() + this.main_menu.getWidth() && y >= this.main_menu.getX() && y <= this.main_menu.getY() + this.main_menu.getHeight() || x >= this.resume.getX() && x <= this.resume.getX() + this.main_menu.getWidth() && y >= this.resume.getX() && y <= this.resume.getY() + this.main_menu.getHeight())) {
                this.main_menu.setFrame(0);
                this.resume.setFrame(0);
            }
        } else {
            this.hero.pointerDragged(x, y);
            if (this.state == 4 && this.hero.jurus) {
                this.textInstruction.setVisible(false);
                this.nextTutorial(5);
            }
        }
    }

    private void initTutorial1() {
        this.initTebing1();
        this.textInstruction = new InstructionBox(0);
        this.textInstruction.setTextImage("/Tutorial/tutorial-1.png");
        this.spTouch.setPosition(150, 200);
    }

    private void initTebing1() {
        this.tebing = new TebingLangit[3];
        this.tebing[0] = new TebingLangit(Tebing.TEBING_PANJANG, 60, 320, TebingLangit.NORMAL, 0, 0);
        this.tebing[1] = new TebingLangit(Tebing.TEBING_PANJANG, 140, 260, TebingLangit.NORMAL, 0, 0);
        this.tebing[2] = new TebingLangit(Tebing.TEBING_SEDANG, 100, 190, TebingLangit.NORMAL, 0, 0);
    }

    private void initTutorial3() {
        this.initTebing3();
        this.initCoin3();
    }

    private void initTebing3() {
        this.tebing = new TebingLangit[10];
        this.tebing[0] = new TebingLangit(Tebing.TEBING_PANJANG, 60, 320, TebingLangit.NORMAL, 0, 0);
        this.tebing[1] = new TebingLangit(Tebing.TEBING_PANJANG, 140, 260, TebingLangit.NORMAL, 0, 0);
        this.tebing[2] = new TebingLangit(Tebing.TEBING_SEDANG, 100, 190, TebingLangit.NORMAL, 0, 0);
        this.tebing[3] = new TebingLangit(Tebing.TEBING_PANJANG, 60, 120, TebingLangit.NORMAL, 0, 0);
        this.tebing[4] = new TebingLangit(Tebing.TEBING_PENDEK, 60, 40, TebingLangit.NORMAL, 0, 0);
        this.tebing[5] = new TebingLangit(Tebing.TEBING_SEDANG, 130, 20, TebingLangit.NORMAL, 0, 0);
        this.tebing[6] = new TebingLangit(Tebing.TEBING_SEDANG, 180, -50, TebingLangit.NORMAL, 0, 0);
        this.tebing[7] = new TebingLangit(Tebing.TEBING_PENDEK, 160, -120, TebingLangit.NORMAL, 0, 0);
        this.tebing[8] = new TebingLangit(Tebing.TEBING_PANJANG, 50, -180, TebingLangit.NORMAL, 0, 0);
        this.tebing[9] = new TebingLangit(Tebing.TEBING_SEDANG, 150, -240, TebingLangit.NORMAL, 0, 0);
    }

    private void initCoin3() {
        coin = new Coin[5];
        for (int i = 3; i < 8; ++i) {
            StageTutorial.coin[i - 3] = new Coin(this.tebing[i].posX + 10, this.tebing[i].posY - 30);
        }
    }

    private void nextTutorial(int tutorial) {
        this.spBenar.setVisible(true);
        this.tempState = tutorial;
        this.nextTutorial = true;
        switch (tutorial) {
            case 0: {
                break;
            }
            case 1: {
                this.textInstruction = new InstructionBox(0);
                this.textInstruction.setTextImage("/Tutorial/tutorial-2.png");
                this.spTouch.setPosition(0, 200);
                break;
            }
            case 2: {
                this.textInstruction = new InstructionBox(1);
                this.textInstruction.setTextImage("/Tutorial/tutorial-3.png");
                this.btnOk.setPosition(70, 260);
                this.initTutorial3();
                break;
            }
            case 3: {
                this.textInstruction = new InstructionBox(1);
                if (Stage.jenisHero == 4) {
                    this.textInstruction.setTextImage("/Tutorial/tutorial-angin.png");
                } else if (Stage.jenisHero == 3) {
                    this.textInstruction.setTextImage("/Tutorial/tutorial-tanah.png");
                } else if (Stage.jenisHero == 1) {
                    this.textInstruction.setTextImage("/Tutorial/tutorial-api.png");
                } else if (Stage.jenisHero == 2) {
                    this.textInstruction.setTextImage("/Tutorial/tutorial-air.png");
                }
                this.btnOk.setPosition(70, 260);
                this.btnOk.setVisible(true);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.textInstruction = new InstructionBox(1);
                this.textInstruction.setTextImage("/Tutorial/tutorial-selesai.png");
                this.btnOk.setPosition(70, 260);
                this.btnOk.setVisible(true);
            }
        }
    }
}

