/*
 * Decompiled with CFR 0.152.
 */
package Database;

import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class Database {
    protected RecordStore rs;
    private final String REC;

    public Database(String nama_record) {
        this.REC = nama_record;
    }

    public void openRecStore() {
        try {
            this.rs = RecordStore.openRecordStore((String)this.REC, (boolean)true);
        }
        catch (Exception e) {
            this.db(e.toString());
        }
    }

    public void closeRecStore() {
        try {
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            this.db(e.toString());
        }
    }

    private void deleteRecStore() {
        if (RecordStore.listRecordStores() != null) {
            try {
                RecordStore.deleteRecordStore((String)this.REC);
            }
            catch (Exception e) {
                this.db(e.toString());
            }
        }
    }

    public void writeRecord(String str) {
        byte[] rec = str.getBytes();
        try {
            this.rs.addRecord(rec, 0, rec.length);
        }
        catch (Exception e) {
            this.db(e.toString());
        }
    }

    public void setRecord(int id, String str) {
        byte[] rec = str.getBytes();
        try {
            this.rs.setRecord(id, rec, 0, rec.length);
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public String[] readRecords() {
        try {
            byte[] recData = new byte[5];
            String[] data = new String[this.rs.getNumRecords()];
            for (int i = 1; i <= this.rs.getNumRecords(); ++i) {
                if (this.rs.getRecordSize(i) > recData.length) {
                    recData = new byte[this.rs.getRecordSize(i)];
                }
                int len = this.rs.getRecord(i, recData, 0);
                data[i - 1] = new String(recData, 0, len);
                System.out.println("Record #" + i + ": " + new String(recData, 0, len));
                System.out.println("------------------------------");
            }
            return data;
        }
        catch (Exception e) {
            this.db(e.toString());
            return null;
        }
    }

    private void db(String str) {
        System.err.println("Msg: " + str);
    }
}

