/*
 * Decompiled with CFR 0.152.
 */
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashScreenView
extends Canvas {
    private Image[] images;
    private int timeout;
    private Displayable next;
    private Display display;
    private Timer timer;
    private int currentImage = -1;

    public SplashScreenView(Display display, Displayable next, Image[] images, int timeout) {
        this.images = images;
        this.timeout = timeout;
        this.next = next;
        this.display = display;
        this.setFullScreenMode(true);
        this.currentImage = images != null && images.length > 0 ? 0 : -1;
    }

    public void paint(Graphics graphics) {
        if (this.currentImage != -1) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.images[this.currentImage], this.getWidth() / 2, this.getHeight() / 2, 3);
        }
    }

    protected void pointerPressed(int x, int y) {
        this.showNextImage();
    }

    protected void keyPressed(int keyCode) {
        this.showNextImage();
    }

    protected void showNotify() {
        this.currentImage = this.images != null && this.images.length > 0 ? 0 : -1;
        this.scheduleTimer();
    }

    private void scheduleTimer() {
        try {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new CountDown(), this.timeout);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void closeSplashScreen() {
        this.timer.cancel();
        this.currentImage = -1;
        this.repaint();
        this.display.setCurrent(this.next);
    }

    private void showNextImage() {
        if (this.currentImage + 1 >= this.images.length) {
            this.closeSplashScreen();
        } else if (this.currentImage != -1) {
            ++this.currentImage;
            this.repaint();
            this.scheduleTimer();
        }
    }

    private class CountDown
    extends TimerTask {
        private CountDown() {
        }

        public void run() {
            SplashScreenView.this.showNextImage();
        }
    }
}

