/*
 * Decompiled with CFR 0.152.
 */
package mediasampler.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.StopTimeControl;
import javax.microedition.media.control.ToneControl;
import javax.microedition.media.control.VolumeControl;
import mediasampler.data.Media;

public class PlayerPool
implements PlayerListener {
    protected Vector players;
    protected Vector medias;
    protected int latency;
    boolean supportMultiPlayer = true;
    private int actualVolume = 0;
    private int globalVolume = 0;
    private int midletVolume = 100;
    private long stopTime = Long.MAX_VALUE;
    private int realizedSoundIndex;

    public PlayerPool(int latency) {
        this.latency = latency;
        this.players = new Vector();
        this.medias = new Vector();
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("volumeChanged")) {
            this.actualVolume = (int)((float)this.globalVolume / 100.0f * (float)this.midletVolume);
        } else if (event.equals("com.nokia.external.volume.event")) {
            this.globalVolume = Integer.parseInt(eventData.toString());
            this.actualVolume = (int)((float)this.globalVolume / 100.0f * (float)this.midletVolume);
        }
    }

    public boolean isMediaSupported(String mimeType) {
        String[] types = Manager.getSupportedContentTypes(null);
        int i = 0;
        while (i < types.length) {
            if (mimeType.toLowerCase().equals(types[i].toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addMedia(Media media) throws MediaException {
        String mimeType = media.getType();
        if (!this.isMediaSupported(mimeType)) {
            throw new MediaException("Type " + mimeType + " is not supported!");
        }
        this.addSoundObject(media);
    }

    public boolean supportsMulplePlayers() {
        return this.supportMultiPlayer;
    }

    public void addToneSequence(byte[] sequence) throws MediaException {
        if (!this.isMediaSupported("audio/x-tone-seq")) {
            throw new MediaException("Tone (audio/x-tone-seq) is not supported!");
        }
        this.addSoundObject(sequence);
    }

    private Player createTonePlayer(byte[] sequence) throws MediaException, IOException {
        Player player = Manager.createPlayer((String)"device://tone");
        player.addPlayerListener((PlayerListener)this);
        player.realize();
        ToneControl tc = (ToneControl)player.getControl("ToneControl");
        tc.setSequence(sequence);
        return player;
    }

    private Player createPlayer(Object media) throws MediaException, IOException {
        if (media instanceof byte[]) {
            return this.createTonePlayer((byte[])media);
        }
        return this.createPlayer((Media)media);
    }

    private Player createPlayer(Media media) throws MediaException, IOException {
        InputStream is = media.getInputStream();
        String mediaType = media.getType();
        Player player = Manager.createPlayer((InputStream)is, (String)mediaType);
        player.addPlayerListener((PlayerListener)this);
        player.realize();
        player.prefetch();
        return player;
    }

    public void releaseResources() {
        this.discardAll();
        this.players.removeAllElements();
        this.medias.removeAllElements();
    }

    public void setVolumeLevel(int volume) {
        this.midletVolume = volume;
        this.updateVolumeLevel();
    }

    public void setStopTime(long time) {
        this.stopTime = time;
        this.updateStopTime();
    }

    public void playSound(int index, String mode) throws MediaException {
        if (this.supportMultiPlayer) {
            if (index >= 0 && index < this.players.size()) {
                Player player = (Player)this.players.elementAt(index);
                this.startPlayer(player, mode);
            }
        } else {
            if (index == this.realizedSoundIndex) {
                Player player = (Player)this.players.elementAt(0);
                this.startPlayer(player, mode);
                return;
            }
            this.discardAll();
            this.players.removeAllElements();
            try {
                Object obj = this.medias.elementAt(index);
                Player player = this.createPlayer(obj);
                this.players.addElement(player);
                this.updateStopTime();
                this.updateVolumeLevel();
                this.realizedSoundIndex = index;
                this.startPlayer(player, mode);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void startPlayer(Player player, String mode) {
        try {
            if (player != null) {
                if (player.getState() == 100) {
                    player.prefetch();
                    player.realize();
                }
                if (player.getState() != 0 && player.getState() != 400) {
                    if (mode.equals("CONT")) {
                        player.setLoopCount(-1);
                    }
                    player.start();
                }
            }
        }
        catch (MediaException e) {
            this.discardPlayer(player);
        }
    }

    public void pausePlayer() {
        int i = 0;
        while (i < this.players.size()) {
            try {
                Player player = (Player)this.players.elementAt(i);
                player.stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public void discardPlayer(Player player) {
        if (player != null) {
            player.close();
        }
    }

    public void discardAll() {
        int i = 0;
        while (i < this.players.size()) {
            Player player = (Player)this.players.elementAt(i);
            this.discardPlayer(player);
            ++i;
        }
    }

    private void updateVolumeLevel() {
        int size = this.players.size();
        int i = 0;
        while (i < size) {
            Player player = (Player)this.players.elementAt(i);
            VolumeControl control = (VolumeControl)player.getControl("VolumeControl");
            this.actualVolume = (int)((float)this.globalVolume / 100.0f * (float)this.midletVolume);
            control.setLevel(this.midletVolume);
            ++i;
        }
    }

    private void updateStopTime() {
        int size = this.players.size();
        int i = 0;
        while (i < size) {
            Player player = (Player)this.players.elementAt(i);
            StopTimeControl control = (StopTimeControl)player.getControl("StopTimeControl");
            control.setStopTime(this.stopTime);
            ++i;
        }
    }

    private void addSoundObject(Object sndObject) throws MediaException {
        block9: {
            if (!this.supportMultiPlayer) {
                this.medias.addElement(sndObject);
            } else {
                try {
                    Player player = this.createPlayer(sndObject);
                    this.players.addElement(player);
                    this.medias.addElement(sndObject);
                }
                catch (MediaException se) {
                    if (this.supportMultiPlayer && this.players.size() == 1) {
                        Player failedPlayer = (Player)this.players.elementAt(0);
                        this.discardPlayer(failedPlayer);
                        this.players.removeElementAt(0);
                        try {
                            Player player = this.createPlayer(sndObject);
                            this.supportMultiPlayer = false;
                            this.medias.addElement(sndObject);
                            this.players.removeAllElements();
                            this.players.addElement(player);
                            this.realizedSoundIndex = this.medias.size() - 1;
                        }
                        catch (MediaException me) {
                            throw me;
                        }
                        catch (IOException iOException) {
                            break block9;
                        }
                    }
                    throw se;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

