/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class dbClass {
    String[] _data = new String[10];
    byte[] data = new byte[100];
    RecordStore dbConn;

    public void setData(String[] levelStr) {
        int i = 0;
        while (i < 10) {
            this._data[i] = levelStr[i];
            ++i;
        }
    }

    public String[] getData() {
        return this._data;
    }

    public void writeRecord() throws IOException, RecordStoreException {
        this.openDB();
        this.toByteArray();
        this.closeDB();
    }

    public void openDB() {
        try {
            this.dbConn = RecordStore.openRecordStore((String)"ScoreDb", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void toByteArray() throws IOException, RecordStoreException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        this.toDataStream(dout);
        this.data = bout.toByteArray();
        this.dbConn.addRecord(this.data, 0, this.data.length);
        bout.flush();
        bout.close();
        dout.close();
    }

    private void toDataStream(DataOutputStream dout) throws IOException {
        String[] str = this._data;
        dout.writeUTF(str[0]);
        dout.flush();
    }

    public int getRecordNumber() throws RecordStoreNotOpenException {
        int n = 0;
        this.openDB();
        try {
            n = this.dbConn.getNumRecords();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        this.closeDB();
        return n;
    }

    public void readData() throws RecordStoreNotOpenException, RecordStoreException {
        this.openDB();
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(this.data);
            DataInputStream din = new DataInputStream(bin);
            int i = 0;
            this.dbConn.getRecord(1, this.data, 0);
            while (i < this._data.length) {
                this._data[i] = din.readUTF();
                ++i;
            }
            din.close();
            bin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closeDB();
    }

    public void readRecord(int recNo) {
        this.openDB();
        try {
            this.fromByteArray(this.data, recNo);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.closeDB();
    }

    public void readRecords() {
        this.openDB();
        try {
            byte[] recData = new byte[5];
            int i = 1;
            while (i <= this.dbConn.getNumRecords()) {
                if (this.dbConn.getRecordSize(i) > recData.length) {
                    recData = new byte[this.dbConn.getRecordSize(i)];
                    int len = this.dbConn.getRecord(i, recData, 0);
                    this._data[i] = new String(recData, 0, len);
                }
                ++i;
            }
            this.closeDB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fromByteArray(byte[] data, int recNumber) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        this.fromDataStream(din, recNumber);
        din.close();
    }

    public void fromDataStream(DataInputStream din, int recordNumber) throws IOException {
        try {
            this.dbConn.getRecord(recordNumber, this.data, 0);
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        this._data[recordNumber] = din.readUTF();
    }

    public void closeDB() {
        try {
            this.dbConn.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void deletedb() {
        if (RecordStore.listRecordStores() != null) {
            try {
                RecordStore.deleteRecordStore((String)"ScoreDb");
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
    }
}

