/*
 * Decompiled with CFR 0.152.
 */
package Bubble;

import Bubble.BubbleIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BubbleConfig {
    private byte version = 1;
    private String currentPlayerName = "Dummy";
    private short soundVolume = (short)40;
    private int language = 0;
    public static final int LANGUAGE_ENGLISH = 0;
    public static final int LANGUAGE_CHINESE = 1;

    public void write() {
        BubbleIO.write("Config", this.configToByteArray());
    }

    public void read() {
        byte[] data = BubbleIO.read("Config");
        if (data != null) {
            this.byteArrayToConfig(data);
        }
    }

    private byte[] configToByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeByte(2);
            os.writeUTF(this.getCurrentPlayerName());
            os.writeShort(this.getSoundVolume());
            os.writeShort(this.getLanguage());
            os.close();
        }
        catch (IOException ex) {
            System.out.println("BubbleConfig error");
            System.out.println(ex.toString());
        }
        return baos.toByteArray();
    }

    private void byteArrayToConfig(byte[] data) {
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            this.version = is.readByte();
            if (this.version >= 1) {
                this.setCurrentPlayerName(is.readUTF());
                this.setSoundVolume(is.readShort());
            }
            if (this.version >= 2) {
                System.out.println("version 2in bubbleconfig");
            }
            is.close();
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
    }

    public String getCurrentPlayerName() {
        return this.currentPlayerName;
    }

    public void setCurrentPlayerName(String currentPlayerName) {
        this.currentPlayerName = currentPlayerName;
    }

    public short getSoundVolume() {
        return this.soundVolume;
    }

    public void setSoundVolume(short soundVolume) {
        this.soundVolume = soundVolume;
    }

    public int getLanguage() {
        return this.language;
    }
}

