/*
 * Decompiled with CFR 0.152.
 */
package Bubble;

import Bubble.Ball;
import Bubble.GameWindow;
import java.util.Random;

public class BubbleLogic {
    GameWindow puyowindow;
    public static final int numDroppingBalls = 2;
    public static final int puyoEmpty = 0;
    public static final int puyoRed = 1;
    public static final int puyoGreen = 2;
    public static final int puyoBule = 3;
    public static final int puyoYellow = 4;
    public static final int puyoSpecial = 5;
    public static final int flagToBeRemoved = 16;
    private int score = 0;
    public boolean running = false;
    public Ball[] droppingBalls;
    public int[][] accumBalls;
    Random rand;
    boolean[][] flagMatrix;
    int connCompCounter;

    public BubbleLogic() {
        this.initAll();
    }

    public void initAll() {
        this.accumBalls = new int[7][16];
        this.flagMatrix = new boolean[7][16];
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (i == 0 || j == 0 || i == 6 || j == 15) {
                    this.accumBalls[i][j] = 5;
                    this.flagMatrix[i][j] = true;
                    continue;
                }
                this.accumBalls[i][j] = 0;
                this.flagMatrix[i][j] = false;
            }
        }
        this.rand = new Random(System.currentTimeMillis());
        this.initDroppingBalls();
        this.score = 0;
    }

    public boolean initDroppingBalls() {
        this.droppingBalls = new Ball[2];
        for (int i = 0; i < 2; ++i) {
            this.droppingBalls[i] = new Ball();
            this.droppingBalls[i].x = 2 + i;
            this.droppingBalls[i].y = 14;
            if (this.accumBalls[this.droppingBalls[i].x][this.droppingBalls[i].y] != 0) {
                for (int j = 0; j < 2; ++j) {
                    this.droppingBalls[i] = null;
                }
                return false;
            }
            this.droppingBalls[i].color = this.rand.nextInt(4) + 1;
            this.droppingBalls[i].dropped = false;
        }
        return true;
    }

    public boolean drop() {
        int i;
        boolean dropped = false;
        for (i = 0; i < 2; ++i) {
            if (this.accumBalls[this.droppingBalls[i].x][this.droppingBalls[i].y - 1] == 0) continue;
            this.accumBalls[this.droppingBalls[i].x][this.droppingBalls[i].y] = this.droppingBalls[i].color;
            this.droppingBalls[i].dropped = true;
            dropped = true;
            break;
        }
        if (dropped) {
            int numDroppedBalls = 0;
            while (numDroppedBalls != 2) {
                numDroppedBalls = 0;
                for (int i2 = 0; i2 < 2; ++i2) {
                    if (this.droppingBalls[i2].dropped) {
                        ++numDroppedBalls;
                        continue;
                    }
                    if (this.accumBalls[this.droppingBalls[i2].x][this.droppingBalls[i2].y - 1] != 0) {
                        this.accumBalls[this.droppingBalls[i2].x][this.droppingBalls[i2].y] = this.droppingBalls[i2].color;
                        this.droppingBalls[i2].dropped = true;
                        continue;
                    }
                    --this.droppingBalls[i2].y;
                }
            }
        } else {
            for (i = 0; i < 2; ++i) {
                --this.droppingBalls[i].y;
            }
        }
        return dropped;
    }

    private void removeConnComp(int x, int y, int color) {
        if (this.accumBalls[x][y] != color) {
            return;
        }
        this.accumBalls[x][y] = this.accumBalls[x][y] | 0x10;
        this.removeConnComp(x, y - 1, color);
        this.removeConnComp(x, y + 1, color);
        this.removeConnComp(x - 1, y, color);
        this.removeConnComp(x + 1, y, color);
    }

    private void checkConnComp(int x, int y, int color) {
        if (this.accumBalls[x][y] != color) {
            return;
        }
        ++this.connCompCounter;
        this.flagMatrix[x][y] = true;
        if (!this.flagMatrix[x][y - 1]) {
            this.checkConnComp(x, y - 1, color);
        }
        if (!this.flagMatrix[x][y + 1]) {
            this.checkConnComp(x, y + 1, color);
        }
        if (!this.flagMatrix[x - 1][y]) {
            this.checkConnComp(x - 1, y, color);
        }
        if (!this.flagMatrix[x + 1][y]) {
            this.checkConnComp(x + 1, y, color);
        }
    }

    public boolean checkAccumBalls() {
        boolean removed = false;
        for (int i = 1; i < 6; ++i) {
            for (int j = 1; j < 15; ++j) {
                this.connCompCounter = 0;
                for (int m = 1; m < 6; ++m) {
                    for (int k = 1; k < 15; ++k) {
                        this.flagMatrix[m][k] = false;
                    }
                }
                if (this.accumBalls[i][j] == 0 || (this.accumBalls[i][j] & 0x10) != 0 || this.flagMatrix[i][j]) continue;
                this.checkConnComp(i, j, this.accumBalls[i][j]);
                if (this.connCompCounter < 4) continue;
                this.removeConnComp(i, j, this.accumBalls[i][j]);
                this.score += 4 + (this.connCompCounter - 4) * (this.connCompCounter - 4);
                removed = true;
            }
        }
        return removed;
    }

    public void removeBalls() {
        System.out.println("removeBalls.removeBalls11");
        for (int i = 1; i < 6; ++i) {
            for (int j = 1; j < 15; ++j) {
                if ((this.accumBalls[i][j] & 0x10) == 0) continue;
                this.accumBalls[i][j] = 0;
            }
        }
    }

    public boolean freeFalling() {
        boolean unfinished = false;
        for (int i = 1; i < 6; ++i) {
            int j;
            int indexBottom = 0;
            int indexTop = 0;
            for (j = 1; j < 15; ++j) {
                if (this.accumBalls[i][j] != 0) continue;
                indexBottom = j;
                break;
            }
            for (j = 14; j > 0; --j) {
                if (this.accumBalls[i][j] == 0) continue;
                indexTop = j;
                break;
            }
            if (indexTop <= indexBottom) continue;
            for (j = indexBottom; j < indexTop; ++j) {
                this.accumBalls[i][j] = this.accumBalls[i][j + 1];
            }
            this.accumBalls[i][indexTop] = 0;
            unfinished = true;
        }
        return unfinished;
    }

    public void moveLeft() {
        int i;
        int leftMost = Integer.MAX_VALUE;
        for (i = 0; i < 2; ++i) {
            if (this.droppingBalls[i].dropped || this.droppingBalls[i].x >= leftMost) continue;
            leftMost = this.droppingBalls[i].x;
        }
        for (i = 0; i < 2; ++i) {
            if (this.droppingBalls[i].dropped || this.accumBalls[leftMost - 1][this.droppingBalls[i].y] != 0) continue;
            --this.droppingBalls[i].x;
        }
    }

    public void moveRight() {
        int i;
        int rightMost = Integer.MIN_VALUE;
        for (i = 0; i < 2; ++i) {
            if (this.droppingBalls[i].dropped || this.droppingBalls[i].x <= rightMost) continue;
            rightMost = this.droppingBalls[i].x;
        }
        for (i = 0; i < 2; ++i) {
            if (this.droppingBalls[i].dropped || this.accumBalls[rightMost + 1][this.droppingBalls[i].y] != 0) continue;
            ++this.droppingBalls[i].x;
        }
    }

    public void rotateCW() {
        if (this.droppingBalls[0].x == this.droppingBalls[1].x && this.droppingBalls[0].y > this.droppingBalls[1].y) {
            if (this.accumBalls[this.droppingBalls[1].x + 1][this.droppingBalls[1].y] == 0) {
                ++this.droppingBalls[0].x;
                --this.droppingBalls[0].y;
            }
            return;
        }
        if (this.droppingBalls[0].x > this.droppingBalls[1].x && this.droppingBalls[0].y == this.droppingBalls[1].y) {
            if (this.accumBalls[this.droppingBalls[1].x][this.droppingBalls[1].y - 1] == 0) {
                --this.droppingBalls[0].x;
                --this.droppingBalls[0].y;
            }
            return;
        }
        if (this.droppingBalls[0].x == this.droppingBalls[1].x && this.droppingBalls[0].y < this.droppingBalls[1].y) {
            if (this.accumBalls[this.droppingBalls[1].x - 1][this.droppingBalls[1].y] == 0) {
                --this.droppingBalls[0].x;
                ++this.droppingBalls[0].y;
            }
            return;
        }
        if (this.droppingBalls[0].x < this.droppingBalls[1].x && this.droppingBalls[0].y == this.droppingBalls[1].y) {
            if (this.accumBalls[this.droppingBalls[1].x][this.droppingBalls[1].y + 1] == 0) {
                ++this.droppingBalls[0].x;
                ++this.droppingBalls[0].y;
            }
            return;
        }
    }

    public void rotateCCW() {
        if (this.droppingBalls[0].x == this.droppingBalls[1].x && this.droppingBalls[0].y > this.droppingBalls[1].y) {
            if (this.accumBalls[this.droppingBalls[0].x + 1][this.droppingBalls[0].y] == 0) {
                ++this.droppingBalls[1].x;
                ++this.droppingBalls[1].y;
            }
            return;
        }
        if (this.droppingBalls[0].x < this.droppingBalls[1].x && this.droppingBalls[0].y == this.droppingBalls[1].y) {
            if (this.accumBalls[this.droppingBalls[0].x][this.droppingBalls[0].y + 1] == 0) {
                --this.droppingBalls[1].x;
                ++this.droppingBalls[1].y;
            }
            return;
        }
        if (this.droppingBalls[0].x == this.droppingBalls[1].x && this.droppingBalls[0].y < this.droppingBalls[1].y) {
            if (this.accumBalls[this.droppingBalls[0].x - 1][this.droppingBalls[0].y] == 0) {
                --this.droppingBalls[1].x;
                --this.droppingBalls[1].y;
            }
            return;
        }
        if (this.droppingBalls[0].x > this.droppingBalls[1].x && this.droppingBalls[0].y == this.droppingBalls[1].y) {
            if (this.accumBalls[this.droppingBalls[0].x][this.droppingBalls[0].y - 1] == 0) {
                ++this.droppingBalls[1].x;
                --this.droppingBalls[1].y;
            }
            return;
        }
    }

    public int getScore() {
        return this.score;
    }
}

