/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class VKey {
    static final int COLOR_FONT = 0;
    static final int COLOR_SELECTOR = 0xFF0000;
    static final int COLOR_ARROWS = 0;
    static char[] chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    static int[] chAlphabet;
    static int iNbOfChars;
    private static int iPosY;
    private static int iPosX;
    private static int iKeyboardX;
    private static int iKeyboardY;
    private static int SqrPosY;
    private static int SqrW;
    private static int SqrH;
    private static int iPosXOffset;
    private static int iWidth;
    static boolean keyReleased;
    static boolean allKeysReleased;
    public static StringBuffer sb;
    private static int iMiddleY;

    public static void initVkey(int w, Font fnt) {
        SqrW = fnt.getHeight() * 2;
        SqrH = fnt.getHeight() * 2;
        iWidth = w;
        iNbOfChars = w / SqrW + 4;
        chAlphabet = new int[iNbOfChars];
        int hlpW = (w >> 1) / SqrW;
        int charPosXoffset = SqrW - fnt.stringWidth("W");
        iPosXOffset = (Defines.WIDTH >> 1) - hlpW * SqrW;
        SqrPosY = SqrH - fnt.getHeight() >> 1;
        iMiddleY = fnt.getHeight() >> 1;
        for (int i = 0; i < iNbOfChars; ++i) {
            VKey.chAlphabet[i] = i;
        }
        iKeyboardX = Defines.WIDTH - iWidth >> 1;
        iKeyboardY = 0;
    }

    public static void setPosition(int y) {
        iPosY = y;
    }

    public static char getChar() {
        int idx = chAlphabet[iNbOfChars >> 1] - 1 < 0 ? 25 : chAlphabet[iNbOfChars >> 1] - 1;
        return chars[idx];
    }

    public static String getString() {
        sb.setLength(0);
        int idx = chAlphabet[iNbOfChars >> 1] - 1 < 0 ? 25 : chAlphabet[iNbOfChars >> 1] - 1;
        return sb.append(chars[idx]).toString();
    }

    public static void updateKeyboard(boolean bLeft, boolean bRight) {
        if (allKeysReleased) {
            return;
        }
        if (bLeft) {
            iPosX += 3;
        }
        if (bRight) {
            iPosX -= 3;
        }
        if (Math.abs(iPosX) >= SqrW - 1) {
            int i;
            if (iPosX < 0) {
                for (i = 0; i < iNbOfChars; ++i) {
                    VKey.chAlphabet[i] = chAlphabet[i] + 1 > 25 ? 0 : chAlphabet[i] + 1;
                }
            }
            if (iPosX > 0) {
                for (i = 0; i < iNbOfChars; ++i) {
                    VKey.chAlphabet[i] = chAlphabet[i] - 1 < 0 ? 25 : chAlphabet[i] - 1;
                }
            }
            iPosX = 0;
            if (keyReleased) {
                allKeysReleased = true;
            }
        }
    }

    public static void paint(Graphics g) {
        g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
        g.setColor(0);
        g.fillTriangle(iKeyboardX, iPosY + iMiddleY, iKeyboardX + 25, iPosY, iKeyboardX + 25, iPosY + (iMiddleY << 1));
        g.fillTriangle(iKeyboardX + iWidth, iPosY + iMiddleY, iKeyboardX + iWidth - 25, iPosY, iKeyboardX + iWidth - 25, iPosY + (iMiddleY << 1));
        g.setClip(iKeyboardX + 26, 0, iWidth - 52, Defines.HEIGHT);
        g.setColor(0);
        for (int i = 0; i < iNbOfChars; ++i) {
            g.drawString(chars[chAlphabet[i]] + "", (i - 1) * SqrW + iPosX + iPosXOffset, iPosY, 0);
        }
        g.setColor(0xFF0000);
        g.drawRect(iKeyboardX + (iWidth >> 1) - (SqrW - 1 >> 1), iPosY - SqrPosY, SqrW - 1, SqrH - 1);
        g.drawRect(iKeyboardX + (iWidth >> 1) - (SqrW + 1 >> 1), iPosY - SqrPosY - 1, SqrW + 1, SqrH + 1);
    }

    public static void keyReleased() {
        keyReleased = true;
    }

    public static void keyPressed() {
        keyReleased = false;
        allKeysReleased = false;
    }

    public static int getPosKeyboard() {
        return iPosY;
    }

    public static boolean isVKeyLeft(int x, int y) {
        return y > iPosY - 50 && y < iPosY + (iMiddleY << 1) && x > iKeyboardX && x < iKeyboardX + 50;
    }

    public static boolean isVKeyRight(int x, int y) {
        return y > iPosY - 50 && y < iPosY + (iMiddleY << 1) && x > iKeyboardX + iWidth - 50 && x < iKeyboardX + iWidth;
    }

    public static boolean isVKeySelect(int x, int y) {
        return y > iPosY - 50 && y < iPosY + (iMiddleY << 1) && x < iKeyboardX + iWidth - 50 && x > iKeyboardX + 50;
    }

    static {
        iPosY = 0;
        iPosX = 0;
        iKeyboardX = 0;
        iKeyboardY = 0;
        SqrW = 30;
        SqrH = 30;
        iPosXOffset = 0;
        keyReleased = false;
        allKeysReleased = false;
        sb = new StringBuffer();
        iMiddleY = 0;
    }
}

