/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Button;
import game.DisplayableCanvas;
import game.DrawString;
import game.SystemFont;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class MainMenu {
    RecordStore soundSettings;
    DrawString ds;
    DisplayableCanvas dc;
    int MENU_MODE;
    final byte SPLASH;
    final byte MAIN_MENU;
    final byte OPTIONS = (byte)2;
    final byte HELP = (byte)3;
    final byte ABOUT = (byte)4;
    final byte GAME_TYPE = (byte)5;
    final byte CHECK_SAMEPHONE = (byte)6;
    int WIDTH;
    int HEIGHT;
    Image imgLogo;
    Image imgSplash;
    Image imgAboutLogo;
    Image imgOptionHeading;
    Image imgaboutHeading;
    Font font = Font.getFont((int)0, (int)1, (int)16);
    boolean isContinue;
    boolean onoffs = true;
    boolean onoffv = true;
    Button butContinue;
    Button butNewGame;
    Button butOption;
    Button butHelp;
    Button butAbout;
    Button butExit;
    Button butSoundon;
    Button butSoundoff;
    Button butVibrateon;
    Button butVibrateoff;
    Button buttonHelpData;
    Button buttonHome;
    int noofline;
    int selectIndex = -1;
    byte optionIndex = (byte)-1;

    public MainMenu(DisplayableCanvas dc, DrawString ds) {
        this.SPLASH = 0;
        this.MAIN_MENU = 1;
        this.dc = dc;
        this.ds = ds;
        this.WIDTH = dc.WIDTH;
        this.HEIGHT = dc.HEIGHT;
    }

    public void resetSplash() {
        try {
            this.imgLogo = Image.createImage((String)"/res/menu/logo.png");
            this.imgSplash = Image.createImage((String)"/res/menu/splash.png");
            this.imgAboutLogo = Image.createImage((String)"/res/menu/aboutLogo.png");
        }
        catch (Exception io) {
            io.printStackTrace();
        }
        this.readSettings();
        this.MENU_MODE = 0;
    }

    public void storeSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"GameSettings", (boolean)true);
            byte[] Byte = null;
            ByteArrayOutputStream bout = new ByteArrayOutputStream(60);
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeBoolean(this.onoffs);
            dout.writeBoolean(this.onoffv);
            dout.flush();
            dout.close();
            Byte = bout.toByteArray();
            dout.close();
            if (this.soundSettings.getNumRecords() > 0) {
                this.soundSettings.setRecord(1, Byte, 0, Byte.length);
            } else {
                this.soundSettings.addRecord(Byte, 0, Byte.length);
            }
            this.soundSettings.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"GameSettings", (boolean)true);
            if (this.soundSettings.getNumRecords() > 0) {
                byte[] Byte = null;
                Byte = this.soundSettings.getRecord(1);
                DataInputStream din = new DataInputStream(new ByteArrayInputStream(Byte));
                this.onoffs = din.readBoolean();
                this.onoffv = din.readBoolean();
                din.close();
            } else {
                byte[] Byte = null;
                ByteArrayOutputStream bout = new ByteArrayOutputStream(60);
                DataOutputStream dout = new DataOutputStream(bout);
                this.onoffs = true;
                this.onoffv = true;
                dout.writeBoolean(this.onoffs);
                dout.writeBoolean(this.onoffv);
                dout.flush();
                dout.close();
                Byte = bout.toByteArray();
                dout.close();
                this.soundSettings.addRecord(Byte, 0, Byte.length);
            }
            this.soundSettings.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetMainMenu() {
        if (this.imgSplash == null) {
            try {
                this.imgSplash = Image.createImage((String)"/res/menu/menuBg.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.butContinue == null) {
            this.butContinue = new Button(0, 0, "/res/menu/continue0.png", "/res/menu/continue1.png");
            this.butNewGame = new Button(0, 0, "/res/menu/play0.png", "/res/menu/play1.png");
            this.butOption = new Button(0, 0, "/res/menu/option0.png", "/res/menu/option1.png");
            this.butHelp = new Button(0, 0, "/res/menu/help0.png", "/res/menu/help1.png");
            this.butAbout = new Button(0, 0, "/res/menu/about0.png", "/res/menu/about1.png");
            this.butExit = new Button(0, 0, "/res/menu/exit0.png", "/res/menu/exit1.png");
            this.butSoundon = new Button(this.WIDTH - 200 + 46, 120, "/res/menu/soundon0.png", "/res/menu/soundon1.png");
            this.butSoundoff = new Button(this.WIDTH - 200 + 45, 120, "/res/menu/soundoff0.png", "/res/menu/soundoff1.png");
            this.butVibrateon = new Button(this.WIDTH - 200 + 31, this.butSoundon.y + 50, "/res/menu/vibrateon0.png", "/res/menu/vibrateon1.png");
            this.butVibrateoff = new Button(this.WIDTH - 200 + 30, this.butSoundon.y + 50, "/res/menu/vibrateoff0.png", "/res/menu/vibrateoff1.png");
            this.buttonHome = new Button(this.WIDTH - 35, 5, "/res/menu/homeIcon0.png", "/res/menu/homeIcon1.png");
        }
        if (this.isContinue) {
            this.butContinue.setXY(this.WIDTH - 200 + (200 - this.butContinue.width >> 1), 45);
            this.butNewGame.setXY(this.WIDTH - 200 + (200 - this.butNewGame.width >> 1), this.butContinue.y + 33);
            this.butOption.setXY(this.WIDTH - 200 + (200 - this.butOption.width >> 1), this.butNewGame.y + 33);
            this.butHelp.setXY(this.WIDTH - 200 + (200 - this.butHelp.width >> 1), this.butOption.y + 33);
            this.butAbout.setXY(this.WIDTH - 200 + (200 - this.butAbout.width >> 1), this.butHelp.y + 33);
            this.butExit.setXY(this.WIDTH - 200 + (200 - this.butExit.width >> 1), this.butAbout.y + 33);
        } else {
            this.butNewGame.setXY(this.WIDTH - 200 + (200 - this.butNewGame.width >> 1), 45);
            this.butOption.setXY(this.WIDTH - 200 + (200 - this.butOption.width >> 1), this.butNewGame.y + 40);
            this.butHelp.setXY(this.WIDTH - 200 + (200 - this.butHelp.width >> 1), this.butOption.y + 40);
            this.butAbout.setXY(this.WIDTH - 200 + (200 - this.butAbout.width >> 1), this.butHelp.y + 40);
            this.butExit.setXY(this.WIDTH - 200 + (200 - this.butExit.width >> 1), this.butAbout.y + 40);
        }
        this.MENU_MODE = 1;
    }

    public void resetOptions() {
    }

    public void resetHelp() {
        try {
            if (this.buttonHelpData == null) {
                this.buttonHelpData = new Button(200, 90, 200, 170, -1, -1);
                this.buttonHelpData.setMovable(true);
                this.buttonHelpData.nameX = 200;
                this.buttonHelpData.nameY = 90;
                this.buttonHelpData.name = "Memorize the instructions that appear on the screen and repeat it in the same order by touching the right butterfly.";
                this.noofline = SystemFont.findLines(this.buttonHelpData.name, SystemFont.font1, this.buttonHelpData.width);
            }
            this.buttonHelpData.nameY = this.buttonHelpData.y;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetAbout() {
    }

    public void resetMode(int gameMode) {
        switch (gameMode) {
            case 0: {
                this.resetSplash();
                break;
            }
            case 1: {
                if (this.imgSplash == null) {
                    try {
                        this.imgSplash = Image.createImage((String)"/res/menu/menuBg.png");
                        this.imgOptionHeading = Image.createImage((String)"/res/menu/option0.png");
                        this.imgaboutHeading = Image.createImage((String)"/res/menu/aboutHeading.png");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.resetMainMenu();
                break;
            }
            case 2: {
                this.resetOptions();
                break;
            }
            case 3: {
                this.resetHelp();
                break;
            }
            case 4: {
                this.resetAbout();
                break;
            }
            case 5: {
                break;
            }
        }
        this.MENU_MODE = gameMode;
        this.dc.resetAdSetXY();
    }

    protected void pointerPressed(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isContinue && (result = this.butContinue.isPressed(x, y))) {
                    this.selectIndex = 0;
                }
                if (result) break;
                result = this.butNewGame.isPressed(x, y);
                if (!result) {
                    result = this.butOption.isPressed(x, y);
                    if (!result) {
                        result = this.butHelp.isPressed(x, y);
                        if (!result) {
                            result = this.butAbout.isPressed(x, y);
                            if (!result) {
                                result = this.butExit.isPressed(x, y);
                                if (!result) break;
                                this.selectIndex = 5;
                                break;
                            }
                            this.selectIndex = 4;
                            break;
                        }
                        this.selectIndex = 3;
                        break;
                    }
                    this.selectIndex = 2;
                    break;
                }
                this.selectIndex = 1;
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                } else {
                    result = this.butSoundoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                } else {
                    result = this.butVibrateoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                }
                if (result) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 3: {
                result = this.buttonHelpData.isPressed(x, y);
                if (!result && x > this.WIDTH - 30 && y > this.buttonHelpData.y && y < this.buttonHelpData.y + this.buttonHelpData.height) {
                    this.buttonHelpData.touchY = y;
                }
                if (result) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 4: {
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 5: {
                break;
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                result = this.butExit.isReleased(x, y);
                if (result) {
                    this.selection();
                } else {
                    if (this.isContinue && (result = this.butContinue.isReleased(x, y))) {
                        this.selection();
                    }
                    if (!result) {
                        result = this.butNewGame.isReleased(x, y);
                        if (result) {
                            this.selection();
                        } else {
                            result = this.butOption.isReleased(x, y);
                            if (result) {
                                this.selection();
                            } else {
                                result = this.butHelp.isReleased(x, y);
                                if (result) {
                                    this.selection();
                                } else {
                                    result = this.butAbout.isReleased(x, y);
                                    if (result) {
                                        this.selection();
                                    }
                                }
                            }
                        }
                    }
                }
                this.selectIndex = -1;
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isReleased(x, y);
                    if (result) {
                        this.onoffs = false;
                    }
                } else {
                    result = this.butSoundoff.isReleased(x, y);
                    if (result) {
                        this.onoffs = true;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isReleased(x, y);
                    if (result) {
                        this.onoffv = false;
                    }
                } else {
                    result = this.butVibrateoff.isReleased(x, y);
                    if (result) {
                        this.onoffv = true;
                    }
                }
                if (!result && (result = this.buttonHome.isReleased(x, y))) {
                    this.resetMainMenu();
                }
                this.storeSettings();
                this.optionIndex = (byte)-1;
                break;
            }
            case 3: {
                result = this.buttonHome.isReleased(x, y);
                if (result) {
                    this.MENU_MODE = 1;
                    break;
                }
                this.buttonHelpData.isReleased(x, y);
                break;
            }
            case 4: {
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
                break;
            }
            case 5: {
                break;
            }
        }
        if (!result) {
            result = this.dc.addBannerReleased(x, y);
        }
    }

    private void selection() {
        switch (this.selectIndex) {
            case 0: {
                this.dc.continueGame();
                this.dc.PLAY_MODE = this.dc.LASTPLAY_MODE;
                this.dc.getClass();
                this.dc.GAME_MODE = 1;
                break;
            }
            case 1: {
                this.dc.timingCounter = 0;
                this.dc.level = 1;
                this.dc.isSinglePlayer = true;
                this.dc.isSingleHandSet = false;
                for (int i = 0; i < this.dc.randLevel.length; ++i) {
                    this.dc.randLevel[i] = 0;
                }
                this.dc.initGame();
                this.isContinue = true;
                break;
            }
            case 2: {
                this.resetMode(2);
                break;
            }
            case 3: {
                this.resetMode(3);
                break;
            }
            case 4: {
                this.resetMode(4);
                break;
            }
            case 5: {
                this.dc.stopSound(0);
                this.dc.stopSound(1);
                this.dc.stopSound(2);
                this.storeSettings();
                this.dc.midlet.exit();
            }
        }
        this.dc.resetAdSetXY();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void input(int KEY) {
        block28: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block27: {
                                block26: {
                                    if (KEY == this.dc.KEY_LEFT_SOFT) break block26;
                                    if (KEY != 42) break block27;
                                }
                                this.dc.KEY = 0;
                                break block28;
                            }
                            if (KEY == this.dc.KEY_RIGHT_SOFT) break block29;
                            if (KEY != 35) break block30;
                        }
                        switch (this.MENU_MODE) {
                            case 2: 
                            case 3: 
                            case 4: {
                                this.resetMainMenu();
                                break;
                            }
                        }
                        break block28;
                    }
                    if (KEY == 49) break block28;
                    if (KEY != 50) break block31;
                    switch (this.MENU_MODE) {
                        case 1: {
                            if (this.isContinue) {
                                this.selectIndex = (this.selectIndex + 5) % 6;
                                break;
                            }
                            --this.selectIndex;
                            if (this.selectIndex == 0) {
                                this.selectIndex = 5;
                                break;
                            }
                            if (this.selectIndex != 6) break;
                            this.selectIndex = 5;
                            break;
                        }
                        case 2: {
                            if (this.optionIndex == 0) {
                                this.optionIndex = 1;
                                break;
                            }
                            if (this.optionIndex != 1) break;
                            this.optionIndex = 0;
                            break;
                        }
                    }
                    this.dc.KEY = 0;
                    break block28;
                }
                if (KEY != 56) break block32;
                switch (this.MENU_MODE) {
                    case 1: {
                        if (this.isContinue) {
                            this.selectIndex = (this.selectIndex + 1) % 6;
                            break;
                        }
                        ++this.selectIndex;
                        if (this.selectIndex == 6) {
                            this.selectIndex = 1;
                            break;
                        }
                        break block28;
                    }
                    case 2: {
                        if (this.optionIndex == 0) {
                            this.optionIndex = 1;
                            break;
                        }
                        if (this.optionIndex == 1) {
                            this.optionIndex = 0;
                            break;
                        }
                        break block28;
                    }
                }
                break block28;
            }
            if (KEY == 53) {
                switch (this.MENU_MODE) {
                    case 1: {
                        this.selection();
                        break;
                    }
                    case 2: {
                        if (this.optionIndex == 0) {
                            this.onoffs = !this.onoffs;
                        } else if (this.optionIndex == 1) {
                            this.onoffv = !this.onoffv;
                        }
                        this.storeSettings();
                        break;
                    }
                }
            }
        }
        this.dc.KEY = 0;
    }

    public void run() {
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter <= 60) break;
                this.imgSplash = null;
                this.resetMode(1);
                this.dc.refreshTheBannerAd();
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter < 40) {
                    g.setColor(0xFFFFFF);
                    g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                    g.drawImage(this.imgLogo, this.WIDTH >> 1, this.HEIGHT >> 1, 1 | 2);
                    break;
                }
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                break;
            }
            case 1: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                if (this.isContinue) {
                    this.butContinue.paint(g);
                }
                this.butNewGame.paint(g);
                this.butOption.paint(g);
                this.butHelp.paint(g);
                this.butAbout.paint(g);
                this.butExit.paint(g);
                if (this.isContinue && this.selectIndex == 0 && this.butContinue.buttonState == 0) {
                    this.butContinue.buttonState = 1;
                    this.butContinue.paint(g);
                    this.butContinue.buttonState = 0;
                }
                switch (this.selectIndex) {
                    case 1: {
                        if (this.butNewGame.buttonState != 0) break;
                        this.butNewGame.buttonState = 1;
                        this.butNewGame.paint(g);
                        this.butNewGame.buttonState = 0;
                        break;
                    }
                    case 2: {
                        if (this.butOption.buttonState != 0) break;
                        this.butOption.buttonState = 1;
                        this.butOption.paint(g);
                        this.butOption.buttonState = 0;
                        break;
                    }
                    case 3: {
                        if (this.butHelp.buttonState != 0) break;
                        this.butHelp.buttonState = 1;
                        this.butHelp.paint(g);
                        this.butHelp.buttonState = 0;
                        break;
                    }
                    case 4: {
                        if (this.butAbout.buttonState != 0) break;
                        this.butAbout.buttonState = 1;
                        this.butAbout.paint(g);
                        this.butAbout.buttonState = 0;
                        break;
                    }
                    case 5: {
                        if (this.butExit.buttonState != 0) break;
                        this.butExit.buttonState = 1;
                        this.butExit.paint(g);
                        this.butExit.buttonState = 0;
                    }
                }
                break;
            }
            case 2: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgOptionHeading, this.WIDTH - 200 + (200 - this.imgOptionHeading.getWidth() >> 1), 65, 0x10 | 4);
                if (this.onoffs) {
                    this.butSoundon.paint(g);
                } else {
                    this.butSoundoff.paint(g);
                }
                if (this.onoffv) {
                    this.butVibrateon.paint(g);
                } else {
                    this.butVibrateoff.paint(g);
                }
                if (this.optionIndex == 0) {
                    if (this.onoffs) {
                        if (this.butSoundon.buttonState == 0) {
                            this.butSoundon.buttonState = 1;
                            this.butSoundon.paint(g);
                            this.butSoundon.buttonState = 0;
                        }
                    } else if (this.butSoundoff.buttonState == 0) {
                        this.butSoundoff.buttonState = 1;
                        this.butSoundoff.paint(g);
                        this.butSoundoff.buttonState = 0;
                    }
                } else if (this.optionIndex == 1) {
                    if (this.onoffv) {
                        if (this.butVibrateon.buttonState == 0) {
                            this.butVibrateon.buttonState = 1;
                            this.butVibrateon.paint(g);
                            this.butVibrateon.buttonState = 0;
                        }
                    } else if (this.butVibrateoff.buttonState == 0) {
                        this.butVibrateoff.buttonState = 1;
                        this.butVibrateoff.paint(g);
                        this.butVibrateoff.buttonState = 0;
                    }
                }
                this.buttonHome.paint(g);
                break;
            }
            case 3: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                this.butHelp.buttonState = 0;
                this.butHelp.paint(g, this.WIDTH - 200 + (200 - this.butHelp.width >> 1), 55);
                g.setColor(5776147);
                g.setFont(SystemFont.font1);
                SystemFont.drawText(this.buttonHelpData.name, g, this.buttonHelpData.nameX, this.buttonHelpData.nameY, this.buttonHelpData.width, 1);
                g.setClip(0, 0, this.WIDTH, this.HEIGHT);
                this.buttonHome.paint(g);
                break;
            }
            case 4: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                if (this.imgAboutLogo != null) {
                    g.drawImage(this.imgAboutLogo, 215, 45, 4 | 0x10);
                }
                this.buttonHome.paint(g);
                break;
            }
            case 5: {
                break;
            }
        }
        if (this.MENU_MODE != 0 && this.dc.buttonAd != null) {
            this.dc.buttonAd.paint(g);
        }
    }

    protected void pointerDragged(int x, int y) {
    }
}

