/*
 * Decompiled with CFR 0.152.
 */
package net.awpspace.caromini;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.awpspace.caromini.ButtonListener;

public class Button {
    public Image up;
    public Image down;
    public boolean isPressed;
    public int x;
    public int y;
    private ButtonListener listener;

    public Button(Image up, Image down, int x, int y) {
        this.up = up;
        this.down = down;
        this.x = x;
        this.y = y;
    }

    public void setListener(ButtonListener listener) {
        this.listener = listener;
    }

    public void actionUp(int x, int y) {
        if (this.isPressed && this.contain(x, y) && this.listener != null) {
            this.listener.actionUp();
        }
        this.isPressed = false;
    }

    public void actionDown(int x, int y) {
        if (this.contain(x, y)) {
            System.out.println(String.valueOf(x) + "  " + y);
            this.isPressed = true;
            if (this.listener != null) {
                this.listener.actionDown();
            }
        }
    }

    public boolean contain(int x, int y) {
        return this.x < x && x < this.x + this.up.getWidth() && this.y < y && y < this.y + this.up.getHeight();
    }

    public void draw(Graphics g) {
        if (this.isPressed) {
            g.drawImage(this.down, this.x, this.y, 20);
        } else {
            g.drawImage(this.up, this.x, this.y, 20);
        }
    }
}

